/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.model.layout;

import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.ui.dtp.model.layout.BorderLayout;
import com.kingdee.bos.ui.dtp.model.layout.FlowLayout;
import com.kingdee.bos.ui.dtp.model.layout.KDLayout;
import com.kingdee.bos.ui.dtp.model.layout.LabelContainerLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.SameGridLayout;
import com.kingdee.bos.ui.dtp.model.layout.SmartLayout;
import com.kingdee.bos.ui.dtp.model.layout.SplitLayout;
import com.kingdee.bos.ui.dtp.model.layout.TabbedPaneLayout;
import com.kingdee.bos.ui.dtp.model.layout.TableLayout;
import com.kingdee.bos.ui.dtp.model.layout.TreeViewLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebAccordionPaneLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebBorderLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebSplitLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebToolBarLayout;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.util.StringUtils;
import java.awt.Insets;
import java.util.HashMap;

public class LayoutConverter {
    private LayoutConverter() {
    }

    public static LayoutInfo convertToInfo(Layout layout) {
        if (layout == null) {
            return null;
        }
        String type = layout.getClass().getName();
        LayoutInfo info = new LayoutInfo();
        info.setName(layout.getName());
        info.setType(type.substring(type.lastIndexOf(46) + 1));
        info.setValue(LayoutConverter.getValue(layout));
        return info;
    }

    public static Layout convertToLayoutObj(LayoutInfo info) {
        Layout layout;
        if (info == null) {
            layout = new XYLayout();
        } else {
            String type = info.getType();
            layout = "SameGridLayout".equalsIgnoreCase(type) ? new SameGridLayout() : ("XYLayout".equalsIgnoreCase(type) ? new XYLayout() : ("BorderLayout".equalsIgnoreCase(type) ? new BorderLayout() : ("FlowLayout".equalsIgnoreCase(type) ? new FlowLayout() : ("KDLayout".equalsIgnoreCase(type) ? new KDLayout() : ("SplitLayout".equalsIgnoreCase(type) ? new SplitLayout() : ("WebSplitLayout".equalsIgnoreCase(type) ? new WebSplitLayout() : ("TabbedPaneLayout".equalsIgnoreCase(type) ? new TabbedPaneLayout() : ("WebAccordionPaneLayout".equalsIgnoreCase(type) ? new WebAccordionPaneLayout() : ("WebBorderLayout".equalsIgnoreCase(type) ? new WebBorderLayout() : ("TreeViewLayout".equalsIgnoreCase(type) ? new TreeViewLayout() : ("LabelContainerLayout".equalsIgnoreCase(type) ? new LabelContainerLayout() : ("WebLayout".equals(type) ? new WebLayout() : ("TableLayout".equals(type) ? new TableLayout() : ("WebToolBarLayout".equals(type) ? new WebToolBarLayout() : ("SmartLayout".equals(type) ? new SmartLayout() : new XYLayout())))))))))))))));
            layout.setName(info.getName());
            LayoutConverter.convertValue(info.getValue(), layout);
        }
        return layout;
    }

    private static String getValue(Layout layout) {
        if (layout == null || layout instanceof XYLayout) {
            return "";
        }
        if (layout instanceof SameGridLayout) {
            SameGridLayout s = (SameGridLayout)layout;
            Insets ins = s.getInsets();
            return s.getRowsNum() + "," + s.getColsNum() + "," + ins.top + "," + ins.left + "," + ins.bottom + "," + ins.right;
        }
        if (layout instanceof BorderLayout) {
            BorderLayout b = (BorderLayout)layout;
            return b.getHgap() + "," + b.getVgap();
        }
        if (layout instanceof WebLayout) {
            WebLayout b = (WebLayout)layout;
            return String.valueOf(b.getHorizontalAlign()) + "," + String.valueOf(b.getVerticalAlign()) + "," + String.valueOf(b.isAllowVerticalAlign());
        }
        if (layout instanceof SmartLayout) {
            return ((SmartLayout)layout).toDataString();
        }
        if (layout instanceof TableLayout) {
            TableLayout b = (TableLayout)layout;
            return b.getLayoutInfoValue();
        }
        return "";
    }

    private static void convertValue(String value, Layout layout) {
        if (layout instanceof SameGridLayout) {
            String[] tokens = StringUtils.split((String)value, (String)",");
            if (tokens.length == 6) {
                SameGridLayout slayout = (SameGridLayout)layout;
                slayout.setRowsNum(Integer.parseInt(tokens[0]));
                slayout.setColsNum(Integer.parseInt(tokens[1]));
                Insets ins = new Insets(Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4]), Integer.parseInt(tokens[5]));
                slayout.setInsets(ins);
            }
        } else if (layout instanceof BorderLayout) {
            String[] tokens = StringUtils.split((String)value, (String)",");
            if (tokens.length == 2) {
                BorderLayout blayout = (BorderLayout)layout;
                blayout.setHgap(Integer.parseInt(tokens[0]));
                blayout.setVgap(Integer.parseInt(tokens[1]));
            }
        } else if (layout instanceof WebLayout) {
            WebLayout webLayout = (WebLayout)layout;
            String[] tokens = StringUtils.split((String)value, (String)",");
            webLayout.setHorizontalAlign(Integer.parseInt(tokens[0]));
            webLayout.setVerticalAlign(Integer.parseInt(tokens[1]));
            webLayout.setAllowVerticalAlign(Boolean.valueOf(tokens[2]));
        } else if (layout instanceof SmartLayout) {
            ((SmartLayout)layout).parse(value);
        } else if (layout instanceof TableLayout) {
            LayoutConverter.convertTableLayoutValue((TableLayout)layout, value);
        }
    }

    private static void convertTableLayoutValue(TableLayout layout, String value) {
        String[] tokens = StringUtils.split((String)value, (String)";");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < tokens.length; ++i) {
            String[] kv = StringUtils.split((String)tokens[i], (String)"=");
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
        try {
            layout.setRows(Integer.parseInt((String)map.get("Rows")));
            layout.setColumns(Integer.parseInt((String)map.get("Columns")));
            layout.setCellSpacing(Integer.parseInt((String)map.get("CellSpacing")));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error table layout argument");
        }
    }
}

