/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.weblayout;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Properties;

public class WebLayoutData
implements Serializable,
Cloneable {
    public Unit width;
    public int height;
    public boolean newLine;

    public WebLayoutData(Unit width, int height, boolean newLine) {
        this.width = width;
        this.height = height;
        this.newLine = newLine;
    }

    public WebLayoutData(Unit width, int height) {
        this(width, height, false);
    }

    public String toCSSString() {
        StringBuffer sb = new StringBuffer();
        sb.append("width:" + (this.width.isPercentage ? this.width.toString() : this.width.toString() + "px"));
        sb.append("; height:" + this.height + "px");
        return sb.toString();
    }

    public String toString() {
        return "width=" + this.width.toString() + ";height=" + this.height + ";newLine=" + this.newLine;
    }

    public static WebLayoutData parse(String s) {
        if (s == null) {
            return null;
        }
        byte[] buffer = s.replace(';', '\n').getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        Properties prop = new Properties();
        try {
            prop.load(is);
            Unit width = Unit.parse(prop.getProperty("width"));
            int height = Integer.parseInt(prop.getProperty("height"));
            boolean newLine = Boolean.valueOf(prop.getProperty("newLine"));
            return new WebLayoutData(width, height, newLine);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error format");
        }
    }

    public boolean equals(Object data) {
        if (!(data instanceof WebLayoutData)) {
            return false;
        }
        WebLayoutData wld = (WebLayoutData)data;
        return this.height == wld.height && this.newLine == wld.newLine && this.width.equals(wld.width);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Unit
    implements Serializable,
    Cloneable {
        public float number;
        public boolean isPercentage;

        public static Unit absolute(int number) {
            if (number < 0) {
                throw new IllegalArgumentException("number < 0");
            }
            Unit u = new Unit();
            u.number = number;
            u.isPercentage = false;
            return u;
        }

        public static Unit percentage(float number) {
            if (number < 0.0f || number > 1.0f) {
                throw new IllegalArgumentException("number < 0 || number > 1");
            }
            Unit u = new Unit();
            u.number = number;
            u.isPercentage = true;
            return u;
        }

        public static Unit parse(String s) {
            if (s.endsWith("%")) {
                float n = Float.parseFloat(s.substring(0, s.length() - 1));
                return Unit.percentage(n / 100.0f);
            }
            int i = Integer.parseInt(s);
            return Unit.absolute(i);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Unit)) {
                return false;
            }
            Unit unit = (Unit)obj;
            return this.number == unit.number && this.isPercentage == unit.isPercentage;
        }

        public String toString() {
            if (this.isPercentage) {
                return (int)(this.number * 100.0f) + "%";
            }
            return String.valueOf((int)this.number);
        }
    }
}

