/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.netfile;

import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFTPImpl;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileInputStreamFTPImpl;
import com.kingdee.bos.service.netfile.NetFileOuputStreamFTPImpl;
import com.kingdee.bos.service.netfile.NetFileSource;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class NetFileFactoryFTPImpl
implements NetFileFactory {
    private static HashMap factories = new HashMap();
    private NetFileSource fileSource;

    private NetFileFactoryFTPImpl(NetFileSource fileSource) {
        this.fileSource = fileSource;
    }

    static NetFileFactory getNetFileFactory(NetFileSource fileSource) {
        String fileSrcID = fileSource.getFileSourceIdentifier();
        if (factories.get(fileSrcID) == null) {
            NetFileFactoryFTPImpl factory = new NetFileFactoryFTPImpl(fileSource);
            factories.put(fileSrcID, factory);
            return factory;
        }
        return (NetFileFactory)factories.get(fileSrcID);
    }

    @Override
    public NetFile createNetFile(String pathName) {
        return new NetFileFTPImpl(this.fileSource, pathName);
    }

    @Override
    public NetFile createNetFile(NetFile file, String pathName) {
        return new NetFileFTPImpl(file, pathName);
    }

    @Override
    public InputStream createNetFileInputStream(NetFile file) throws FileNotFoundException {
        return new NetFileInputStreamFTPImpl(file);
    }

    @Override
    public OutputStream createNetFileOutputStream(NetFile file) throws FileNotFoundException {
        return new NetFileOuputStreamFTPImpl(file);
    }

    @Override
    public OutputStream createNetFileOutputStream(NetFile file, boolean append) throws FileNotFoundException {
        return new NetFileOuputStreamFTPImpl(file, append);
    }
}

