/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.netfile;

import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileInputStreamLocalImpl;
import com.kingdee.bos.service.netfile.NetFileLocalImpl;
import com.kingdee.bos.service.netfile.NetFileOuputStreamLocalImpl;
import com.kingdee.bos.service.netfile.NetFileSource;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class NetFileFactoryLocalImpl
implements NetFileFactory {
    private static HashMap factories = new HashMap();
    private NetFileSource fileSource;

    private NetFileFactoryLocalImpl(NetFileSource fileSource) {
        this.fileSource = fileSource;
    }

    static synchronized NetFileFactory getNetFileFactory(NetFileSource fileSource) {
        String fileSrcID = fileSource.getFileSourceIdentifier();
        if (factories.get(fileSrcID) == null) {
            NetFileFactoryLocalImpl factory = new NetFileFactoryLocalImpl(fileSource);
            factories.put(fileSrcID, factory);
            return factory;
        }
        return (NetFileFactory)factories.get(fileSrcID);
    }

    @Override
    public NetFile createNetFile(String pathName) {
        return new NetFileLocalImpl(this.fileSource, pathName);
    }

    @Override
    public NetFile createNetFile(NetFile file, String pathName) {
        return new NetFileLocalImpl(file, pathName);
    }

    @Override
    public InputStream createNetFileInputStream(NetFile file) throws FileNotFoundException {
        return new NetFileInputStreamLocalImpl(file);
    }

    @Override
    public OutputStream createNetFileOutputStream(NetFile file) throws FileNotFoundException {
        return new NetFileOuputStreamLocalImpl(file);
    }

    @Override
    public OutputStream createNetFileOutputStream(NetFile file, boolean append) throws FileNotFoundException {
        return new NetFileOuputStreamLocalImpl(file, append);
    }
}

