/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.netfile;

import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.util.Uuid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class NetFileInputStreamFTPImpl
extends InputStream {
    private Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.netfile.NetFileInputStreamFTPImpl");
    private FileInputStream in = null;
    private String tempDir = System.getProperty("java.io.tmpdir");
    private String tempPath = null;

    public NetFileInputStreamFTPImpl(NetFile file) throws FileNotFoundException {
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file.getPath() + " cann't be found!");
        }
        try {
            FTPClient client = file.getFileSource().getFTPClient();
            this.tempPath = this.tempDir + File.separator + Uuid.create() + ".dat";
            client.get(this.tempPath, file.getPath());
            this.in = new FileInputStream(this.tempPath);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new FileNotFoundException();
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        File file = new File(this.tempPath);
        file.delete();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

