/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.netfile;

import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileSource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class NetFileLocalImpl
implements NetFile {
    private File file;
    private NetFileSource source;
    private String absolutePathName;

    public NetFileLocalImpl(NetFileSource fileSource, String pathName) {
        if (!pathName.startsWith(File.separator)) {
            pathName = File.separator + pathName;
        }
        this.source = fileSource;
        this.file = new File(fileSource.getLocalFilePath() + pathName);
        this.absolutePathName = this.file.getAbsolutePath();
    }

    public NetFileLocalImpl(NetFile parent, String pathName) {
        if (!pathName.startsWith(File.separator)) {
            pathName = File.separator + pathName;
        }
        this.source = parent.getFileSource();
        this.file = new File(parent.getPath() + pathName);
        this.absolutePathName = this.file.getAbsolutePath();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public String getPath() {
        return this.absolutePathName;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public String[] list() {
        return this.file.list();
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public boolean renameTo(NetFile newFile) {
        if (newFile == null) {
            throw new NullPointerException();
        }
        return this.file.renameTo(new File(newFile.getPath()));
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public NetFileSource getFileSource() {
        return this.source;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.file.toURL();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }
}

