/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.netfile;

import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.util.Uuid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class NetFileOuputStreamFTPImpl
extends OutputStream {
    private Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.netfile.NetFileOuputStreamFTPImpl");
    private String tempDir = System.getProperty("java.io.tmpdir");
    private String tempPath = null;
    private NetFile netFile = null;
    private FileOutputStream out = null;

    public NetFileOuputStreamFTPImpl(NetFile netFile) throws FileNotFoundException {
        this.netFile = netFile;
        this.tempPath = this.tempDir + "\\" + Uuid.create() + ".dat";
        this.out = new FileOutputStream(this.tempPath);
    }

    public NetFileOuputStreamFTPImpl(NetFile netFile, boolean append) throws FileNotFoundException {
        this.out = new FileOutputStream(netFile.getPath(), append);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.out.close();
        File tempFile = new File(this.tempPath);
        try (FileInputStream in = null;){
            in = new FileInputStream(tempFile);
            FTPClient client = this.netFile.getFileSource().getFTPClient();
            client.put(in, this.netFile.getPath());
            in.close();
            tempFile.delete();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

