/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.netfile;

import com.kingdee.bos.service.netfile.InvalidateNetFileSourceException;
import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.bos.service.netfile.ftp.FTPException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import sun.net.ftp.FtpClient;

public class NetFileSource {
    public static final String FTP_SERVER_NAME = "FTP_SERVER_NAME";
    public static final String FTP_SERVER_PORT = "FTP_SERVER_PORT";
    public static final String FTP_USERNAME = "FTP_USERNAME";
    public static final String FTP_USERPASS = "FTP_USERPASS";
    public static final String FTP_ROOTPATH = "FTP_ROOTPATH";
    public static final String LOCALFILE_PATH = "LOCALFILE_PATH";
    private Logger logger;
    private String serverName;
    private int port;
    private String userName;
    private String userPass;
    private String ftpRootPath;
    private String shareFilePath;
    private boolean isFTPServer;
    private boolean isFileServer;

    public NetFileSource(String uri) throws InvalidateNetFileSourceException {
        block12: {
            this.logger = Logger.getLogger((String)"com.kingdee.bos.service.netfile.NetFileSource");
            this.isFTPServer = false;
            this.isFileServer = false;
            try {
                URL source = new URL(uri);
                if (source.getProtocol().equalsIgnoreCase("ftp")) {
                    this.serverName = source.getHost();
                    this.port = source.getPort();
                    this.ftpRootPath = source.getPath();
                    StringTokenizer token = new StringTokenizer(source.getQuery());
                    StringTokenizer tempToken = null;
                    while (token.hasMoreTokens()) {
                        tempToken = new StringTokenizer(token.nextToken("&"));
                        String temp = tempToken.nextToken("=");
                        if (temp.equalsIgnoreCase("UserName")) {
                            this.userName = tempToken.nextToken("=");
                            continue;
                        }
                        if (!temp.equalsIgnoreCase("Password")) continue;
                        this.userPass = tempToken.nextToken("=");
                    }
                    try {
                        InetSocketAddress addr = new InetSocketAddress(this.serverName, this.port);
                        FtpClient client = FtpClient.create(addr);
                        client.login(this.userName, null, this.userPass);
                        client.close();
                    }
                    catch (Exception e) {
                        throw new InvalidateNetFileSourceException("Invalidate FTP File Source");
                    }
                    this.logger.debug((Object)(this.serverName + this.port + this.ftpRootPath + this.userName + this.userPass));
                    this.isFTPServer = true;
                    break block12;
                }
                if (source.getProtocol().equalsIgnoreCase("file")) {
                    if (source.getHost() != null && source.getHost().length() > 0) {
                        this.shareFilePath = File.separator + File.separator + source.getHost() + source.getFile().replace('/', File.separatorChar);
                    } else if (File.separatorChar != source.getFile().charAt(0)) {
                        this.shareFilePath = source.getFile().replace('/', File.separatorChar);
                        this.shareFilePath = this.shareFilePath.substring(1);
                    } else {
                        this.shareFilePath = source.getFile().replace('/', File.separatorChar);
                    }
                    this.isFileServer = true;
                }
            }
            catch (MalformedURLException e) {
                this.logger.debug((Object)e);
                throw new InvalidateNetFileSourceException("Invalid File Source!");
            }
        }
    }

    public NetFileSource(Hashtable env) throws InvalidateNetFileSourceException {
        this.logger = Logger.getLogger((String)"com.kingdee.bos.service.netfile.NetFileSource");
        this.isFTPServer = false;
        this.isFileServer = false;
        if (env.containsKey(LOCALFILE_PATH)) {
            this.shareFilePath = (String)env.get(LOCALFILE_PATH);
            this.isFileServer = true;
        } else {
            this.serverName = (String)env.get(FTP_SERVER_NAME);
            this.port = Integer.parseInt((String)env.get(FTP_SERVER_PORT));
            this.userName = (String)env.get(FTP_USERNAME);
            this.userPass = (String)env.get(FTP_USERPASS);
            this.ftpRootPath = (String)env.get(FTP_ROOTPATH);
            try {
                InetSocketAddress addr = new InetSocketAddress(this.serverName, this.port);
                FtpClient client = FtpClient.create(addr);
                client.login(this.userName, null, this.userPass);
                client.close();
            }
            catch (Exception e) {
                throw new InvalidateNetFileSourceException("Invalidate FTP File Source");
            }
        }
    }

    public boolean isFTPSource() {
        return this.isFTPServer;
    }

    public boolean isFileSource() {
        return this.isFileServer;
    }

    public boolean isValidate() {
        if (this.isFTPServer) {
            try {
                InetSocketAddress addr = new InetSocketAddress(this.serverName, this.port);
                FtpClient client = FtpClient.create(addr);
                client.login(this.userName, null, this.userPass);
                client.close();
                return true;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                return false;
            }
        }
        if (this.isFileServer) {
            File file = new File(this.shareFilePath);
            return file.exists();
        }
        return false;
    }

    public String getLocalFilePath() {
        return this.shareFilePath;
    }

    public String getFileSourceIdentifier() {
        if (this.isFTPServer) {
            return "FTP_" + this.serverName + "_" + this.port + "_" + this.userName + "_" + this.ftpRootPath.toLowerCase();
        }
        if (this.isFileServer) {
            return "LocalFile_" + this.shareFilePath.toLowerCase();
        }
        return null;
    }

    public FTPClient getFTPClient() throws IOException, FTPException {
        FTPClient ftpClient = new FTPClient(this.serverName, this.port);
        ftpClient.login(this.userName, this.userPass);
        ftpClient.chdir(this.ftpRootPath);
        return ftpClient;
    }

    public String getRoot() {
        if (this.isFTPServer) {
            return this.ftpRootPath;
        }
        if (this.isFileServer) {
            return this.shareFilePath;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetFileSource)) {
            return false;
        }
        NetFileSource source = (NetFileSource)o;
        return this.getFileSourceIdentifier().equalsIgnoreCase(source.getFileSourceIdentifier());
    }

    public int hashCode() {
        return this.getFileSourceIdentifier().hashCode();
    }
}

