/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ng.pubsub;

import com.kingdee.bos.ng.pubsub.RssCacheInfo;
import com.kingdee.bos.ng.pubsub.RssDelegateThread;
import com.kingdee.bos.ng.pubsub.RssItem;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class RssDelegate {
    Logger logger = Logger.getLogger((Class)RssDelegate.class);
    public RssItem[] rssItems = null;
    public static RssDelegate delegate;
    public static Map cache;

    public static synchronized RssDelegate getInstance() {
        if (delegate == null) {
            delegate = new RssDelegate();
        }
        return delegate;
    }

    public RssItem[] getRssItem(String rssAddress) {
        RssCacheInfo result = this.getCacheInfo(rssAddress);
        if (result == null) {
            result = new RssCacheInfo();
            result.setUpTime(new Date());
            RssItem[] items = this.getRssItemNoCache(rssAddress);
            result.setRssItems(items);
            cache.put(rssAddress, result);
        }
        return result.getRssItems();
    }

    private RssCacheInfo getCacheInfo(String rssAddress) {
        try {
            long time;
            RssCacheInfo result = (RssCacheInfo)cache.get(rssAddress);
            if (result != null && (time = System.currentTimeMillis() - result.getUpTime().getTime()) < 300000L) {
                this.logger.debug((Object)"cache \u547d\u4e2d");
                return result;
            }
            this.logger.debug((Object)"cache \u4e0d\u547d\u4e2d");
        }
        catch (Throwable t) {
            this.logger.error((Object)("\u83b7\u53d6cache\u5f02\u5e38\uff01rssAddress=" + rssAddress), t);
        }
        return null;
    }

    public RssItem[] getRssItemNoCache(String rssAddress) {
        try {
            List itemList = this.parser(rssAddress);
            RssItem[] items = new RssItem[itemList.size()];
            itemList.toArray(items);
            return items;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u4e0d\u80fd\u8bfb\u53d6\u5230 " + rssAddress + "\u6587\u4ef6"), (Throwable)e);
            return new RssItem[0];
        }
    }

    public RssItem[] getRssItemNoCacheTimeOut(String rssAddress, int second) {
        RssItem[] items = null;
        RssDelegateThread t = new RssDelegateThread(rssAddress, new ArrayList());
        try {
            t.start();
            Thread.sleep(1000 * second);
            List itemList = t.getResult();
            t.stop();
            if (itemList != null) {
                items = new RssItem[itemList.size()];
                itemList.toArray(items);
            }
            return items;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u4e0d\u80fd\u8bfb\u53d6\u5230 " + rssAddress + "\u6587\u4ef6"), (Throwable)e);
            return new RssItem[0];
        }
    }

    List parser(String rssAddress) throws Exception {
        ArrayList<RssItem> resultList = new ArrayList<RssItem>();
        SAXBuilder builder = new SAXBuilder();
        URL url = new URL(rssAddress);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        Document doc = builder.build(is);
        Element root = doc.getRootElement();
        if (root == null) {
            return resultList;
        }
        List channelList = root.getChildren();
        if (channelList == null || channelList.size() == 0) {
            return resultList;
        }
        Element channel = (Element)channelList.get(0);
        List itemList = channel.getChildren("item");
        for (int i = 0; i < itemList.size(); ++i) {
            Element item = (Element)itemList.get(i);
            RssItem rssItem = new RssItem();
            rssItem.setTitle(item.getChildText("title"));
            rssItem.setLink(item.getChildText("link"));
            rssItem.setDescription(item.getChildText("description"));
            rssItem.setPubDate(item.getChildText("pubDate"));
            rssItem.setAuthor(item.getChildText("author"));
            resultList.add(rssItem);
        }
        return resultList;
    }

    static {
        cache = new HashMap();
    }
}

