/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.client.servicebinding;

import com.kingdee.bos.appframework.client.servicebinding.ConsiderTimeUtil;
import com.kingdee.bos.appframework.client.servicebinding.IActionService;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.rpc.recordSlowReq.RecordMonitor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ForceExitException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActionProxy
implements IItemAction {
    private Map services;
    private Map serviceContext;
    private IItemAction target;
    private static Logger logger = Logger.getLogger(ActionProxy.class);

    public ActionProxy(Map serviceContext, Map services, IItemAction target) {
        if (services != null) {
            this.services = new LinkedHashMap(services);
        }
        if (serviceContext != null) {
            this.serviceContext = new HashMap(serviceContext);
            this.serviceContext.put("ACTION", target);
        }
        this.target = target;
        this.initServices(this.target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            final ActionParams params = new ActionParams(this.target, e);
            ConsiderTimeUtil.openRecord(params.uiName + "$" + params.actionName);
            long startTime = System.currentTimeMillis();
            try {
                RecordMonitor.startLog((String)params.uiName, (String)params.actionName);
                if (params.action.isDaemonRun()) {
                    final MonitorInfo info = new MonitorInfo(params.uiObject.getUITitle() + "-->" + params.action.getValue("ShortDescription"), null, params.uiObject, params.action.isDaemonDialog());
                    SwingWorker worker = new SwingWorker(){

                        @Override
                        public Object construct() {
                            try {
                                if (ActionProxy.this.target.isBatchAction()) {
                                    ActionProxy.this.target.actionPerformed(params.event);
                                } else {
                                    ActionProxy.this.actionPerformedInvoke(params);
                                }
                                return null;
                            }
                            catch (Throwable e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        params.uiObject.handUIException(e);
                                    }
                                });
                                return null;
                            }
                        }

                        @Override
                        public void finished() {
                            ThreadPool.destroyMonitor(info);
                        }
                    };
                    info.setWorker(worker);
                    ThreadPool.addActionThread(info);
                    String runBackGround = this.target.getExtendProperty("enableRunBackGround");
                    if (!StringUtils.isEmpty((String)runBackGround) && "false".equalsIgnoreCase(runBackGround)) {
                        ThreadPool.setBackgroundRunButtonEnabled(false);
                    } else {
                        ThreadPool.setBackgroundRunButtonEnabled(true);
                    }
                    break block9;
                }
                try {
                    if (this.target.isBatchAction()) {
                        this.target.actionPerformed(params.event);
                        break block9;
                    }
                    this.actionPerformedInvoke(params);
                }
                catch (Throwable ex) {
                    params.uiObject.handUIException(ex);
                }
            }
            finally {
                long considerTime = ConsiderTimeUtil.getConsiderTime(params.uiName + "$" + params.actionName);
                ConsiderTimeUtil.closeRecord(params.uiName + "$" + params.actionName);
                RecordMonitor.endLog((String)params.uiName, (String)params.actionName, (long)startTime, (long)considerTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void actionPerformedInvoke(ActionParams params) throws Throwable {
        block29: {
            boolean isExcute = true;
            long startTime = System.currentTimeMillis();
            if (params.action == null) {
                return;
            }
            isExcute = params.action.beforeActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
            if (!isExcute) {
                return;
            }
            UIActionMonitor.startAction((String)params.uiName, (String)params.actionName);
            try {
                if (params.action.getExtendProperty("Mutex") != null) {
                    Uuid uuid = Uuid.create();
                    params.action.putValue("NetUuid", uuid);
                }
                params.action.setActionEvent(params.event);
                Class<?> coreUICalss = Class.forName("com.kingdee.eas.framework.client.CoreUI");
                if (coreUICalss.isAssignableFrom(params.uiObject.getClass())) {
                    try {
                        Method method = params.uiObject.getClass().getMethod("prepareAction", IItemAction.class);
                        IUIActionPostman handler = (IUIActionPostman)method.invoke((Object)params.uiObject, this.target);
                        handler.callHandler();
                    }
                    catch (Exception ite) {
                        params.action.putValue("NetUuid", null);
                        if (ite.getCause() == null) {
                            params.uiObject.handUIException(ite);
                            UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
                            return;
                        }
                        params.uiObject.handUIException(ite.getCause());
                        UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
                        return;
                    }
                }
                if (this.serviceContext != null) {
                    this.serviceContext.put("ACTION", this.target);
                }
                try {
                    if (this.services != null) {
                        this.beforeAction();
                    }
                    logger.info((Object)("ItemActionJDKHandler[BEFORE PointCut] actionName: " + params.actionName));
                    this.target.actionPerformed(params.event);
                    if (params.action != null && params.event != null) {
                        params.action.afterActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                    }
                    if (this.services != null) {
                        if (this.target instanceof ItemAction) {
                            if (this.target != null && !((ItemAction)this.target).isInvokeFailed()) {
                                this.afterAction();
                            }
                        } else {
                            this.afterAction();
                        }
                    }
                    logger.info((Object)("ItemActionJDKHandler[AFTER PointCut] actionName: " + params.actionName));
                }
                catch (ForceExitException forceExitException) {
                    if (params.action != null && params.event != null) {
                        params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                    }
                    params.action.putValue("NetUuid", null);
                    if (this.services != null) {
                        this.finalAction();
                    }
                    this.serviceContext.remove("ACTION");
                    logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                    break block29;
                    catch (Throwable throwable) {
                        if (params.action != null && params.event != null) {
                            params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                        }
                        params.action.putValue("NetUuid", null);
                        if (this.services != null) {
                            this.finalAction();
                        }
                        this.serviceContext.remove("ACTION");
                        logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                        throw throwable;
                    }
                }
                if (params.action != null && params.event != null) {
                    params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                }
                params.action.putValue("NetUuid", null);
                if (this.services != null) {
                    this.finalAction();
                }
                this.serviceContext.remove("ACTION");
                logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                break block29;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
            }
        }
    }

    private void finalAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.finalActionPerformed(this.serviceContext);
        }
    }

    private void initServices(Object target) {
        IActionService itemAction;
        if (this.services == null) {
            this.services = new HashMap();
        }
        if (target instanceof IActionService && (itemAction = (IActionService)target).getServices() != null) {
            this.services.putAll(itemAction.getServices());
        }
        Map globalServices = (Map)this.serviceContext.get("GlobalService");
        if (this.services != null && globalServices != null) {
            this.services.putAll(globalServices);
        }
    }

    private void beforeAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.beforeActionPerformed(this.serviceContext);
        }
    }

    private void afterAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.afterActionPerformed(this.serviceContext);
        }
    }

    @Override
    public void addService(IBindService service) {
        this.target.addService(service);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.target.addPropertyChangeListener(listener);
    }

    @Override
    public void clearServices() {
        this.target.clearServices();
    }

    @Override
    public String getExtendProperty(String key) {
        return this.target.getExtendProperty(key);
    }

    @Override
    public ItemAction getItemAction() {
        return this.target.getItemAction();
    }

    @Override
    public int getItemKind() {
        return this.target.getItemKind();
    }

    @Override
    public String getItemLogicKey() {
        return this.target.getItemLogicKey();
    }

    @Override
    public Map getServices() {
        return this.target.getServices();
    }

    @Override
    public IUIObject getUIObject() {
        return this.target.getUIObject();
    }

    @Override
    public Object getValue(String key) {
        return this.target.getValue(key);
    }

    @Override
    public void innerActionPerformed(String contextName, CoreUIObject uiObj, String actionClassName, String actionMethodName, ActionEvent event) {
        this.target.innerActionPerformed(contextName, uiObj, actionClassName, actionMethodName, event);
    }

    @Override
    public boolean isBindWorkFlow() {
        return this.target.isBindWorkFlow();
    }

    @Override
    public boolean isDaemonDialog() {
        return this.target.isDaemonDialog();
    }

    @Override
    public boolean isDaemonRun() {
        return this.target.isDaemonRun();
    }

    @Override
    public boolean isEnabled() {
        return this.target.isEnabled();
    }

    @Override
    public boolean isVisible() {
        return this.target.isVisible();
    }

    @Override
    public void putValue(String key, Object value) {
        this.target.putValue(key, value);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.target.removePropertyChangeListener(listener);
    }

    @Override
    public void removeServices(IBindService service) {
        this.target.removeServices(service);
    }

    @Override
    public void setBindWorkFlow(boolean bindWorkFlow) {
        this.target.setBindWorkFlow(bindWorkFlow);
    }

    @Override
    public void setDaemonDialog(boolean isDaemonDialog) {
        this.target.setDaemonDialog(isDaemonDialog);
    }

    @Override
    public void setDaemonRun(boolean isDaemonRun) {
        this.target.setDaemonRun(isDaemonRun);
    }

    @Override
    public void setEnabled(boolean b) {
        this.target.setEnabled(b);
    }

    @Override
    public void setExtendProperty(String key, String value) {
        this.target.setExtendProperty(key, value);
    }

    @Override
    public void setItemKind(int i) {
        this.target.setItemKind(i);
    }

    @Override
    public void setItemLogicKey(String logicKey) {
        this.target.setItemLogicKey(logicKey);
    }

    @Override
    public void setUIObject(IUIObject uiObj) {
        this.target.setUIObject(uiObj);
    }

    @Override
    public void setVisible(boolean newValue) {
        this.target.setVisible(newValue);
    }

    @Override
    public void setActionEvent(ActionEvent e) {
        this.target.setActionEvent(e);
    }

    @Override
    public ActionEvent getActionEvent() {
        return this.target.getActionEvent();
    }

    @Override
    public boolean isBatchAction() {
        if (this.target != null) {
            return this.target.isBatchAction();
        }
        return false;
    }

    @Override
    public void setBatchAction(boolean isBatchAction) {
        if (this.target != null) {
            this.target.setBatchAction(isBatchAction);
        }
    }

    static {
        try {
            Class.forName("com.kingdee.bos.rpc.recordSlowReq.RecordMonitor");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class ActionParams {
        public String uiName = "";
        public String actionName = "";
        public ItemAction action = null;
        public ActionEvent event = null;
        public IUIObject uiObject = null;

        public ActionParams(Object delegate, ActionEvent e) {
            if (ActionProxy.this.target instanceof ItemAction && ActionProxy.this.target != null) {
                this.action = (ItemAction)ActionProxy.this.target;
                this.actionName = this.action.getClass().getName();
                if (this.actionName.indexOf("$") >= 0) {
                    this.actionName = this.actionName.substring(this.actionName.indexOf("$") + 1);
                }
                this.uiObject = this.action.getUIObject();
                this.uiName = this.uiObject.getClass().getName();
            }
            this.event = e;
        }
    }
}

