/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.client.servicebinding;

import com.kingdee.bos.appframework.client.servicebinding.ConsiderRecObject;
import com.kingdee.bos.appframework.client.servicebinding.TimespanObject;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ConsiderTimeUtil {
    private static ThreadLocal<Stack<ConsiderRecObject>> considerStack = new ThreadLocal();
    private static final Logger logger = Logger.getLogger(ConsiderTimeUtil.class);

    public static void openRecord(String actionName) {
        Stack<ConsiderRecObject> stack = considerStack.get();
        if (stack == null) {
            stack = new Stack();
            considerStack.set(stack);
        }
        if (stack.size() > 6) {
            logger.info((Object)("\u6808\u6df1\u8d85\u8fc76\uff0c\u4e0d\u518d\u7edf\u8ba1action\u540d\u4e3a\uff1a" + actionName + "\u7684\u601d\u8003\u65f6\u95f4"));
            return;
        }
        ConsiderRecObject considerRecObject = new ConsiderRecObject(actionName);
        logger.info((Object)("\u601d\u8003\u65f6\u95f4\u521d\u59cb\u5316\u7684action\u540d\u4e3a\uff1a" + actionName + ",\u6808\u7684\u5927\u5c0f\u4e3a\uff1a" + stack.size()));
        stack.push(considerRecObject);
    }

    public static void setStartTime(long startTime) {
        ConsiderRecObject peek;
        List<TimespanObject> timespanObjectList;
        Stack<ConsiderRecObject> stack = considerStack.get();
        if (stack != null && !stack.isEmpty() && (timespanObjectList = (peek = stack.peek()).getTimespanObjectList()) != null) {
            if (timespanObjectList.isEmpty()) {
                TimespanObject timespanObject = new TimespanObject(startTime);
                timespanObjectList.add(timespanObject);
            } else if (timespanObjectList.get(timespanObjectList.size() - 1).getEndTime() != 0L) {
                TimespanObject timespanObject = new TimespanObject(startTime);
                timespanObjectList.add(timespanObject);
            }
        }
    }

    public static void setEndTime(long startTime, long endTime) {
        ConsiderRecObject peek;
        List<TimespanObject> timespanObjectList;
        Stack<ConsiderRecObject> stack = considerStack.get();
        if (stack != null && !stack.isEmpty() && (timespanObjectList = (peek = stack.peek()).getTimespanObjectList()) != null) {
            TimespanObject timespanObject = null;
            for (int i = 0; i < timespanObjectList.size(); ++i) {
                timespanObject = timespanObjectList.get(i);
                if (timespanObject.getStartTime() != startTime) continue;
                timespanObject.setEndTime(endTime);
                break;
            }
        }
    }

    public static long getConsiderTime(String actionName) {
        long considerTime = 0L;
        Stack<ConsiderRecObject> stack = considerStack.get();
        if (stack != null && !stack.isEmpty()) {
            ConsiderRecObject peek = stack.peek();
            List<TimespanObject> timespanObjectList = peek.getTimespanObjectList();
            logger.info((Object)("\nactionName " + actionName + " getConsiderTime timespanList " + timespanObjectList));
            if (actionName != null && actionName.equals(peek.getActionName()) && timespanObjectList.size() > 0) {
                for (int i = 0; i < timespanObjectList.size(); ++i) {
                    TimespanObject timespanObject = timespanObjectList.get(i);
                    long winTime = timespanObject.getEndTime() - timespanObject.getStartTime();
                    if (winTime < 100L) {
                        logger.info((Object)("\n consider-stack's peek : " + peek + " , winTime: " + winTime + "less than 100ms,ignore"));
                        continue;
                    }
                    considerTime += winTime;
                }
            }
        }
        logger.info((Object)("\n actionName: " + actionName + " considerTime : " + considerTime));
        return considerTime;
    }

    public static void closeRecord(String actionName) {
        Stack<ConsiderRecObject> stack = considerStack.get();
        if (stack != null && !stack.isEmpty()) {
            ConsiderRecObject peek = stack.peek();
            logger.info((Object)("\u601d\u8003\u65f6\u95f4\u9700\u8981\u5f39\u6808\u7684action\u540d\u4e3a\uff1a" + actionName + ",\u6808\u7684\u5927\u5c0f\u4e3a\uff1a" + stack.size() + ",\u6808\u9876\u5143\u7d20\u4e3a" + peek));
            if (actionName.equals(peek.getActionName())) {
                ConsiderRecObject pop = stack.pop();
                if (stack.isEmpty()) {
                    considerStack.set(null);
                }
            }
        } else {
            considerStack.set(null);
        }
    }
}

