/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.client.servicebinding;

import com.kingdee.bos.appframework.client.servicebinding.IActionService;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ForceExitException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.util.Uuid;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ItemActionJDKHandler
implements InvocationHandler {
    private Map services;
    private Map serviceContext;
    private Map globalServices;
    private Object target = null;
    private String matchName;
    private static Logger logger = Logger.getLogger(ItemActionJDKHandler.class);

    public ItemActionJDKHandler(Map serviceContext, Map services, Object target) {
        this.serviceContext = serviceContext;
        this.services = services;
        this.target = target;
        if (this.serviceContext != null) {
            this.serviceContext.put("ACTION", target);
        }
    }

    @Override
    public Object invoke(Object delegate, Method m, Object[] args) throws Throwable {
        assert (m != null);
        if (this.matchName != null && m.getName().equals("equals")) {
            if (args[0] instanceof IItemAction) {
                IItemAction action = (IItemAction)args[0];
                return action.getItemAction().equals(this.target);
            }
            return m.invoke(this.target, args);
        }
        if (!m.getName().startsWith(this.matchName)) {
            return m.invoke(this.target, args);
        }
        final ActionParams params = new ActionParams(delegate, m, args);
        if (params.action.isDaemonRun()) {
            final Object curObj = delegate;
            final Method method = m;
            final Object[] curArgs = args;
            final MonitorInfo info = new MonitorInfo(params.uiObject.getUITitle() + "-->" + params.action.getValue("ShortDescription"), null, params.uiObject, params.action.isDaemonDialog());
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    try {
                        return ItemActionJDKHandler.this.actionPerformedInvoke(curObj, method, curArgs, params);
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }

                @Override
                public void finished() {
                    ThreadPool.destroyMonitor(info);
                }
            };
            info.setWorker(worker);
            ThreadPool.addActionThread(info);
            return null;
        }
        return this.actionPerformedInvoke(delegate, m, args, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object actionPerformedInvoke(Object delegate, Method m, Object[] args, ActionParams params) throws Throwable {
        Object result;
        block29: {
            result = null;
            boolean isExcute = true;
            long startTime = System.currentTimeMillis();
            if (params.action == null) {
                return result;
            }
            isExcute = params.action.beforeActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
            if (!isExcute) {
                return result;
            }
            UIActionMonitor.startAction((String)params.uiName, (String)params.actionName);
            try {
                if (params.action.getExtendProperty("Mutex") != null) {
                    Uuid uuid = Uuid.create();
                    params.action.putValue("NetUuid", uuid);
                }
                params.action.setActionEvent((ActionEvent)args[0]);
                Class<?> coreUICalss = Class.forName("com.kingdee.eas.framework.client.CoreUI");
                if (coreUICalss.isAssignableFrom(params.uiObject.getClass())) {
                    try {
                        Method method = params.uiObject.getClass().getMethod("prepareAction", IItemAction.class);
                        IUIActionPostman handler = (IUIActionPostman)method.invoke((Object)params.uiObject, this.target);
                        handler.callHandler();
                    }
                    catch (Exception ite) {
                        params.action.putValue("NetUuid", null);
                        if (ite.getCause() == null) {
                            params.uiObject.handUIException(ite);
                            Object var11_13 = null;
                            UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
                            return var11_13;
                        }
                        params.uiObject.handUIException(ite.getCause());
                        Object var11_14 = null;
                        UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
                        return var11_14;
                    }
                }
                if (this.serviceContext != null) {
                    this.serviceContext.put("ACTION", this.target);
                }
                this.initServices(this.target);
                if (this.services != null) {
                    this.beforeAction();
                }
                try {
                    logger.info((Object)("ItemActionJDKHandler[BEFORE PointCut] actionName: " + params.actionName));
                    result = m.invoke(this.target, args);
                    if (params.action != null && params.event != null) {
                        params.action.afterActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                    }
                    if (this.services != null) {
                        if (this.target instanceof ItemAction) {
                            if (this.target != null && !((ItemAction)this.target).isInvokeFailed()) {
                                this.afterAction();
                            }
                        } else {
                            this.afterAction();
                        }
                    }
                    logger.info((Object)("ItemActionJDKHandler[AFTER PointCut] actionName: " + params.actionName));
                }
                catch (ForceExitException forceExitException) {
                    if (params.action != null && params.event != null) {
                        params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                    }
                    params.action.putValue("NetUuid", null);
                    if (this.services != null) {
                        this.finalAction();
                    }
                    this.serviceContext.remove("ACTION");
                    logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                    break block29;
                    catch (Throwable throwable) {
                        if (params.action != null && params.event != null) {
                            params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                        }
                        params.action.putValue("NetUuid", null);
                        if (this.services != null) {
                            this.finalAction();
                        }
                        this.serviceContext.remove("ACTION");
                        logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                        throw throwable;
                    }
                }
                if (params.action != null && params.event != null) {
                    params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                }
                params.action.putValue("NetUuid", null);
                if (this.services != null) {
                    this.finalAction();
                }
                this.serviceContext.remove("ACTION");
                logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                break block29;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
            }
        }
        return result;
    }

    private void beforeAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.beforeActionPerformed(this.serviceContext);
        }
    }

    private void afterAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.afterActionPerformed(this.serviceContext);
        }
    }

    private void finalAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.finalActionPerformed(this.serviceContext);
        }
    }

    private void initServices(Object target) {
        IActionService itemAction;
        if (this.services == null) {
            this.services = new HashMap();
        }
        if (target instanceof IActionService && (itemAction = (IActionService)target).getServices() != null) {
            this.services.putAll(itemAction.getServices());
        }
        this.globalServices = (Map)this.serviceContext.get("GlobalService");
        if (this.services != null && this.globalServices != null) {
            this.services.putAll(this.globalServices);
        }
    }

    public String getMatchName() {
        return this.matchName;
    }

    public void setMatchName(String matchName) {
        this.matchName = matchName;
    }

    class ActionParams {
        public String uiName = "";
        public String actionName = "";
        public ItemAction action = null;
        public ActionEvent event = null;
        public IUIObject uiObject = null;

        public ActionParams(Object delegate, Method m, Object[] args) {
            if (ItemActionJDKHandler.this.target instanceof ItemAction && ItemActionJDKHandler.this.target != null) {
                this.action = (ItemAction)ItemActionJDKHandler.this.target;
                this.actionName = this.action.getClass().getName();
                if (this.actionName.indexOf("$") >= 0) {
                    this.actionName = this.actionName.substring(this.actionName.indexOf("$") + 1);
                }
                this.uiObject = this.action.getUIObject();
                this.uiName = this.uiObject.getClass().getName();
            }
            if (args != null && args.length > 0 && args[0] instanceof ActionEvent) {
                this.event = (ActionEvent)args[0];
            }
        }
    }
}

