/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.databinding;

import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.ConfigurePropertyAccess;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.appframework.databinding.Getter;
import com.kingdee.bos.appframework.databinding.MethodGetter;
import com.kingdee.bos.appframework.databinding.MethodSetter;
import com.kingdee.bos.appframework.databinding.ObjectValueDynamicGetter;
import com.kingdee.bos.appframework.databinding.ObjectValueDynamicSetter;
import com.kingdee.bos.appframework.databinding.PropertyAccessor;
import com.kingdee.bos.appframework.databinding.Setter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.ui.util.UIHelper;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class BindingUtility {
    private static final Logger logger = Logger.getLogger(BindingUtility.class);
    private static final HashMap<Class, HashMap<String, PropertyAccessor>> beanAccessorMap = new HashMap();

    private BindingUtility() {
    }

    public static Object getValue(IObjectValue valueObject, Field field) {
        assert (valueObject != null);
        assert (field != null);
        String fieldName = field.getActualName();
        StringTokenizer stFieldName = new StringTokenizer(fieldName, ".");
        Object ret = valueObject;
        while (stFieldName.hasMoreElements()) {
            if (ret == null) {
                return null;
            }
            fieldName = stFieldName.nextToken();
            ret = BindingUtility.getBeanProperty(ret, fieldName);
        }
        return ret;
    }

    public static void setValue(IObjectValue objectValue, Field field, Object propertyValue) {
        if (objectValue == null || field == null) {
            logger.info((Object)("objectValue:" + objectValue + " field:" + field + ",they can not be null."));
            return;
        }
        String fieldName = field.getActualName();
        int lastDotIndex = fieldName.lastIndexOf(".");
        if (lastDotIndex > 0) {
            String actualPropertyName = fieldName.substring(lastDotIndex + 1);
            Field parentField = new Field(fieldName = fieldName.substring(0, lastDotIndex));
            Object parentProperty = BindingUtility.getValue(objectValue, parentField);
            if (parentProperty != null) {
                BindingUtility.setBeanProperty(parentProperty, actualPropertyName, propertyValue);
            }
        } else {
            BindingUtility.setBeanProperty(objectValue, fieldName, propertyValue);
        }
    }

    public static Object getComponentValue(Component component, String propertyName) {
        return BindingUtility.getBeanProperty(component, propertyName);
    }

    public static void loadData(IObjectValue vo, Field field, ComponentProperty compProp) {
        assert (vo != null);
        assert (field != null);
        assert (compProp != null);
        Component comp = compProp.getComponent();
        if (comp instanceof KDBizMultiLangBox) {
            UIHelper.loadMultiLangFields((KDMultiLangBox)((KDBizMultiLangBox)compProp.getComponent()), vo, field.getName());
        } else if (comp instanceof KDBizMultiLangArea) {
            UIHelper.loadMultiLangFields((KDMultiLangBox)((KDBizMultiLangArea)compProp.getComponent()), vo, field.getName());
        } else if (comp instanceof KDNumberTextField) {
            Object voProperty = BindingUtility.getValue(vo, field);
            ((KDNumberTextField)comp).setValue(voProperty);
        } else if (comp instanceof KDFormattedTextField) {
            Object voProperty = BindingUtility.getValue(vo, field);
            ((KDFormattedTextField)comp).setValue(voProperty);
        } else {
            Object voProperty = BindingUtility.getValue(vo, field);
            BindingUtility.setBeanProperty(compProp.getComponent(), compProp.getPropertyName(), voProperty);
        }
    }

    public static void loadDetailData(IObjectValue vo, Field headerField, DataComponentMap componentMap, PropertyChangeSupport support) {
        ArrayList detailList = componentMap.getDetailList(headerField);
        if (detailList != null) {
            Field detailField = null;
            int length = detailList.size();
            for (int j = 0; j < length; ++j) {
                detailField = (Field)detailList.get(j);
                BindingUtility.loadDataToTable(vo, detailField, componentMap, support);
            }
        }
    }

    public static void loadDataToTable(IObjectValue vo, Field detailField, DataComponentMap dataCompMap, PropertyChangeSupport support) {
        KDTable table = dataCompMap.getTable(detailField);
        EventListener[] listeners = BindingUtility.removeTablePropertyChangeListener(table, KDTPropertyChangeListener.class);
        ArrayList fields = dataCompMap.getDetailFields(detailField);
        table.removeRows();
        IObjectCollection detailCollection = (IObjectCollection)BindingUtility.getBeanProperty(vo, detailField.getActualName());
        table.createBlankTable(0, 0, detailCollection == null ? 0 : detailCollection.size());
        if (detailCollection != null && detailCollection.size() >= 0) {
            table.setUserObject((Object)detailCollection);
            IObjectValue detailObject = null;
            int length = detailCollection.size();
            for (int i = 0; i < length; ++i) {
                detailObject = detailCollection.getObject(i);
                BindingUtility.loadDataToTableLine(i, detailObject, table, fields, dataCompMap);
                if (support == null) continue;
                PropertyChangeEvent event = new PropertyChangeEvent(table, "loadLine", null, new Integer(i));
                support.firePropertyChange(event);
            }
        }
        BindingUtility.restoreTableListeners(table, KDTPropertyChangeListener.class, listeners);
    }

    public static void clearDetailData(IObjectValue vo, Field headerField, DataComponentMap componentMap, PropertyChangeSupport support) {
        ArrayList detailList = componentMap.getDetailList(headerField);
        if (detailList != null) {
            Field detailField = null;
            int length = detailList.size();
            for (int j = 0; j < length; ++j) {
                detailField = (Field)detailList.get(j);
                BindingUtility.clearDataToTable(vo, detailField, componentMap, support);
                BindingUtility.clearDetailData(vo, detailField, componentMap, support);
            }
        }
    }

    public static void clearDataToTable(IObjectValue vo, Field detailField, DataComponentMap dataCompMap, PropertyChangeSupport support) {
        KDTable table = dataCompMap.getTable(detailField);
        table.removeRows();
    }

    public static void loadDataToTableLine(int row, IObjectValue detailObj, KDTable table, ArrayList fields, DataComponentMap dataCompMap, PropertyChangeSupport support) {
        BindingUtility.loadDataToTableLine(row, detailObj, table, fields, dataCompMap);
        if (support != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(table, "loadLine", null, new Integer(row));
            support.firePropertyChange(event);
        }
    }

    public static void loadDataToTableLine(int row, IObjectValue detailObj, KDTable table, ArrayList fields, DataComponentMap dataCompMap) {
        assert (detailObj != null);
        assert (table != null);
        if (fields == null) {
            fields = dataCompMap.getDetailFields(dataCompMap.getDetail(table));
        }
        Field colField = null;
        Object colValue = null;
        if (detailObj.getClass() != null) {
            dataCompMap.getDetail(table).setFieldClazz(detailObj.getClass());
        }
        int length = fields.size();
        for (int i = 0; i < length; ++i) {
            colField = (Field)fields.get(i);
            colValue = BindingUtility.getValue(detailObj, colField);
            ComponentProperty compProp = dataCompMap.getComponentProperty(colField);
            BindingUtility.setTableCellValue(table, row, compProp.getPropertyName(), colValue);
        }
        BindingUtility.setAuthority(detailObj, table.getRow(row));
        table.getRow(row).setUserObject((Object)detailObj);
    }

    public static void setAuthority(IObjectValue detailObj, IRow row) {
        Boolean value;
        boolean isHasRight = true;
        if (detailObj != null && detailObj.containsKey("_V") && (value = (Boolean)detailObj.get("_V")) != null && !value.booleanValue()) {
            isHasRight = false;
        }
        if (!isHasRight) {
            row.getStyleAttributes().setHided(true);
            row.getStyleAttributes().setLocked(true);
        }
    }

    public static void setTableCellValue(KDTable table, int row, String colName, Object colValue) {
        table.getRow(row).getCell(colName).setValue(colValue);
    }

    public static void setTableCellValue(KDTable table, IRow row, int colName, Object colValue) {
        row.getCell(colName).setValue(colValue);
    }

    public static void setTableCellValue(KDTable table, int row, int colName, Object colValue) {
        table.getRow(row).getCell(colName).setValue(colValue);
    }

    public static Object getTableCellValue(KDTable table, int row, String colName) {
        return table.getRow(row).getCell(colName).getValue();
    }

    public static void storeData(IObjectValue vo, Field field, ComponentProperty compProp) {
        assert (vo != null);
        assert (field != null);
        assert (compProp != null);
        int lastIndex = field.getName().lastIndexOf(".");
        Component comp = compProp.getComponent();
        if (comp instanceof KDBizMultiLangBox) {
            if (lastIndex > 0) {
                Object obj = BindingUtility.getValue(vo, new Field(field.getName().substring(0, lastIndex)));
                if (obj != null && obj instanceof IObjectValue) {
                    UIHelper.storeMultiLangFields((KDMultiLangBox)((KDBizMultiLangBox)compProp.getComponent()), (IObjectValue)obj, field.getName().substring(lastIndex + 1));
                }
            } else {
                UIHelper.storeMultiLangFields((KDMultiLangBox)((KDBizMultiLangBox)compProp.getComponent()), vo, field.getName());
            }
        } else if (comp instanceof KDBizMultiLangArea) {
            if (lastIndex > 0) {
                Object obj = BindingUtility.getValue(vo, new Field(field.getName().substring(0, lastIndex)));
                if (obj != null && obj instanceof IObjectValue) {
                    UIHelper.storeMultiLangFields((KDMultiLangBox)((KDBizMultiLangArea)compProp.getComponent()), (IObjectValue)obj, field.getName().substring(lastIndex + 1));
                }
            } else {
                UIHelper.storeMultiLangFields((KDMultiLangBox)((KDBizMultiLangArea)compProp.getComponent()), vo, field.getName());
            }
        } else if (comp instanceof KDDatePicker) {
            Object compProperty = ((KDDatePicker)comp).getValue(field.getFieldClazz());
            BindingUtility.setValue(vo, field, compProperty);
        } else if (comp instanceof KDTimePicker) {
            Object compProperty = ((KDTimePicker)comp).getValue(field.getFieldClazz());
            BindingUtility.setValue(vo, field, compProperty);
        } else if (comp instanceof KDNumberTextField) {
            Number compProperty = ((KDNumberTextField)comp).getNumberValue(field.getFieldClazz());
            BindingUtility.setValue(vo, field, compProperty);
        } else if (comp instanceof KDFormattedTextField) {
            Object compProperty = ((KDFormattedTextField)comp).getValue(field.getFieldClazz());
            BindingUtility.setValue(vo, field, compProperty);
        } else {
            Object compProperty = BindingUtility.getBeanProperty(compProp.getComponent(), compProp.getPropertyName());
            BindingUtility.setValue(vo, field, compProperty);
        }
    }

    public static void storeTableToData(KDTable table, Field detailField, DataComponentMap dataMap, PropertyChangeSupport support) {
        int rowCount = table.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                BindingUtility.storeLine(table, i, detailField, dataMap, support);
            }
        }
    }

    private static boolean identityContain(IObjectCollection collection, IObjectValue obj) {
        if (collection == null) {
            return false;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            return true;
        }
        return false;
    }

    public static void storeLine(KDTable table, int selectedRow, Field detailField, DataComponentMap dataMap, PropertyChangeSupport support) {
        ArrayList detailList;
        ArrayList colFields;
        if (table == null || selectedRow < 0 || selectedRow > table.getRowCount() - 1) {
            return;
        }
        if (detailField == null) {
            detailField = dataMap.getDetail(table);
        }
        if ((colFields = dataMap.getDetailFields(detailField)) != null && colFields.size() > 0) {
            IObjectCollection collection;
            IObjectValue rowObj = (IObjectValue)table.getRow(selectedRow).getUserObject();
            if (rowObj == null) {
                try {
                    rowObj = IObjectValueAgent.class.isAssignableFrom(detailField.getFieldClazz()) ? (IObjectValue)detailField.getFieldClazz().getMethod("create", null).invoke(null, null) : (IObjectValue)detailField.getFieldClazz().newInstance();
                    table.getRow(selectedRow).setUserObject((Object)rowObj);
                }
                catch (Exception e) {
                    logger.error((Object)"can not having the row object ", (Throwable)e);
                    return;
                }
            }
            if ((collection = (IObjectCollection)table.getUserObject()) == null) {
                logger.error((Object)"not fill detail collection to table user object");
                return;
            }
            if (!BindingUtility.identityContain(collection, rowObj)) {
                if (collection.size() < selectedRow) {
                    for (int i = 0; i < selectedRow; ++i) {
                        BindingUtility.storeLine(table, i, detailField, dataMap, support);
                    }
                }
                collection.insertObject(selectedRow - 1, rowObj);
            }
            Field colField = null;
            Object colValue = null;
            String colName = null;
            int length = colFields.size();
            for (int i = 0; i < length; ++i) {
                colField = (Field)colFields.get(i);
                colName = dataMap.getComponentProperty(colField).getPropertyName();
                colValue = BindingUtility.getTableCellValue(table, selectedRow, colName);
                BindingUtility.setValue(rowObj, colField, colValue);
            }
            if (support != null) {
                PropertyChangeEvent event = new PropertyChangeEvent(table, "storeLine", null, new Integer(selectedRow));
                support.firePropertyChange(event);
            }
        }
        if ((detailList = dataMap.getDetailList(detailField)) != null) {
            KDTable ddTable = null;
            int k = detailList.size();
            for (int j = 0; j < k; ++j) {
                Field ddetail = (Field)detailList.get(j);
                ddTable = dataMap.getTable(ddetail);
                int selRow = ddTable.getSelectManager().getActiveRowIndex();
                BindingUtility.storeLine(ddTable, selRow, ddetail, dataMap, support);
            }
        }
    }

    public static void storeColumn(KDTable table, int selectedRow, int columnIndex, Field detailField, DataComponentMap dataMap, PropertyChangeSupport support) {
        ArrayList detailList;
        ArrayList colFields;
        if (table == null || selectedRow < 0 || selectedRow > table.getRowCount() - 1) {
            return;
        }
        if (detailField == null) {
            detailField = dataMap.getDetail(table);
        }
        if ((colFields = dataMap.getDetailFields(detailField)) != null && colFields.size() > 0) {
            IObjectCollection collection;
            IObjectValue rowObj = (IObjectValue)table.getRow(selectedRow).getUserObject();
            if (rowObj == null) {
                try {
                    rowObj = IObjectValueAgent.class.isAssignableFrom(detailField.getFieldClazz()) ? (IObjectValue)detailField.getFieldClazz().getMethod("create", null).invoke(null, null) : (IObjectValue)detailField.getFieldClazz().newInstance();
                    table.getRow(selectedRow).setUserObject((Object)rowObj);
                }
                catch (Exception e) {
                    logger.error((Object)"can not having the row object ", (Throwable)e);
                    return;
                }
            }
            if ((collection = (IObjectCollection)table.getUserObject()) == null) {
                logger.error((Object)"not fill detail collection to table user object");
                return;
            }
            if (!BindingUtility.identityContain(collection, rowObj)) {
                if (collection.size() < selectedRow) {
                    for (int i = 0; i < selectedRow; ++i) {
                        BindingUtility.storeLine(table, i, detailField, dataMap, support);
                    }
                }
                collection.insertObject(selectedRow - 1, rowObj);
            }
            Field colField = null;
            Object colValue = null;
            String colName = null;
            String tempColname = null;
            int length = colFields.size();
            for (int i = 0; i < length; ++i) {
                colField = (Field)colFields.get(i);
                colName = dataMap.getComponentProperty(colField).getPropertyName();
                tempColname = table.getColumn(columnIndex).getKey();
                if (tempColname == null || !tempColname.equals(colName)) continue;
                colValue = BindingUtility.getTableCellValue(table, selectedRow, colName);
                BindingUtility.setValue(rowObj, colField, colValue);
            }
            if (support != null) {
                PropertyChangeEvent event = new PropertyChangeEvent(table, "storeLine", null, new Integer(selectedRow));
                support.firePropertyChange(event);
            }
        }
        if ((detailList = dataMap.getDetailList(detailField)) != null) {
            KDTable ddTable = null;
            int k = detailList.size();
            for (int j = 0; j < k; ++j) {
                Field ddetail = (Field)detailList.get(j);
                ddTable = dataMap.getTable(ddetail);
                int selRow = ddTable.getSelectManager().getActiveRowIndex();
                BindingUtility.storeLine(ddTable, selRow, ddetail, dataMap, support);
            }
        }
    }

    public static void sortCollection(KDTable table) {
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection != null) {
            collection.clear();
            for (int r = 0; r < table.getRowCount(); ++r) {
                collection.addObject((IObjectValue)table.getRow(r).getUserObject());
            }
        }
    }

    private static boolean isConfigedProperty(Object bean, String propertyName) {
        if (bean instanceof IObjectValue) {
            AbstractObjectValue ov = (AbstractObjectValue)bean;
            return ConfigurePropertyAccess.isConfigureProperty(ov.getBOSType(), propertyName);
        }
        return false;
    }

    private static PropertyAccessor getPropertyAccessor(Object bean, String propertyName, Object propertyValue) {
        Setter setter;
        Getter getter;
        PropertyAccessor pac;
        assert (bean != null);
        assert (propertyName != null);
        HashMap<String, PropertyAccessor> pacHashMap = beanAccessorMap.get(bean.getClass());
        if (pacHashMap == null) {
            pacHashMap = new HashMap();
            beanAccessorMap.put(bean.getClass(), pacHashMap);
        }
        if ((pac = pacHashMap.get(propertyName)) == null) {
            pac = new PropertyAccessor();
            pacHashMap.put(propertyName, pac);
        }
        if ((getter = pac.getGetter()) == null) {
            getter = MethodGetter.newInstance(bean.getClass(), propertyName, propertyValue == null ? null : propertyValue.getClass());
            if (getter != null) {
                pac.setGetter(getter);
            } else if (BindingUtility.isConfigedProperty(bean, propertyName)) {
                logger.info((Object)("get ConfigedProperty Getter. ClassName:" + bean.getClass() + " propertyName " + propertyName));
                pac.setGetter(new ObjectValueDynamicGetter(propertyName));
            } else {
                logger.error((Object)("ClassName:" + bean.getClass() + " hasn't property " + propertyName));
                throw new IllegalArgumentException("No such property ClassName:" + bean.getClass() + " propertyName:" + propertyName);
            }
        }
        if ((setter = pac.getSetter()) == null) {
            Class retType = pac.getGetter().getReturnType();
            setter = MethodSetter.newInstance(bean.getClass(), propertyName, retType);
            if (setter != null) {
                pac.setSetter(setter);
            } else if (BindingUtility.isConfigedProperty(bean, propertyName)) {
                logger.info((Object)("get ConfigedProperty Setter. ClassName:" + bean.getClass() + " propertyName " + propertyName));
                pac.setSetter(new ObjectValueDynamicSetter(propertyName));
            } else {
                logger.error((Object)("ClassName:" + bean.getClass() + " hasn't setter for property " + propertyName));
            }
        }
        return pac;
    }

    public static Object getBeanProperty(Object bean, String propertyName) {
        assert (bean != null);
        assert (propertyName != null);
        PropertyAccessor pac = BindingUtility.getPropertyAccessor(bean, propertyName, null);
        try {
            return pac.getGetter().invoke(bean, null);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return null;
        }
    }

    public static void setBeanProperty(Object bean, String propertyName, Object propertyValue) {
        PropertyAccessor pac = BindingUtility.getPropertyAccessor(bean, propertyName, propertyValue);
        try {
            Class paraType = pac.getSetter().getParameterTypes()[0];
            if (propertyValue != null) {
                if (!paraType.equals(propertyValue.getClass())) {
                    propertyValue = BindingUtility.clazCast(paraType, propertyValue);
                }
                if (paraType.equals(String.class) && propertyValue.toString().length() == 0) {
                    propertyValue = null;
                }
            }
            pac.getSetter().invoke(bean, new Object[]{propertyValue});
        }
        catch (InvocationTargetException ite) {
            logger.error((Object)("dataBinding propertyName is :" + propertyName + "\n"));
            logger.error((Object)"setBeanProperty occur error in BindingUtility! ", ite.getCause());
        }
        catch (Exception e) {
            logger.error((Object)("dataBinding propertyName is :" + propertyName + "\n"));
            logger.error((Object)"setBeanProperty occur error in BindingUtility! ", (Throwable)e);
        }
    }

    static Object clazCast(Class paraType, Object value) {
        if (paraType.equals(String.class)) {
            return String.valueOf(value);
        }
        if (paraType.equals(Integer.class)) {
            return Integer.valueOf(value.toString());
        }
        if (paraType.equals(Long.class)) {
            return Long.valueOf(value.toString());
        }
        if (paraType.equals(Short.class)) {
            return Short.valueOf(value.toString());
        }
        if (paraType.equals(Double.class)) {
            return Double.valueOf(value.toString());
        }
        if (paraType.equals(BigDecimal.class)) {
            return new BigDecimal(value.toString());
        }
        if (paraType.equals(Integer.TYPE)) {
            return Integer.valueOf(value.toString());
        }
        if (paraType.equals(Long.TYPE)) {
            return Long.valueOf(value.toString());
        }
        if (paraType.equals(Float.TYPE)) {
            return Float.valueOf(value.toString());
        }
        if (paraType.equals(Double.TYPE)) {
            return Double.valueOf(value.toString());
        }
        if (paraType.equals(Short.TYPE)) {
            return Short.valueOf(value.toString());
        }
        if (paraType.equals(Date.class) && value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (paraType.equals(Time.class) && value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (paraType.equals(Timestamp.class) && value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        return value;
    }

    public static void loadDetailData(IObjectCollection vo, Field headerField, DataComponentMap componentMap, PropertyChangeSupport support) {
        ArrayList detailList = componentMap.getDetailList(headerField);
        if (detailList != null) {
            Field detailField = null;
            int length = detailList.size();
            for (int j = 0; j < length; ++j) {
                detailField = (Field)detailList.get(j);
                BindingUtility.loadDataToTable(vo, detailField, componentMap, support);
            }
        }
    }

    public static void loadDataToTable(IObjectCollection vo, Field detailField, DataComponentMap dataCompMap, PropertyChangeSupport support) {
        KDTable table = dataCompMap.getTable(detailField);
        ArrayList fields = dataCompMap.getDetailFields(detailField);
        table.removeRows();
        IObjectCollection detailCollection = vo;
        if (detailCollection != null && detailCollection.size() >= 0) {
            table.setUserObject((Object)detailCollection);
            IObjectValue detailObject = null;
            int length = detailCollection.size();
            for (int i = 0; i < length; ++i) {
                detailObject = detailCollection.getObject(i);
                table.addRow();
                BindingUtility.loadDataToTableLine(i, detailObject, table, fields, dataCompMap);
                if (support == null) continue;
                PropertyChangeEvent event = new PropertyChangeEvent(table, "loadLine", null, new Integer(i));
                support.firePropertyChange(event);
            }
        }
    }

    public static EventListener[] removeTablePropertyChangeListener(KDTable detail, Class type) {
        if (detail != null) {
            EventListenerList eventList = detail.getListenerList();
            EventListener[] lists = eventList.getListeners(type);
            if (lists != null) {
                for (int i = 0; i < lists.length; ++i) {
                    eventList.remove(type, lists[i]);
                }
            }
            return lists;
        }
        return null;
    }

    public static void restoreTableListeners(KDTable detail, Class type, EventListener[] lists) {
        if (detail != null && lists != null) {
            EventListenerList eventList = detail.getListenerList();
            for (int i = 0; i < lists.length; ++i) {
                eventList.add(type, lists[i]);
            }
        }
    }
}

