/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.databinding;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.PropertyNotFoundException;
import com.kingdee.bos.metadata.configure.VOUtil;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import org.apache.log4j.Logger;

class ConfigurePropertyAccess {
    private static final Logger logger = Logger.getLogger(ConfigurePropertyAccess.class);

    ConfigurePropertyAccess() {
    }

    static Object getProperty(IObjectValue ov, String propertyName) throws PropertyNotFoundException, ReflectException {
        SimplePropertyCollection configured = ConfigurePropertyAccess.getConfigureProperties(ov.getBOSType());
        if (configured != null) {
            SimpleProperty prop = configured.get(propertyName);
            if (prop == null) {
                throw new PropertyNotFoundException(ConfigurePropertyAccess.getEntity(ov.getBOSType()).getPK(), propertyName);
            }
            if (DataType.ENUM.equals((Object)prop.getDataType())) {
                return VOUtil.getEnumProperty((IObjectValue)ov, (String)propertyName, (BizEnumInfo)prop.getEnumType(), (String)prop.getRefTypeInfo());
            }
            return VOUtil.getConfiguredProperty((IObjectValue)ov, (DataType)prop.getDataType(), (String)propertyName);
        }
        return null;
    }

    static Object setProperty(IObjectValue ov, String propertyName, Object value) throws PropertyNotFoundException, ReflectException {
        SimplePropertyCollection configured = ConfigurePropertyAccess.getConfigureProperties(ov.getBOSType());
        if (configured != null) {
            SimpleProperty prop = configured.get(propertyName);
            if (prop == null) {
                throw new PropertyNotFoundException(ConfigurePropertyAccess.getEntity(ov.getBOSType()).getPK(), propertyName);
            }
            if (DataType.ENUM.equals((Object)prop.getDataType())) {
                return VOUtil.setEnumProperty((IObjectValue)ov, (String)propertyName, (BizEnumInfo)prop.getEnumType(), (String)prop.getRefTypeInfo(), (Object)value);
            }
            return VOUtil.setConfiguredPropertyByReflect((IObjectValue)ov, (String)propertyName, (Object)value);
        }
        return null;
    }

    static SimpleEntity getEntity(BOSObjectType bosType) {
        try {
            EntitySelect select = new EntitySelect(bosType);
            select.propertySelect().selectConfigureProperty(new String[]{"*"}, new String[]{"dataType", "enumType"});
            SimpleEntity entity = null;
            entity = ConfigMDUtil.isClient() ? MetaDataAccessFactory.getRemoteInstance().select(select) : MetaDataAccessFactory.getLocalInstance((Context)ConfigMDUtil.getContext()).select(select);
            return entity;
        }
        catch (BOSException e) {
            logger.error((Object)"Binding: get configured properties errror. ", (Throwable)e);
            return null;
        }
    }

    static SimplePropertyCollection getConfigureProperties(BOSObjectType bosType) {
        SimpleEntity entity = ConfigurePropertyAccess.getEntity(bosType);
        if (entity != null) {
            return entity.properties();
        }
        return null;
    }

    static boolean isConfigureProperty(BOSObjectType bosType, String propertyName) {
        if (bosType == null) {
            return false;
        }
        SimplePropertyCollection configured = ConfigurePropertyAccess.getConfigureProperties(bosType);
        if (configured != null) {
            return configured.get(propertyName) != null;
        }
        return false;
    }
}

