/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.databinding;

import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataBinderListenerHandler;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.appframework.databinding.IDataBinderLisenter;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.apache.log4j.Logger;

public class DataBinder {
    private static final Logger logger = Logger.getLogger(DataBinder.class);
    public static final String LOAD_LINE = "loadLine";
    public static final String STORE_LINE = "storeLine";
    protected PropertyChangeSupport support;
    protected IObjectValue valueObject = null;
    protected IObjectCollection collection = null;
    protected DataComponentMap componentMap;
    private boolean tablePropertyChange = false;
    private List listListener = new ArrayList();
    public static final String CollectionName = "collection";

    public DataBinder() {
        this.init();
        logger.debug((Object)"databinder init.");
    }

    public boolean isTablePropertyChange() {
        return this.tablePropertyChange;
    }

    public void setTablePropertyChange(boolean tablePropertyChange) {
        this.tablePropertyChange = tablePropertyChange;
    }

    private void init() {
        this.componentMap = new DataComponentMap();
    }

    public void addDataBinderLisenter(IDataBinderLisenter lisenter) {
        this.listListener.add(lisenter);
    }

    public void removeDataBinderLisenter(IDataBinderLisenter lisenter) {
        if (lisenter != null) {
            this.listListener.remove(lisenter);
        }
    }

    public void loadFields() {
        if (this.valueObject == null) {
            return;
        }
        this.loadHeader();
        DataBinderListenerHandler.afterLoadHead(this.listListener, this.valueObject);
        BindingUtility.clearDetailData(this.getValueObject(), new Field("header"), this.componentMap, this.support);
        BindingUtility.loadDetailData(this.getValueObject(), new Field("header"), this.componentMap, this.support);
        DataBinderListenerHandler.afterLoad(this.listListener, this.valueObject);
    }

    public void loadHeader() {
        ArrayList headerFields = this.componentMap.getHeaderFields();
        if (headerFields != null) {
            boolean flag;
            Field field = null;
            ComponentProperty compProp = null;
            block0: do {
                flag = true;
                int length = headerFields.size();
                for (int i = 0; i < length; ++i) {
                    field = (Field)headerFields.get(i);
                    compProp = this.componentMap.getComponentProperty(field);
                    BindingUtility.loadData(this.getValueObject(), field, compProp);
                    if (headerFields.size() == length) continue;
                    flag = false;
                    continue block0;
                }
            } while (!flag);
        }
    }

    public void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        boolean propertyChange = this.isTablePropertyChange();
        if (propertyChange) {
            this.setTablePropertyChange(false);
        }
        BindingUtility.loadDataToTableLine(row.getRowIndex(), obj, table, null, this.componentMap, this.support);
        this.setTablePropertyChange(propertyChange);
    }

    public void storeFields() {
        if (this.valueObject == null) {
            return;
        }
        DataBinderListenerHandler.beforeStore(this.listListener, this.valueObject);
        this.storeHeader();
        ArrayList detailList = this.componentMap.getDetailList(DataComponentMap.HEAD_FIELD);
        if (detailList != null) {
            Field detailField = null;
            int length = detailList.size();
            for (int j = 0; j < length; ++j) {
                detailField = (Field)detailList.get(j);
                KDTable table = this.componentMap.getTable(detailField);
                BindingUtility.storeTableToData(table, detailField, this.componentMap, this.support);
                BindingUtility.sortCollection(table);
            }
        }
        DataBinderListenerHandler.afterStore(this.listListener, this.valueObject);
    }

    public void storeHeader() {
        ArrayList headerFields = this.componentMap.getHeaderFields();
        if (headerFields != null && headerFields.size() > 0) {
            int length = headerFields.size();
            Field field = null;
            ComponentProperty compProp = null;
            for (int i = 0; i < length; ++i) {
                field = (Field)headerFields.get(i);
                compProp = this.componentMap.getComponentProperty(field);
                BindingUtility.storeData(this.getValueObject(), field, compProp);
            }
        }
    }

    public void registerBinding(String fieldName, Component comp, String compProperty) {
        this.registerBinding(fieldName, null, comp, compProperty);
    }

    public void registerBinding(String fieldName, Class clazz, Component comp, String compProperty) {
        if (CollectionName.equals(fieldName)) {
            this.registerBindingForTable(fieldName, clazz, comp, compProperty);
            return;
        }
        final Field f = new Field(fieldName);
        f.setFieldClazz(clazz);
        ComponentProperty cp = new ComponentProperty(compProperty, comp);
        this.componentMap.register(f, cp);
        if (comp instanceof KDTable && compProperty.equals("userObject")) {
            final KDTable table = (KDTable)comp;
            BeforeActionListener beforeListener = new BeforeActionListener(){

                public void beforeAction(BeforeActionEvent e) {
                    if (e.getType() == 1) {
                        if (table.getSelectManager().get() != null) {
                            int selectedRow = table.getSelectManager().get().getBeginRow();
                            if (selectedRow < 0 || selectedRow >= table.getRowCount()) {
                                return;
                            }
                            IObjectValue rowData = (IObjectValue)table.getRow(selectedRow).getUserObject();
                            BindingUtility.loadDetailData(rowData, f, DataBinder.this.componentMap, DataBinder.this.support);
                        } else {
                            BindingUtility.clearDetailData(null, f, DataBinder.this.componentMap, DataBinder.this.support);
                        }
                    }
                }
            };
            table.setAfterAction(beforeListener);
            this.listListener.add(beforeListener);
            KDTSelectListener selectListener = new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent event) {
                    int selectedRow;
                    int preRow;
                    if (event.getSelectBlock() == null) {
                        return;
                    }
                    if (event.getPrevSelectBlock() != null && (preRow = event.getPrevSelectBlock().getBeginRow()) >= 0) {
                        BindingUtility.storeLine(table, preRow, f, DataBinder.this.componentMap, DataBinder.this.support);
                    }
                    if ((selectedRow = event.getSelectBlock().getBeginRow()) < 0 || selectedRow >= table.getRowCount()) {
                        return;
                    }
                    IObjectValue rowData = (IObjectValue)table.getRow(selectedRow).getUserObject();
                    BindingUtility.loadDetailData(rowData, f, DataBinder.this.componentMap, DataBinder.this.support);
                }
            };
            table.addKDTSelectListener(selectListener);
            this.listListener.add(selectListener);
            KDTPropertyChangeListener propertyChangeListener = new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent evt) {
                    if (!DataBinder.this.isTablePropertyChange()) {
                        return;
                    }
                    if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
                        int rowIndex = evt.getRowIndex();
                        int columnIndex = evt.getColIndex();
                        BindingUtility.storeColumn(table, rowIndex, columnIndex, f, DataBinder.this.componentMap, DataBinder.this.support);
                    }
                }
            };
            table.addKDTPropertyChangeListener(propertyChangeListener);
            this.listListener.add(propertyChangeListener);
        }
    }

    public void unRegisterBinding(String fieldName, Component comp, String compProperty) {
        this.unRegisterBinding(fieldName, null, comp, compProperty);
    }

    public void unRegisterBinding(String fieldName, Class clazz, Component comp, String compProperty) {
        if (comp == null) {
            return;
        }
        Field f = new Field(fieldName);
        f.setFieldClazz(clazz);
        ComponentProperty cp = new ComponentProperty(compProperty, comp);
        this.componentMap.unRegister(f, cp);
        if (comp instanceof KDTable && this.listListener.size() > 0) {
            KDTable table = (KDTable)comp;
            for (int i = 0; i < this.listListener.size(); ++i) {
                EventListener eventListener = (EventListener)this.listListener.get(i);
                if (KDTPropertyChangeListener.class.isInstance(eventListener)) {
                    table.removeKDTPropertyChangeListener((KDTPropertyChangeListener)eventListener);
                    continue;
                }
                if (KDTSelectListener.class.isInstance(eventListener)) {
                    table.removeKDTSelectListener((KDTSelectListener)eventListener);
                    continue;
                }
                if (!BeforeActionListener.class.isInstance(eventListener)) continue;
                table.setAfterAction(null);
            }
        }
    }

    public IObjectValue getValueObject() {
        return this.valueObject;
    }

    public void setValueObject(IObjectValue valueObject) {
        this.valueObject = valueObject;
    }

    private ComponentProperty getSubUiVo(String propertyName) {
        ComponentProperty compProp = this.componentMap.getComponentProperty(propertyName);
        if (compProp == null) {
            int lastIndex = propertyName.lastIndexOf(".");
            if (lastIndex < 0) {
                return null;
            }
            compProp = this.getSubUiVo(propertyName.substring(0, lastIndex));
        }
        return compProp;
    }

    private Object getBeanPropertyValue(Object bean, String[] propertyName) {
        try {
            Object obj = null;
            if (propertyName.length == 1 && bean instanceof IObjectValue && !((IObjectValue)bean).getBoolean("_loaded_")) {
                IObjectValue ov = (IObjectValue)bean;
                ObjectUuidPK pk = new ObjectUuidPK(ov.getBOSUuid(ov.getPKField()));
                ov = DynamicObjectFactory.getRemoteInstance().getValue(ov.getBOSType(), (IObjectPK)pk);
                ov.setBoolean("_loaded_", true);
                obj = BindingUtility.getBeanProperty(ov, propertyName[0]);
            } else {
                obj = BindingUtility.getBeanProperty(bean, propertyName[0]);
            }
            if (obj != null && propertyName.length > 1) {
                String[] copy = new String[propertyName.length - 1];
                System.arraycopy(propertyName, 1, copy, 0, propertyName.length - 1);
                obj = this.getBeanPropertyValue(obj, copy);
            }
            return obj;
        }
        catch (Exception E) {
            return null;
        }
    }

    public Object getUIVoProperty(String propertyName) {
        ComponentProperty compProp = this.getSubUiVo(propertyName);
        if (compProp == null) {
            return null;
        }
        Component comp = compProp.getComponent();
        if (comp instanceof KDTable) {
            int[] selectRows;
            KDTable table = (KDTable)comp;
            compProp = this.componentMap.getComponentProperty(propertyName);
            String columnName = "";
            if (compProp != null) {
                columnName = compProp.getPropertyName();
            }
            if ((selectRows = KDTableUtil.getSelectedRows((KDTable)table)).length > 0) {
                Object retValue = null;
                if (table.getRowCount() > selectRows[0]) {
                    if (columnName != null && !columnName.equals("") && table.getColumn(columnName) != null) {
                        retValue = BindingUtility.getTableCellValue(table, selectRows[0], columnName);
                    } else {
                        IObjectValue objectValue = (IObjectValue)table.getRow(selectRows[0]).getUserObject();
                        String[] properArr = propertyName.split("\\.");
                        String[] copy = new String[properArr.length - 1];
                        System.arraycopy(properArr, 1, copy, 0, properArr.length - 1);
                        retValue = this.getBeanPropertyValue(objectValue, copy);
                    }
                    return retValue;
                }
                return null;
            }
            return null;
        }
        return BindingUtility.getComponentValue(compProp.getComponent(), compProp.getPropertyName());
    }

    public Object getUIDetailProperty(String detailName, String columnName, int row) {
        if (row < 0) {
            return null;
        }
        KDTable table = this.componentMap.getTable(new Field(detailName));
        if (table.getRowCount() > row) {
            return BindingUtility.getTableCellValue(table, row, columnName);
        }
        return null;
    }

    public void setUIVoProperty(String propertyName, Object value) {
        ComponentProperty compProp = this.componentMap.getComponentProperty(propertyName);
        BindingUtility.setBeanProperty(compProp.getComponent(), propertyName, value);
    }

    public void setUIDetailProperty(String detailName, String columnName, int row, Object value) {
        if (row < 0) {
            return;
        }
        KDTable table = this.componentMap.getTable(new Field(detailName));
        if (table.getRowCount() > row) {
            BindingUtility.setTableCellValue(table, row, columnName, value);
        }
    }

    public Component getComponetByField(String propertyName) {
        ComponentProperty compProp = this.componentMap.getComponentProperty(propertyName);
        if (compProp != null) {
            return compProp.getComponent();
        }
        return null;
    }

    public void bindDataToTable(KDTable kdtEntrys, IObjectCollection detailCollection) {
        assert (kdtEntrys != null);
        boolean propertyChange = this.isTablePropertyChange();
        if (propertyChange) {
            this.setTablePropertyChange(false);
        }
        kdtEntrys.removeRows();
        int detailCount = detailCollection.size();
        IObjectValue detailData = null;
        IRow row = null;
        for (int i = 0; i < detailCount; ++i) {
            detailData = detailCollection.getObject(i);
            row = kdtEntrys.addRow();
            row.setUserObject((Object)detailData);
            BindingUtility.loadDataToTableLine(i, detailData, kdtEntrys, null, this.componentMap);
        }
        this.setTablePropertyChange(propertyChange);
    }

    public void bindTableToData(KDTable table, IObjectCollection detailCollection) {
        if (detailCollection == null) {
            return;
        }
        detailCollection.clear();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            IObjectValue obj = (IObjectValue)row.getUserObject();
            if (!detailCollection.addObject(obj)) continue;
            this.storeLineFields(table, row, obj);
        }
    }

    public DataComponentMap getDataComponentMap() {
        return this.componentMap;
    }

    public void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        BindingUtility.storeLine(table, row.getRowIndex(), null, this.componentMap, this.support);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyLsn) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyName, propertyLsn);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyLsn) {
        this.support.removePropertyChangeListener(propertyLsn);
    }

    public IObjectCollection getObjectCollection() {
        return this.collection;
    }

    public void setObjectCollection(IObjectCollection objectCollection) {
        this.collection = objectCollection;
    }

    public void registerBindingForTable(String fieldName, Class clazz, Component comp, String compProperty) {
        final Field f = new Field(fieldName);
        f.setFieldClazz(clazz);
        ComponentProperty cp = new ComponentProperty(compProperty, comp);
        this.componentMap.register(f, cp);
        if (comp instanceof KDTable && compProperty.equals("userObject")) {
            final KDTable table = (KDTable)comp;
            table.setAfterAction(new BeforeActionListener(){

                public void beforeAction(BeforeActionEvent e) {
                    if (e.getType() == 1 && table.getSelectManager().get() != null) {
                        int selectedRow = table.getSelectManager().get().getBeginRow();
                        if (selectedRow < 0 || selectedRow >= table.getRowCount()) {
                            return;
                        }
                        BindingUtility.storeLine(table, selectedRow, f, DataBinder.this.componentMap, DataBinder.this.support);
                    }
                }
            });
            table.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent event) {
                    int preRow;
                    if (event.getPrevSelectBlock() != null && (preRow = event.getPrevSelectBlock().getBeginRow()) >= 0) {
                        BindingUtility.storeLine(table, preRow, f, DataBinder.this.componentMap, DataBinder.this.support);
                    }
                }
            });
        }
    }

    public void loadCollectionFields() {
        if (this.collection == null) {
            return;
        }
        BindingUtility.loadDetailData(this.getObjectCollection(), new Field("header"), this.componentMap, this.support);
    }

    public void storeCollectionFields() {
        if (this.collection == null) {
            return;
        }
        ArrayList detailList = this.componentMap.getDetailList(DataComponentMap.HEAD_FIELD);
        if (detailList != null) {
            Field detailField = null;
            int length = detailList.size();
            for (int j = 0; j < length; ++j) {
                detailField = (Field)detailList.get(j);
                KDTable table = this.componentMap.getTable(detailField);
                BindingUtility.storeTableToData(table, detailField, this.componentMap, this.support);
            }
        }
    }
}

