/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.databinding;

import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataComponentMap {
    private HashMap compToField;
    private HashMap fieldToComp;
    private HashMap detailHiberarchy;
    public static final Field HEAD_FIELD = new Field("header");
    private ArrayList headerFields;
    private HashMap detailToTable;
    private HashMap tableToDetail;
    private HashMap detailToFields;
    private HashMap tableToFields;

    public DataComponentMap() {
        this.init();
    }

    private void init() {
        this.compToField = new HashMap();
        this.fieldToComp = new HashMap();
        this.headerFields = new ArrayList();
        this.detailToTable = new HashMap();
        this.tableToDetail = new HashMap();
        this.detailToFields = new HashMap();
        this.detailHiberarchy = new HashMap();
        this.tableToFields = new HashMap();
    }

    public ComponentProperty getComponentProperty(Field field) {
        return (ComponentProperty)this.fieldToComp.get(field);
    }

    public ComponentProperty getComponentProperty(String fieldName) {
        if (fieldName != null && !fieldName.equals("")) {
            Field f = new Field();
            f.setName(fieldName);
            return (ComponentProperty)this.fieldToComp.get(f);
        }
        return null;
    }

    public Field getField(ComponentProperty comp) {
        if (comp != null) {
            return (Field)this.compToField.get(comp);
        }
        return null;
    }

    public void clear() {
        this.compToField.clear();
        this.fieldToComp.clear();
        this.headerFields.clear();
    }

    public void register(Field field, ComponentProperty compProperty) {
        assert (field != null);
        assert (compProperty != null);
        if (this.fieldToComp.get(field) != null) {
            this.compToField.remove(this.fieldToComp.get(field));
            this.fieldToComp.remove(field);
        }
        if (this.compToField.get(compProperty) != null) {
            this.fieldToComp.remove(this.compToField.get(compProperty));
            this.compToField.remove(compProperty);
        }
        this.fieldToComp.put(field, compProperty);
        this.compToField.put(compProperty, field);
        if (compProperty.getComponent() instanceof KDTable) {
            if (compProperty.getPropertyName().equals("userObject")) {
                this.detailToTable.put(field, compProperty.getComponent());
                this.tableToDetail.put(compProperty.getComponent(), field);
                ArrayList colFields = (ArrayList)this.tableToFields.get(compProperty.getComponent());
                if (colFields != null) {
                    this.detailToFields.put(field, colFields);
                    Field colField = null;
                    for (int i = 0; i < colFields.size(); ++i) {
                        colField = (Field)colFields.get(i);
                        colField.setParentName(field.getName());
                    }
                }
                this.buildDetailHiberarchy(field);
            } else if (compProperty.getPropertyName().indexOf(".text") >= 0) {
                Field detailField = (Field)this.tableToDetail.get(compProperty.getComponent());
                if (detailField != null) {
                    ArrayList<Field> detailFields = (ArrayList<Field>)this.detailToFields.get(detailField);
                    if (detailFields == null) {
                        detailFields = new ArrayList<Field>();
                        this.detailToFields.put(detailField, detailFields);
                    }
                    field.setParentName(detailField.getName());
                    detailFields.add(field);
                } else {
                    ArrayList<Field> tableFields = (ArrayList<Field>)this.tableToFields.get(compProperty.getComponent());
                    if (tableFields == null) {
                        tableFields = new ArrayList<Field>();
                        this.tableToFields.put(compProperty.getComponent(), tableFields);
                    }
                    tableFields.add(field);
                }
                String temp = compProperty.getPropertyName();
                compProperty.setPropertyName(temp.substring(0, temp.length() - 5));
            }
        } else {
            this.getHeaderFields().add(field);
        }
    }

    public void unRegister(Field field, ComponentProperty compProperty) {
        assert (field != null);
        assert (compProperty != null);
        if (this.fieldToComp.get(field) != null) {
            this.compToField.remove(this.fieldToComp.get(field));
            this.fieldToComp.remove(field);
        }
        if (this.compToField.get(compProperty) != null) {
            this.fieldToComp.remove(this.compToField.get(compProperty));
            this.compToField.remove(compProperty);
        }
        if (compProperty.getComponent() instanceof KDTable) {
            if (compProperty.getPropertyName().equals("userObject")) {
                this.detailToTable.remove(field);
                this.tableToDetail.remove(compProperty.getComponent());
                ArrayList colFields = (ArrayList)this.tableToFields.get(compProperty.getComponent());
                if (colFields != null) {
                    colFields.clear();
                }
                this.clearDetailHiberarchy(field);
            } else if (compProperty.getPropertyName().indexOf(".text") >= 0) {
                Field detailField = (Field)this.tableToDetail.get(compProperty.getComponent());
                if (detailField != null) {
                    ArrayList detailFields = (ArrayList)this.detailToFields.get(detailField);
                    if (detailFields != null) {
                        detailFields.remove(field);
                    }
                } else {
                    ArrayList tableFields = (ArrayList)this.tableToFields.get(compProperty.getComponent());
                    if (tableFields != null) {
                        tableFields.remove(field);
                    }
                }
                compProperty.getComponent();
            }
        } else {
            this.getHeaderFields().remove(field);
        }
    }

    private void clearDetailHiberarchy(Field detailField) {
        Iterator dfIterator = this.detailHiberarchy.keySet().iterator();
        Field dfField = null;
        String parentFieldName = null;
        int index = detailField.getName().lastIndexOf(".");
        if (index > 0) {
            parentFieldName = detailField.getName().substring(0, index);
            while (dfIterator.hasNext()) {
                dfField = (Field)dfIterator.next();
                if (dfField.getName().equals(parentFieldName)) {
                    detailField.setParentName(parentFieldName);
                    break;
                }
                dfField = null;
            }
        } else {
            dfField = HEAD_FIELD;
        }
        if (dfField != null) {
            ArrayList nextDetailList = (ArrayList)this.detailHiberarchy.get(dfField);
            if (nextDetailList != null) {
                nextDetailList.remove(detailField);
            }
            this.detailHiberarchy.remove(detailField);
        }
    }

    private void buildDetailHiberarchy(Field detailField) {
        Iterator dfIterator = this.detailHiberarchy.keySet().iterator();
        Field dfField = null;
        String parentFieldName = null;
        int index = detailField.getName().lastIndexOf(".");
        if (index > 0) {
            parentFieldName = detailField.getName().substring(0, index);
            while (dfIterator.hasNext()) {
                dfField = (Field)dfIterator.next();
                if (dfField.getName().equals(parentFieldName)) {
                    detailField.setParentName(parentFieldName);
                    break;
                }
                dfField = null;
            }
        } else {
            dfField = HEAD_FIELD;
        }
        if (dfField != null) {
            ArrayList<Field> nextDetailList = (ArrayList<Field>)this.detailHiberarchy.get(dfField);
            if (nextDetailList == null) {
                nextDetailList = new ArrayList<Field>();
                this.detailHiberarchy.put(dfField, nextDetailList);
            }
            nextDetailList.add(detailField);
        }
        if (!this.detailHiberarchy.containsKey(detailField)) {
            this.detailHiberarchy.put(detailField, new ArrayList());
        }
    }

    public ArrayList getDetailFields(Field detail) {
        return (ArrayList)this.detailToFields.get(detail);
    }

    public ArrayList getDetailList(Field parentField) {
        return (ArrayList)this.detailHiberarchy.get(parentField);
    }

    public void analyseDetail() {
    }

    public ArrayList getHeaderFields() {
        return this.headerFields;
    }

    public KDTable getTable(Field detailField) {
        return (KDTable)this.detailToTable.get(detailField);
    }

    public Field getDetail(KDTable table) {
        return (Field)this.tableToDetail.get(table);
    }

    public Map getTableToField() {
        return this.tableToFields;
    }
}

