/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.databinding;

import com.kingdee.bos.ReflectException;
import com.kingdee.bos.appframework.databinding.ConfigurePropertyAccess;
import com.kingdee.bos.appframework.databinding.Getter;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.configure.PropertyNotFoundException;
import java.lang.reflect.InvocationTargetException;

public class ObjectValueDynamicGetter
implements Getter {
    private final String configedPropetyName;

    public ObjectValueDynamicGetter(String configedPropetyName) {
        this.configedPropetyName = configedPropetyName;
    }

    @Override
    public Class getReturnType() {
        return Object.class;
    }

    @Override
    public Object invoke(Object obj, Object[] objs) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj instanceof IObjectValue) {
            IObjectValue ov = (IObjectValue)obj;
            try {
                return ConfigurePropertyAccess.getProperty(ov, this.configedPropetyName);
            }
            catch (ReflectException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalAccessException) {
                    throw (IllegalAccessException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                if (cause instanceof InvocationTargetException) {
                    throw (InvocationTargetException)cause;
                }
            }
            catch (PropertyNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return null;
    }
}

