/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.exception;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.exception.IMultiExceptionMessageFormatter;
import com.kingdee.bos.appframework.validator.ValidateError;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class ValidateErrorFormatter
implements IMultiExceptionMessageFormatter,
Serializable {
    private Context context;

    public ValidateErrorFormatter() {
    }

    public ValidateErrorFormatter(Context context) {
        this.context = context;
    }

    @Override
    public String getFormatMessage(Map errors) {
        StringBuffer buf = new StringBuffer();
        for (String prop : errors.keySet()) {
            ValidateError err = (ValidateError)errors.get(prop);
            if (this.getAliasName(err.getDataObject(), prop) == null) {
                buf.append("Others");
            } else {
                buf.append(this.getAliasName(err.getDataObject(), prop));
            }
            buf.append(":\r\n");
            List exceptions = err.getExceptions();
            for (int i = 0; i < exceptions.size(); ++i) {
                Exception exception = (Exception)exceptions.get(i);
                buf.append("\u3000\u3000" + exception.getMessage());
                buf.append("\r\n");
            }
        }
        return buf.toString();
    }

    private String getAliasName(IObjectValue dataObject, String propertyName) {
        IMetaDataLoader loader = this.context == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.context);
        if (loader == null) {
            return propertyName;
        }
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataObject.getBOSType());
        PropertyInfo property = null;
        if (entity == null) {
            return propertyName;
        }
        property = entity.getPropertyByNameRuntime(propertyName);
        if (property == null) {
            return propertyName;
        }
        return property.getAlias();
    }
}

