/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.syncUI;

import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.StateInfo;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MonitorDialog {
    static KDWorkButton btnClose = null;
    static JPanel monitorPanel = null;
    static SimpleStatusBarRenderer monitorRender = null;
    static KDPanel topPanel = null;

    public MonitorDialog(SimpleStatusBarRenderer render, Icon icon) {
        MonitorDialog.createMonitor(render, icon);
    }

    public static void createMonitor(SimpleStatusBarRenderer render, Icon icon) {
        Icon buttonIcon = null;
        if (monitorRender == null && render == null) {
            return;
        }
        buttonIcon = icon != null ? icon : btnClose.getIcon();
        if (render != null) {
            monitorPanel = render.getPopupPane();
            monitorRender = render;
        }
        monitorPanel.removeAll();
        monitorPanel.setPreferredSize(new Dimension(250, 200));
        monitorPanel.setLayout(new FlowLayout(1, 0, 0));
        monitorPanel.setBackground(UIManager.getColor("eas.infopane.border"));
        monitorPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("eas.infopane.border")));
        if (buttonIcon != null) {
            KDPanel titlePanel = new KDPanel(null);
            btnClose = new KDWorkButton();
            btnClose.setIcon(buttonIcon);
            btnClose.setRolloverEnabled(true);
            btnClose.setFocusable(false);
            btnClose.setBounds(228, 3, 18, 17);
            btnClose.setOpaque(false);
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    monitorRender.setPopupVisible(false);
                }
            });
            ResourceBundleHelper rbh = new ResourceBundleHelper("com.kingdee.bos.appframework.syncUI.MonitorDialogResource", ContextUtils.getOriginalLocaleFromEnv(), null, MetaDataTypeList.MULTILANGUAGE);
            String info = rbh.getString("backgroundRunMonitor");
            if (StringUtils.isEmpty((String)info)) {
                info = "\u540e\u53f0\u8fd0\u884c\u76d1\u63a7";
            }
            KDLabel label = new KDLabel(info);
            label.setBounds(0, 0, 180, 20);
            titlePanel.setPreferredSize(new Dimension(248, 30));
            titlePanel.setBounds(0, 0, 248, 30);
            titlePanel.setBackground(UIManager.getColor("eas.infopanel.title.bg"));
            titlePanel.add((Component)label);
            titlePanel.add((Component)btnClose);
            KDButton btnRefresh = new KDButton();
            btnRefresh.setBackground(Color.GREEN);
            btnRefresh.setLimitedSize(false);
            btnRefresh.setBounds(200, 3, 18, 17);
            btnRefresh.setPreferredSize(new Dimension(25, 25));
            btnRefresh.setAutoToolTipText(true);
            btnRefresh.setIcon(UIFrameResource.getCommonIcon((String)"imgTbtn_refresh"));
            btnRefresh.setToolTipText("\u5237\u65b0");
            btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonitorDialog.updateTopPanelUI();
                }
            });
            titlePanel.add((Component)btnRefresh);
            monitorPanel.add((Component)titlePanel);
        }
        MonitorDialog.updateTopPanelUI();
    }

    private static void updateTopPanelUI() {
        if (topPanel != null) {
            topPanel.removeAll();
            monitorPanel.remove((Component)topPanel);
        } else {
            topPanel = new KDPanel();
            topPanel.setPreferredSize(new Dimension(248, 170));
            topPanel.setBounds(0, 30, 248, 170);
            topPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 30, 248, 170));
            topPanel.setBackground(UIManager.getColor("eas.infopanel.content.bg"));
        }
        int hPosition = 70;
        Set threadSet = ThreadPool.getCurrentThread();
        Iterator lt = threadSet.iterator();
        int infoCount = 0;
        while (lt.hasNext() && infoCount <= 4) {
            ++infoCount;
            final MonitorInfo info = (MonitorInfo)lt.next();
            KDProgressBar progressBar = new KDProgressBar(0, 100);
            progressBar.setStringPainted(true);
            topPanel.add((Component)progressBar);
            KDLabel label = new KDLabel();
            if (info.getWorker() != null && info.getWorker().isIsFinished()) {
                progressBar.setValue(100);
                progressBar.setString("100%");
                progressBar.setToolTipText("100%");
                progressBar.setBounds(5, hPosition, 215, 10);
                progressBar.setPreferredSize(new Dimension(215, 10));
                label.setUnderline(true);
                label.setUnderlineColor(Color.BLUE);
                label.setForeground(Color.BLUE);
                label.setCursor(Cursor.getPredefinedCursor(12));
                label.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (info.getWorker().isIsFinished()) {
                            info.getWorker().finishedLater();
                        }
                        ThreadPool.destroyMonitor(info);
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
                hPosition += 11;
            } else {
                if (info.getWorker() != null) {
                    StateInfo stateInfo = info.getWorker().getStateInfo();
                    if (null != stateInfo) {
                        if (stateInfo.isCanStop()) {
                            final KDButton stopLabel = new KDButton();
                            stopLabel.setBackground(Color.RED);
                            stopLabel.setLimitedSize(false);
                            stopLabel.setBounds(220, hPosition, 12, 12);
                            stopLabel.setPreferredSize(new Dimension(12, 12));
                            stopLabel.setToolTipText("\u505c\u6b62");
                            topPanel.add((Component)stopLabel);
                            stopLabel.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (0 == MsgBox.showConfirm2New((Component)stopLabel, (String)"\u786e\u8ba4\u7ec8\u6b62\u6b64\u4efb\u52a1\u5417\uff1f")) {
                                        info.getWorker().stop();
                                        info.getWorker().interrupt();
                                        info.getWorker().finishedLater();
                                    }
                                }
                            });
                        }
                        String tip = stateInfo.getProgress() + "%";
                        progressBar.setValue(stateInfo.getProgress());
                        progressBar.setString(tip);
                        progressBar.setToolTipText(tip);
                        progressBar.setBounds(5, hPosition, 205, 10);
                        progressBar.setPreferredSize(new Dimension(205, 10));
                        if (!StringUtils.isEmpty((String)stateInfo.getProgressDetail())) {
                            KDLabel progressLabel = new KDLabel(stateInfo.getProgressDetail());
                            progressLabel.setPreferredSize(new Dimension(235, 12));
                            progressLabel.setBounds(5, hPosition + 12, 235, 12);
                            progressLabel.setForeground(Color.RED);
                            topPanel.add((Component)progressLabel);
                        }
                    } else {
                        progressBar.setStringPainted(false);
                        progressBar.setBounds(5, hPosition, 205, 10);
                        progressBar.setPreferredSize(new Dimension(205, 10));
                    }
                }
                hPosition += 25;
            }
            label.setPreferredSize(new Dimension(235, 12));
            label.setBounds(5, hPosition, 235, 12);
            hPosition += 13;
            label.setText(info.getTitle());
            label.setToolTipText(info.getTitle());
            topPanel.add((Component)label);
        }
        monitorPanel.add((Component)topPanel);
        monitorPanel.updateUI();
    }
}

