/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.syncUI;

import com.kingdee.bos.appframework.syncUI.BeanMonitor;
import com.kingdee.bos.appframework.syncUI.BeanPropertyChangeListener;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.ProgressBarDialog;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import java.util.HashSet;
import java.util.Set;

public class ThreadPool {
    private static Set threadSet = new HashSet();
    private static BeanMonitor beanMonitor = null;
    private static KDDialog progressDialog = null;
    private static String hint = "";
    private static boolean enable;

    public static ThreadPool getInstance() {
        if (progressDialog == null) {
            progressDialog = ProgressBarDialog.getDialogInstance(null);
        } else {
            progressDialog.setLocationRelativeTo(null);
        }
        return new ThreadPool();
    }

    public static Set getCurrentThread() {
        return threadSet;
    }

    public static String getHint() {
        return hint;
    }

    public static boolean isShowDialog() {
        if (beanMonitor != null) {
            return beanMonitor.isShowDialog();
        }
        return false;
    }

    public static void addActionThread(MonitorInfo info) {
        hint = info.getTitle();
        threadSet.add(info);
        ThreadPool.createBeanMonitor();
        if (info.isDialog()) {
            ThreadPool.showProgressDialog(info.getUi(), info.getTitle());
        }
        beanMonitor.setRefreshMonitor(ThreadPool.getCurrentThread().size());
        if (info.getWorker() != null) {
            info.getWorker().start();
        }
    }

    public static void removeActionThread(Object obj) {
        if (!ThreadPool.getCurrentThread().contains(obj)) {
            return;
        }
        ThreadPool.getCurrentThread().remove(obj);
        beanMonitor.setRefreshMonitor(ThreadPool.getCurrentThread().size());
        ((SwingWorker)obj).interrupt();
    }

    private static BeanMonitor createBeanMonitor() {
        if (beanMonitor == null) {
            beanMonitor = new BeanMonitor();
            beanMonitor.addPropertyChangeListener(new BeanPropertyChangeListener());
        }
        return beanMonitor;
    }

    public static void destroyMonitor() {
        ThreadPool.destroyMonitor(null);
    }

    public static void destroyMonitor(MonitorInfo info) {
        if (beanMonitor == null) {
            return;
        }
        beanMonitor.setShowDialog(false);
        if (info != null) {
            ThreadPool.getCurrentThread().remove(info);
            beanMonitor.setRefreshMonitor(ThreadPool.getCurrentThread().size());
            ThreadPool.setBackgroundRunButtonEnabled(true);
        }
    }

    public static void showProgressDialog(Object ui, String hint) {
        if (progressDialog == null) {
            progressDialog = ProgressBarDialog.getDialogInstance(ui);
        } else {
            progressDialog.setLocationRelativeTo(null);
        }
        if (beanMonitor == null || beanMonitor.isShowDialog() || progressDialog.isShowing()) {
            return;
        }
        if (hint == null) {
            hint = "";
        }
        progressDialog.setTitle(hint + "...");
        beanMonitor.setShowDialog(true);
        SwingWorker worker = ThreadPool.getSwingWorker();
        worker.start();
    }

    public static void destroyPorgressDialog() {
        if (progressDialog == null) {
            return;
        }
        progressDialog.dispose();
    }

    private static SwingWorker getSwingWorker() {
        SwingWorker dialogWorker = new SwingWorker(){

            @Override
            public Object construct() {
                if (progressDialog == null) {
                    throw new NullPointerException("progressDialog is not initial!");
                }
                ThreadPool.setEnabled(enable);
                progressDialog.show();
                return null;
            }
        };
        return dialogWorker;
    }

    public static void setBackgroundRunButtonEnabled(boolean b) {
        enable = b;
        ThreadPool.setEnabled(b);
    }

    private static void setEnabled(boolean b) {
        if (progressDialog != null) {
            ((ProgressBarDialog)progressDialog).setBackgroundRunButtonEnabled(b);
        }
    }
}

