/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.uistatemanage;

import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.uistatemanage.ActionPluginCallBack;
import com.kingdee.bos.appframework.uistatemanage.ActionState;
import com.kingdee.bos.appframework.uistatemanage.ActionStateProvider;
import com.kingdee.bos.appframework.uistatemanage.IVoBridge;
import com.kingdee.bos.appframework.uistatemanage.UIState;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class ActionManager
implements ActionPluginCallBack {
    private static final Logger logger = Logger.getLogger(ActionManager.class);
    private CoreUIObject ui;
    private IObjectPK userPk;
    private IVoBridge voBridge;
    private boolean multipleDataCheck = false;
    private static final ItemAction nullAction = new ItemAction();
    private HashMap actionSetForCompute;
    private HashMap actionSet;
    private HashMap uiStateSet;
    private ArrayList actionStateProviders;
    private HashMap actionNameSet = new HashMap();
    private ActionPluginCallBack plgCallBacks = null;
    private IBindService plgService = null;

    public boolean isMultipleDataCheck() {
        return this.multipleDataCheck;
    }

    public void setMultipleDataCheck(boolean multipleDataCheck) {
        this.multipleDataCheck = multipleDataCheck;
    }

    public ActionManager() {
        this(null, null);
    }

    public ActionManager(CoreUIObject uiObj) {
        this(uiObj, null);
    }

    public ActionManager(CoreUIObject uiobj, IObjectPK uPk) {
        this.ui = uiobj;
        this.userPk = uPk;
        this.registerActionStateProvider(new UIStateActionStateProvider());
    }

    public int getActionSize() {
        if (this.actionSetForCompute == null || this.actionSetForCompute.size() == 0) {
            return 0;
        }
        int actionCount = 0;
        Collection collection = this.actionSet.values();
        for (ItemAction action : collection) {
            if (action == null || !action.isBindWorkFlow()) continue;
            ++actionCount;
        }
        return actionCount;
    }

    public void setUserPk(IObjectPK userPk) {
        this.userPk = userPk;
    }

    public ItemAction getAction(String actionName) {
        if (this.actionSet != null && this.actionSet.containsKey(actionName)) {
            return (ItemAction)this.actionSet.get(actionName);
        }
        return nullAction;
    }

    public void setActionState(String actionName, boolean enabled) {
        this.getAction(actionName).setEnabled(enabled);
    }

    public void registerAction(String actionName, ItemAction itemAction) {
        if (this.actionSetForCompute == null) {
            this.actionSetForCompute = new HashMap();
        }
        this.getActionSet().put(actionName, itemAction);
        this.actionNameSet.put(itemAction, actionName);
        this.actionSetForCompute.put(actionName, new ActionState(actionName, 1));
        this.addPluginService(itemAction);
    }

    void addPluginService(ItemAction itemAction) {
        try {
            if (this.plgCallBacks == null && this.plgService == null) {
                Class<?> c = Class.forName("com.kingdee.eas.ep.client.PluginService");
                Constructor<?> constructor = c.getConstructor(CoreUIObject.class);
                Object service = constructor.newInstance(this.ui);
                if (service instanceof IBindService) {
                    this.plgService = (IBindService)service;
                }
                if (service instanceof ActionPluginCallBack) {
                    this.plgCallBacks = (ActionPluginCallBack)service;
                }
            }
            if (this.plgService != null) {
                itemAction.addService(this.plgService);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Register PluginService Error:" + e.getMessage()));
        }
    }

    @Override
    public void setUIParam(Object param) {
        if (this.plgCallBacks != null) {
            this.plgCallBacks.setUIParam(param);
        }
    }

    public void registerActionStateProvider(ActionStateProvider provider) {
        if (this.actionStateProviders == null) {
            this.actionStateProviders = new ArrayList();
            this.actionStateProviders.add(provider);
        } else {
            this.actionStateProviders.add(this.actionStateProviders.size() - 1, provider);
        }
    }

    public void registerUIState(String uiState, String actionName, int acState) {
        ActionState actionState = new ActionState();
        actionState.setActionName(actionName);
        actionState.setState(acState);
        this.getUIStateSet().put(uiState, actionState);
    }

    public void registerUIState(String uiState, Component comp, int acState) {
        UIState us = (UIState)this.getUIStateSet().get(uiState);
        if (us == null) {
            us = new UIState();
            this.getUIStateSet().put(uiState, us);
        }
        us.getActionSet().put(comp, acState);
    }

    public void registerUIState(String uiState, Action action, int acState) {
        UIState us = (UIState)this.getUIStateSet().get(uiState);
        if (us == null) {
            us = new UIState();
            this.getUIStateSet().put(uiState, us);
        }
        us.getActionSet().put(action, acState);
    }

    public List computeActionState() {
        if (this.voBridge == null) {
            logger.info((Object)"not set voBridge.");
            return null;
        }
        List disableActionList = new ArrayList(10);
        if (this.isMultipleDataCheck()) {
            List voList = this.voBridge.getCurrentVoList();
            if (voList != null) {
                List disList = null;
                int j = voList.size();
                for (int i = 0; i < j; ++i) {
                    disList = this.computeActionState((IObjectValue)voList.get(i));
                    if (disList == null || disList.size() <= 0) continue;
                    int h = disList.size();
                    for (int k = 0; k < h; ++k) {
                        if (disableActionList.contains(disList.get(k))) continue;
                        disableActionList.add(disList.get(k));
                    }
                }
            } else {
                disableActionList = this.computeActionState(this.voBridge.getCurrentVo());
            }
        } else {
            disableActionList = this.computeActionState(this.voBridge.getCurrentVo());
        }
        return disableActionList;
    }

    private List computeActionState(IObjectValue vo) {
        if (vo == null) {
            return null;
        }
        if (this.actionSet == null) {
            return null;
        }
        ArrayList<Object> disableActionList = new ArrayList<Object>(10);
        if (this.actionStateProviders != null && this.actionStateProviders.size() > 0) {
            HashMap initActionSet = (HashMap)this.actionSetForCompute.clone();
            ActionStateProvider provider = null;
            int length = this.actionStateProviders.size();
            for (int i = 0; i < length; ++i) {
                provider = (ActionStateProvider)this.actionStateProviders.get(i);
                HashMap disableAction = provider.getActionState(vo, this.userPk, this.ui.getClass().getName(), initActionSet);
                if (disableAction == null) continue;
                Object[] disableKeys = disableAction.keySet().toArray();
                for (int j = 0; j < disableKeys.length; ++j) {
                    initActionSet.remove(disableKeys[j]);
                    disableActionList.add(disableKeys[j]);
                    logger.info((Object)(provider.getClass() + " makes action:" + disableKeys[j] + " disabled."));
                }
            }
        }
        return disableActionList;
    }

    public UIState getUIState(String opr) {
        return (UIState)this.getUIStateSet().get(opr);
    }

    public void enableAllAction() {
        if (this.actionSet == null) {
            return;
        }
        Iterator itAction = this.actionSet.values().iterator();
        while (itAction.hasNext()) {
            ((ItemAction)itAction.next()).setEnabled(true);
        }
    }

    public IVoBridge getVoBridge() {
        return this.voBridge;
    }

    public void setVoBridge(IVoBridge voBridge) {
        this.voBridge = voBridge;
    }

    public HashMap getActionSet() {
        if (this.actionSet == null) {
            this.actionSet = new HashMap();
        }
        return this.actionSet;
    }

    private HashMap getUIStateSet() {
        if (this.uiStateSet == null) {
            this.uiStateSet = new HashMap();
        }
        return this.uiStateSet;
    }

    public class UIStateActionStateProvider
    implements ActionStateProvider {
        @Override
        public HashMap getActionState(IObjectValue vo, IObjectPK userInfoPk, String uiClass, HashMap actionSet) {
            if (ActionManager.this.ui.getOprtState() == null) {
                return null;
            }
            HashMap retDisableAction = new HashMap();
            UIState uiState = ActionManager.this.getUIState(ActionManager.this.ui.getOprtState());
            if (uiState == null) {
                return null;
            }
            for (Object acStateTarget : uiState.getActionSet().keySet()) {
                if (!(acStateTarget instanceof Action)) continue;
                Action ac = (Action)acStateTarget;
                if ((Integer)uiState.getActionSet().get(acStateTarget) != 0) continue;
                retDisableAction.put(ActionManager.this.actionNameSet.get(ac), new ActionState(null, 0));
            }
            return retDisableAction;
        }
    }
}

