/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.exception.ValidateFailedException;
import com.kingdee.bos.appframework.validator.Validator;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.PropertyConstriantValidator;
import com.kingdee.bos.dao.ormapping.PropertyValidateFailedException;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.entity.ConstraintInfo;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ValidateHelper {
    public static final String ON_DATACHANGE = "DataChange";
    public static final String ON_SAVE = "Save";
    public static final String DATABINDER = "DataBinder";
    public static final String SOURCE_COMPONENT = "SourceComponent";
    public static final String VALIDATE_HELPER = "ValidateHelper";
    private static final String PREFIX = "validate";
    private static final String SEPARATE = "_";
    private static final String CTRL = "Ctrl";
    private static final String PROPERTY = "Property";
    private DataBinder binder;
    private Set properties = new LinkedHashSet();
    private Validator customValidator;
    private IObjectValue dataObject;

    public ValidateHelper() {
    }

    public ValidateHelper(IObjectValue dataObject, DataBinder binder) {
        this.dataObject = dataObject;
        this.binder = binder;
    }

    public void registerBindProperty(String propertyName, String type) {
        if (this.binder == null) {
            return;
        }
        Component c = this.binder.getComponetByField(propertyName);
        if (c == null) {
            return;
        }
        if (ON_DATACHANGE.equals(type)) {
            return;
        }
        if (ON_SAVE.equals(type)) {
            this.properties.add(propertyName);
        }
    }

    public void removeBindProperty(String propertyName, String type) {
        if (this.binder == null) {
            return;
        }
        Component c = this.binder.getComponetByField(propertyName);
        if (c == null) {
            return;
        }
        if (ON_DATACHANGE.equals(type)) {
            return;
        }
        if (ON_SAVE.equals(type)) {
            this.properties.remove(propertyName);
        }
    }

    public void validateCtrl(String ctrlName) {
        String m = "validate_Ctrl_" + ctrlName;
        this.invoke(m);
    }

    private void validatePropertyConstrain(String[] propertyName, ValidateFailedException ve) {
        if (this.dataObject == null || propertyName == null || propertyName.length <= 0) {
            return;
        }
        SimplePropertyCollection propCol = null;
        try {
            EntitySelect select = new EntitySelect(this.dataObject.getBOSType());
            select.propertySelect().selectOwnProperty(propertyName, new String[]{"constraint"});
            propCol = MetaDataAccessFactory.getRemoteInstance().select(select).properties();
        }
        catch (BOSException select) {
            // empty catch block
        }
        if (propCol != null) {
            int size = propCol.size();
            for (int i = 0; i < size; ++i) {
                SimpleProperty p = propCol.get(i);
                ConstraintInfo constraint = p.getConstraint();
                if (constraint == null) continue;
                try {
                    PropertyConstriantValidator.validateConstraint(null, (ConstraintInfo)constraint, (Object)this.dataObject.get(p.getName()));
                    continue;
                }
                catch (PropertyValidateFailedException e) {
                    ve.addError(p.getName(), this.dataObject, (Exception)((Object)e));
                }
            }
        }
    }

    public void validatePropertyCustom(String propertyName) {
        String m = "validate_Property_" + propertyName;
        this.invoke(m);
    }

    public void validateAll() throws ValidateFailedException {
        ValidateFailedException ve = new ValidateFailedException();
        if (this.customValidator != null) {
            this.customValidator.setVe(ve);
        }
        String[] names = new String[this.properties.size()];
        int i = 0;
        Iterator itr = this.properties.iterator();
        while (itr.hasNext()) {
            String name;
            names[i] = name = (String)itr.next();
            if (this.customValidator != null) {
                this.validatePropertyCustom(name);
            }
            ++i;
        }
        this.validatePropertyConstrain(names, ve);
        throw ve;
    }

    public Validator getCustomValidator() {
        return this.customValidator;
    }

    public void setCustomValidator(Validator customValidator) {
        this.customValidator = customValidator;
    }

    private Object invoke(String name) {
        Method method = null;
        Object result = null;
        try {
            method = this.customValidator.getClass().getMethod(name, null);
        }
        catch (NoSuchMethodException nsmex) {
            method = null;
        }
        catch (SecurityException se) {
            method = null;
        }
        if (method == null) {
            return null;
        }
        try {
            result = method.invoke((Object)this.customValidator, null);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() != null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            if (e.getCause() != null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
        return result;
    }

    public IObjectValue getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(IObjectValue dataObject) {
        this.dataObject = dataObject;
    }
}

