/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.appframework.validator;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.exception.ValidateFailedException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import java.awt.Component;

public abstract class Validator {
    private ValidateFailedException ve;
    protected CoreUIObject ui;
    protected DataBinder binder;
    protected Component currentComponent;

    public Validator(CoreUIObject ui) {
        this.ui = ui;
    }

    public Validator(CoreUIObject ui, DataBinder binder) {
        this.ui = ui;
        this.binder = binder;
    }

    protected Component getComponentByName(String componentName) {
        if (this.ui == null) {
            return null;
        }
        Component[] components = this.ui.getComponents();
        Component result = null;
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].getName().equals(componentName)) continue;
            this.currentComponent = result = components[i];
            break;
        }
        return result;
    }

    protected void addError(String propertyName, Exception exception) {
        if (this.ui == null || this.ve == null) {
            return;
        }
        Component first = null;
        if (this.ve.getFirstErr() == null) {
            first = this.currentComponent;
        }
        this.ve.addError(propertyName, this.ui.getDataObject(), exception);
        if (first != null) {
            this.ve.getFirstErr().setSource(first);
        }
    }

    public String[] getValidateCtrls() {
        return null;
    }

    public DataBinder getBinder() {
        return this.binder;
    }

    public void setBinder(DataBinder binder) {
        this.binder = binder;
    }

    public ValidateFailedException getVe() {
        return this.ve;
    }

    public void setVe(ValidateFailedException ve) {
        this.ve = ve;
    }

    public Component getCurrentComponent() {
        return this.currentComponent;
    }

    public void setCurrentComponent(Component currentComponent) {
        this.currentComponent = currentComponent;
    }

    public IUIObject getUi() {
        return this.ui;
    }

    public void setUi(CoreUIObject ui) {
        this.ui = ui;
    }
}

