/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bindserver;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.bindserver.ICompBindingServer;
import com.kingdee.bos.ui.util.UICommonUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JComponent;

public class CompBindingServer
implements ICompBindingServer {
    public static final String DEFAULT_OBJECTVALUE = "defaultObjectNameOfUI";
    private ArrayList valueObjectSet = null;
    private Hashtable bindObjSet = null;
    private String currentObjValueKey = null;

    public void regist(IObjectValue objValue) {
        this.regist(DEFAULT_OBJECTVALUE, objValue);
    }

    public void regist(String key, IObjectValue objValue) {
        if (key == null) {
            throw new IllegalArgumentException("key cann't be null,or ObjectValue cann't be null.");
        }
        if (!this.getValueObjectSet().contains(key)) {
            this.getValueObjectSet().add(key);
        }
        this.currentObjValueKey = key;
    }

    public void unRegist(String key) {
        this.getValueObjectSet().remove(key);
        this.getBindObjSet().remove(key);
    }

    public void lookup() {
        this.lookup(DEFAULT_OBJECTVALUE);
    }

    public void lookup(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cann't be null.");
        }
        this.currentObjValueKey = null;
        if (!this.getValueObjectSet().contains(key)) {
            throw new IllegalArgumentException("argument \"key=\"" + key + "\" is incorrect, don't find corresponding ObjectValue.");
        }
        this.currentObjValueKey = key;
    }

    public void bindingComponent(JComponent c, String objValueParam) {
        this.bindingComponent(c, objValueParam, 4);
    }

    public void bindingComponent(JComponent c, String objValueParam, int rw) {
        this.bindingComponent(c, UICommonUtils.getCompAttrName(c), objValueParam, rw);
    }

    public void bindingComponent(JComponent c, String compParm, String objValueParam) {
        this.bindingComponent(c, compParm, objValueParam, 4);
    }

    public void bindingComponent(JComponent c, String compParm, String objValueParam, int rw) {
        if (c == null || compParm == null || compParm.length() == 0 || objValueParam == null || objValueParam.length() == 0) {
            throw new IllegalArgumentException("has some argument error in Method bindingComponent().");
        }
        String compAndAttrKey = c.hashCode() + compParm;
        SettingValue settingValue = new SettingValue();
        settingValue.setComp(c);
        settingValue.setCompParm(compParm);
        settingValue.setObjValue(null);
        settingValue.setObjValueParm(objValueParam);
        settingValue.setRw(rw);
        HashMap<String, SettingValue> settingValueHashMap = (HashMap<String, SettingValue>)this.getBindObjSet().get(this.currentObjValueKey);
        if (settingValueHashMap == null) {
            settingValueHashMap = new HashMap<String, SettingValue>();
            this.getBindObjSet().put(this.currentObjValueKey, settingValueHashMap);
        }
        settingValueHashMap.put(compAndAttrKey, settingValue);
    }

    public void refreshLoad(IObjectValue valueObj) {
        this.refreshLoad(DEFAULT_OBJECTVALUE, valueObj);
    }

    public void refreshLoad(String key, IObjectValue valueObj) {
        HashMap hashMap;
        if (key == null || valueObj == null) {
            return;
        }
        if (this.getValueObjectSet().contains(key) && (hashMap = (HashMap)this.getBindObjSet().get(key)) != null && hashMap.size() > 0) {
            for (Object obj : hashMap.values()) {
                if (obj == null || !(obj instanceof SettingValue)) continue;
                SettingValue settingValue = (SettingValue)obj;
                settingValue.setObjValue(valueObj);
                settingValue.load();
            }
        }
    }

    public void refreshStore(IObjectValue valueObj) {
        this.refreshStore(DEFAULT_OBJECTVALUE, valueObj);
    }

    public void refreshStore(String key, IObjectValue valueObj) {
        HashMap hashMap;
        if (key == null || valueObj == null) {
            return;
        }
        if (this.getValueObjectSet().contains(key) && (hashMap = (HashMap)this.getBindObjSet().get(key)) != null && hashMap.size() > 0) {
            for (Object obj : hashMap.values()) {
                if (obj == null || !(obj instanceof SettingValue)) continue;
                SettingValue settingValue = (SettingValue)obj;
                settingValue.setObjValue(valueObj);
                settingValue.store();
            }
        }
    }

    public void unBindingAll() {
        HashMap tempHash = (HashMap)this.getBindObjSet().get(this.currentObjValueKey);
        if (tempHash != null && tempHash.size() > 0) {
            tempHash.clear();
        }
    }

    public void unBinding(JComponent c) {
        this.unBinding(c, UICommonUtils.getCompAttrName(c));
    }

    public void unBinding(JComponent c, String compParm) {
        if (c == null || compParm == null || compParm.length() == 0) {
            return;
        }
        HashMap tempHash = (HashMap)this.getBindObjSet().get(this.currentObjValueKey);
        if (tempHash != null && tempHash.size() > 0) {
            tempHash.remove(c.hashCode() + compParm);
        }
    }

    public void setMode(int mode) {
    }

    public int getMode() {
        return 0;
    }

    private ArrayList getValueObjectSet() {
        if (this.valueObjectSet == null) {
            this.valueObjectSet = new ArrayList();
        }
        return this.valueObjectSet;
    }

    private Hashtable getBindObjSet() {
        if (this.bindObjSet == null) {
            this.bindObjSet = new Hashtable();
        }
        return this.bindObjSet;
    }

    static class SettingValue {
        private IObjectValue objValue = null;
        private String objValueParm = null;
        private JComponent comp = null;
        private String compParm = null;
        private int rw = -1;

        public SettingValue() {
        }

        public SettingValue(IObjectValue objVal, String objValParm, JComponent comp, String compParm, int rw) {
            this.setObjValue(objVal);
            this.setObjValueParm(objValParm);
            this.setComp(comp);
            this.setRw(rw);
        }

        public void store() {
            try {
                if (!this.isNull() && this.isStore()) {
                    Method compGetMethod = this.comp.getClass().getMethod(this.getGetMethodName(this.compParm), null);
                    Object compValue = compGetMethod.invoke((Object)this.comp, null);
                    Method method = UICommonUtils.getObjValSetMethod(this.objValue, this.objValueParm);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void load() {
            if (this.isNull() || this.isLoad()) {
                // empty if block
            }
        }

        private String getGetMethodName(String m) {
            return UICommonUtils.getGetMethodName(m);
        }

        private boolean isNull() {
            return this.comp == null || this.compParm == null || this.objValue == null || this.objValueParm == null;
        }

        private boolean isStore() {
            return this.rw == 4 || this.rw == 3;
        }

        private boolean isLoad() {
            return this.rw == 4 || this.rw == 2;
        }

        public JComponent getComp() {
            return this.comp;
        }

        public String getCompParm() {
            return this.compParm;
        }

        public IObjectValue getObjValue() {
            return this.objValue;
        }

        public String getObjValueParm() {
            return this.objValueParm;
        }

        public int getRw() {
            return this.rw;
        }

        public void setComp(JComponent component) {
            this.comp = component;
        }

        public void setCompParm(String string) {
            this.compParm = string;
        }

        public void setObjValue(IObjectValue value) {
            if (value == this.objValue) {
                return;
            }
            this.objValue = value;
        }

        public void setObjValueParm(String string) {
            this.objValueParm = string;
        }

        public void setRw(int i) {
            this.rw = i;
        }
    }
}

