/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.face;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.client.servicebinding.ConsiderTimeUtil;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.framework.cache.InvokeStackCache;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericException;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ItemAction
extends AbstractAction
implements IItemAction {
    private static Logger logger = Logger.getLogger(ItemAction.class);
    public static final int BUTTON_ITEM = 0;
    public static final int MENUITEM_ITEM = 1;
    protected IUIObject uiObj = null;
    private static final String DAEMONRUN = "DaemonRun";
    protected String itemLogicKey = null;
    private int itemKind = -1;
    private boolean bindWorkFlow = false;
    private Map services;
    private boolean isDaemonDialog = true;
    private ActionEvent event = null;
    private boolean isBatchAction;
    private boolean invokeFailed = false;
    private String actionName = null;

    public ItemAction() {
    }

    public ItemAction(IUIObject uiObj) {
        this.uiObj = uiObj;
        super.putValue("ActionCommandKey", this.getClass().getName());
    }

    public ItemAction(String name) {
        super(name);
    }

    public ItemAction(String name, Icon icon) {
        super(name, icon);
    }

    public ItemAction(IUIObject uiObj, String logicKey) {
        this.uiObj = uiObj;
        this.itemLogicKey = logicKey;
    }

    @Override
    public void setVisible(boolean newValue) {
        this.putValue("visible", newValue);
    }

    @Override
    public boolean isVisible() {
        Object value = this.getValue("visible");
        if (value == null) {
            return true;
        }
        return (Boolean)value;
    }

    @Override
    public boolean isDaemonRun() {
        Object value = this.getValue(DAEMONRUN);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    @Override
    public void setDaemonRun(boolean isDaemonRun) {
        this.put(DAEMONRUN, isDaemonRun);
    }

    @Override
    public boolean isDaemonDialog() {
        return this.isDaemonDialog && this.isDaemonRun();
    }

    @Override
    public void setDaemonDialog(boolean isDaemonDialog) {
        this.isDaemonDialog = isDaemonDialog;
    }

    @Override
    public void setActionEvent(ActionEvent e) {
        this.event = e;
    }

    @Override
    public ActionEvent getActionEvent() {
        return this.event;
    }

    @Override
    public int getItemKind() {
        return this.itemKind;
    }

    @Override
    public void setItemKind(int i) {
        switch (i) {
            case 0: 
            case 1: {
                this.itemKind = i;
                break;
            }
            default: {
                this.itemKind = -1;
            }
        }
    }

    @Override
    public void setUIObject(IUIObject uiObj) {
        this.uiObj = uiObj;
    }

    @Override
    public IUIObject getUIObject() {
        return this.uiObj;
    }

    @Override
    public void setItemLogicKey(String logicKey) {
        this.itemLogicKey = logicKey;
    }

    @Override
    public String getItemLogicKey() {
        return this.itemLogicKey;
    }

    private void put(String key, Object newObj) {
        if (!this.isLegalKey(key)) {
            throw new IllegalArgumentException("key [" + key + "] is illgale.");
        }
        super.putValue(key, newObj);
    }

    @Override
    public String getExtendProperty(String key) {
        Object value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    @Override
    public void setExtendProperty(String key, String value) {
        this.put(key, value);
    }

    protected boolean isLegalKey(String key) {
        if (key == null) {
            return false;
        }
        if (key.equals("AcceleratorKey")) {
            return false;
        }
        if (key.equals("ActionCommandKey")) {
            return false;
        }
        return !key.equals("MnemonicKey");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.warn((Object)"You should implement the method : ItemAction.actionPerformed(ActionEvent e)");
    }

    protected ServiceContext createServiceContext(MetaDataPK methodPK, Object[] params) {
        return new ServiceContext(MetaDataTypeList.UIOBJECT, this.uiObj.getMetaDataPK(), (IMetaDataPK)methodPK, params);
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    @Override
    public void setBindWorkFlow(boolean bindWorkFlow) {
        this.bindWorkFlow = bindWorkFlow;
    }

    @Override
    public boolean isBindWorkFlow() {
        return this.bindWorkFlow;
    }

    public boolean beforeActionPerformed(CoreUIObject uiObj, String actionName, ActionEvent event) {
        Boolean bool = (Boolean)this.callBackPerformed(uiObj, StringUtils.headCharLowerCase((String)actionName) + "_beforeActionPerformed", event);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public void afterActionPerformed(CoreUIObject uiObj, String actionName, ActionEvent event) {
        this.callBackPerformed(uiObj, StringUtils.headCharLowerCase((String)actionName) + "_afterActionPerformed", event);
    }

    public void finallyActionPerformed(CoreUIObject uiObj, String actionName, ActionEvent event) {
        this.callBackPerformed(uiObj, StringUtils.headCharLowerCase((String)actionName) + "_finallyActionPerformed", event);
    }

    private Object callBackPerformed(CoreUIObject uiObj, String actionName, ActionEvent event) {
        Method method = null;
        Object result = null;
        try {
            method = uiObj.getClass().getMethod(actionName, ActionEvent.class);
        }
        catch (NoSuchMethodException nsmex) {
            return Boolean.TRUE;
        }
        catch (Exception se) {
            return Boolean.FALSE;
        }
        if (method == null) {
            return Boolean.TRUE;
        }
        try {
            result = method.invoke((Object)uiObj, event);
        }
        catch (InvocationTargetException ite) {
            uiObj.handUIException(ite.getCause());
        }
        catch (IllegalAccessException iae) {
            if (iae.getCause() != null) {
                uiObj.handUIException(iae.getCause());
            } else {
                uiObj.handUIException(iae);
            }
        }
        catch (Throwable te) {
            uiObj.handUIException(te);
        }
        return result;
    }

    @Override
    public void innerActionPerformed(String contextName, CoreUIObject uiObj, String actionClassName, String actionMethodName, ActionEvent event) {
        this.reflectPerformAction(contextName, uiObj, actionClassName, actionMethodName, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reflectPerformAction(String contextName, CoreUIObject uiObj, String actionClassName, String actionMethodName, ActionEvent event) {
        Method method = null;
        LowTimer lowTimer = new LowTimer();
        try {
            method = uiObj.getClass().getMethod(actionMethodName, ActionEvent.class);
        }
        catch (NoSuchMethodException nsmex) {
            uiObj.handUIException(nsmex);
        }
        catch (SecurityException se) {
            uiObj.handUIException(se);
        }
        if (method == null) {
            return;
        }
        InvokeStackCache localCache = InvokeStackCache.getInstance();
        localCache.enter();
        uiObj.beforeActionPerformed(event);
        try {
            Context ctx = new Context(contextName);
            ServiceContext svcCtx = this.createServiceContext(MetaDataPK.create((String)actionClassName), new Object[]{ctx});
            this.invokeServiceBefore(svcCtx);
            method.invoke((Object)uiObj, event);
            this.invokeServiceAfter(svcCtx);
            this.invokeFailed = false;
        }
        catch (InvocationTargetException ite) {
            this.invokeFailed = true;
            if (ite.getCause() == null) {
                uiObj.handUIException(ite);
                return;
            }
            if (ite.getCause() instanceof NumericException) {
                NumericException ne = (NumericException)ite.getCause();
                uiObj.handUIException((Throwable)ne);
                ne.afterShowException(uiObj.getUIContext());
                return;
            }
            uiObj.handUIException(ite.getCause());
        }
        catch (IllegalAccessException iae) {
            this.invokeFailed = true;
            if (iae.getCause() != null) {
                uiObj.handUIException(iae.getCause());
            } else {
                uiObj.handUIException(iae);
            }
        }
        catch (ServiceExecutionException see) {
            this.invokeFailed = true;
            uiObj.handUIException(see);
        }
        catch (BOSException bose) {
            this.invokeFailed = true;
            uiObj.handUIException(bose);
        }
        catch (Throwable te) {
            this.invokeFailed = true;
            uiObj.handUIException(te);
        }
        finally {
            uiObj.afterActionPerformed(event);
            String actionName = this.getClass().getName();
            actionName = actionName.substring(actionName.indexOf("$"));
            String className = UICommonUtils.getClassName(uiObj);
            UICommonUtils.sendActionFinishedOperation(className + actionName, lowTimer.msValue() - ConsiderTimeUtil.getConsiderTime(uiObj.getClass().getName() + actionName));
            localCache.exit();
        }
    }

    public boolean isInvokeFailed() {
        return this.invokeFailed;
    }

    @Override
    public void addService(IBindService service) {
        if (this.services == null) {
            this.services = new HashMap();
        }
        this.services.put(service.getClass().getName(), service);
    }

    @Override
    public Map getServices() {
        return this.services;
    }

    @Override
    public void removeServices(IBindService service) {
        if (this.services != null) {
            this.services.remove(service.getClass().getName());
        }
    }

    @Override
    public void clearServices() {
        if (this.services != null) {
            this.services.clear();
        }
    }

    @Override
    public ItemAction getItemAction() {
        return this;
    }

    @Override
    public void setBatchAction(boolean isBatchAction) {
        this.isBatchAction = isBatchAction;
    }

    @Override
    public boolean isBatchAction() {
        return this.isBatchAction;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }
}

