/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.face;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.UICommonUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class UIDialog
extends KDDialog
implements IUIWindow {
    private IUIObject uiObject = null;
    private KDPanel selfContentPane = null;
    private KDMenuBar mBar = null;
    private KDToolBar tBar = null;
    private KDStatusBar sBar = null;
    private String title = "";
    private KDToolBar[] multiBar = null;

    private void setCommonUIElements(IUIObject uiObject) {
        this.mBar = uiObject.getUIMenuBar();
        this.tBar = uiObject.getUIToolBar();
        this.sBar = uiObject.getStatusBar();
        this.multiBar = uiObject.getUIMultiToolBar();
        this.title = uiObject.getUITitle();
    }

    private void refreshWindow() {
        this.setUIMenuBar(this.mBar);
        this.setMultiToolBar(this.multiBar);
        this.setStatusBar(this.sBar);
        this.setTitle(this.title);
    }

    public UIDialog(IUIObject uiObject) {
        this(uiObject, (Frame)null, false);
    }

    public UIDialog(IUIObject uiObject, Frame owner) {
        this(uiObject, owner, false);
    }

    public UIDialog(IUIObject uiObject, Frame owner, boolean modal) {
        this(uiObject, owner, null, modal);
    }

    public UIDialog(IUIObject uiObject, Frame owner, String title) {
        this(uiObject, owner, title, false);
    }

    public UIDialog(IUIObject uiObject, Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.uiObject = uiObject;
        this.setCommonUIElements(uiObject);
        this.initialize();
    }

    public UIDialog(IUIObject uiObject, Dialog owner) {
        this(uiObject, owner, false);
    }

    public UIDialog(IUIObject uiObject, Dialog owner, boolean modal) {
        this(uiObject, owner, null, modal);
    }

    public UIDialog(IUIObject uiObject, Dialog owner, String title) {
        this(uiObject, owner, title, false);
    }

    public UIDialog(IUIObject uiObject, Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.uiObject = uiObject;
        this.setCommonUIElements(uiObject);
        this.initialize();
    }

    private void initialize() {
        this.setUIObject(this.uiObject);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UIDialog.this.destoryWindow();
            }
        });
    }

    private void configWindow() {
        if (this.uiObject == null) {
            return;
        }
        this.getSelfContentPane().removeAll();
        this.refreshWindow();
        if (this.uiObject.getUIContentPane() != null) {
            this.getSelfContentPane().add((Component)this.uiObject.getUIContentPane(), (Object)"Center");
        }
        this.setContentPane((Container)this.getSelfContentPane());
    }

    public boolean destoryWindow() {
        if (this.uiObject != null) {
            return this.uiObject.destroyWindow();
        }
        this.dispose();
        return true;
    }

    public IObjectValue getDefaultObjectValue() {
        if (this.uiObject != null) {
            return this.uiObject.getDataObject();
        }
        return null;
    }

    public void setDataObject(IObjectValue objectValue) {
        if (this.uiObject != null) {
            this.uiObject.setDataObject(objectValue);
        }
    }

    public IObjectValue getDataObject(String key) {
        if (this.uiObject != null) {
            return this.uiObject.getDataObject(key);
        }
        return null;
    }

    public void setDataObject(String key, IObjectValue objectValue) {
        if (this.uiObject != null) {
            this.uiObject.setDataObject(key, objectValue);
        }
    }

    public Container getUIContentPane() {
        if (this.uiObject != null) {
            return this.uiObject.getUIContentPane();
        }
        return null;
    }

    public KDMenuBar getUIMenuBar() {
        return this.mBar;
    }

    public void setUIMenuBar(KDMenuBar menuBar) {
        this.setJMenuBar((JMenuBar)menuBar);
    }

    public KDToolBar getUIToolBar() {
        return this.tBar;
    }

    public void setUIToolBar(KDToolBar toolBar) {
        this.removeAllToolBar();
        this.tBar = toolBar;
        if (toolBar == null) {
            return;
        }
        this.addToolBar((JToolBar)toolBar);
        toolBar.repaint();
    }

    public KDToolBar[] getMultiToolBar() {
        return (KDToolBar[])this.getToolBars();
    }

    public void setMultiToolBar(KDToolBar[] toolBar) {
        if (toolBar == null) {
            return;
        }
        for (int i = 0; i < toolBar.length; ++i) {
            if (toolBar[i] == null) continue;
            this.addToolBar((JToolBar)toolBar[i]);
            toolBar[i].repaint();
        }
    }

    public KDStatusBar getStatusBar() {
        return this.sBar;
    }

    public void setStatusBar(KDStatusBar statusBar) {
        if (statusBar == null) {
            return;
        }
        if (super.getStatusBar() == null) {
            this.sBar = statusBar;
            super.setStatusBar(this.sBar);
        } else if (!this.sBar.equals(statusBar)) {
            this.removeAllStatusBar();
            this.sBar = statusBar;
            super.setStatusBar(this.sBar);
        }
        this.sBar.repaint();
    }

    public void storeFields() {
        if (this.uiObject != null) {
            this.uiObject.storeFields();
        }
    }

    public void loadFields() {
        if (this.uiObject != null) {
            this.uiObject.loadFields();
        }
    }

    public void handUIException(Throwable throwable) {
        UICommonUtils.handleException(throwable, (Component)((Object)this));
    }

    public String getOprtState() {
        if (this.uiObject != null) {
            return this.uiObject.getOprtState();
        }
        return null;
    }

    public void setOprtState(String oprtType) {
        if (this.uiObject != null) {
            this.uiObject.setOprtState(oprtType);
        }
    }

    @Override
    public IUIObject getUIObject() {
        return this.uiObject;
    }

    @Override
    public void setUIObject(IUIObject uiObject) {
        if (uiObject == null) {
            return;
        }
        this.uiObject = uiObject;
        this.uiObject.setUIWindow(this);
        if (uiObject instanceof JPanel) {
            Dimension di = ((JPanel)((Object)uiObject)).getSize();
            UICommonUtils.configWindowSize((Window)((Object)this), di);
        }
        this.configWindow();
    }

    protected KDPanel getSelfContentPane() {
        if (this.selfContentPane == null) {
            this.selfContentPane = new KDPanel();
            this.selfContentPane.setLayout((LayoutManager)new BorderLayout());
        }
        return this.selfContentPane;
    }

    @Override
    public boolean close() {
        return this.destoryWindow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object obj = evt.getNewValue();
        if (obj == null) {
            return;
        }
        if (name.indexOf("ui") != 0) {
            return;
        }
        if (name.equals("uiTitle")) {
            this.setTitle((String)evt.getNewValue());
        } else if (name.equals("uiMenuBar")) {
            if (obj instanceof KDMenuBar) {
                this.setUIMenuBar((KDMenuBar)obj);
            }
        } else if (name.equals("uiToolBar")) {
            if (obj instanceof KDToolBar) {
                this.setUIToolBar((KDToolBar)obj);
            }
        } else if (name.equals("uiStatusBar") && obj instanceof KDStatusBar) {
            this.setStatusBar((KDStatusBar)obj);
        }
    }
}

