/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.face;

import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public class UIFactory {
    protected static IUIFactory defaultFactory = null;
    protected static final Hashtable factoryList = new Hashtable();

    protected UIFactory() {
    }

    public static IUIFactory createUIFactory() throws UIException {
        if (defaultFactory == null) {
            String typeName = null;
            ConfigurationItem configItem = Configuration.getInstance().getConfigItemByPath("UIFactory");
            if (configItem != null && (defaultFactory = UIFactory.createUIFactory(typeName = configItem.getProperty("name"))) != null) {
                factoryList.put(typeName, defaultFactory);
            }
        }
        return defaultFactory;
    }

    public static IUIFactory createUIFactory(String typeName) throws UIException {
        try {
            if (typeName == null || typeName.equals("")) {
                return null;
            }
            if (factoryList.containsKey(typeName)) {
                return (IUIFactory)factoryList.get(typeName);
            }
            Class<?> c = Class.forName(typeName);
            Method m = c.getMethod("newInstance", null);
            IUIFactory factory = (IUIFactory)m.invoke(null, null);
            if (factory != null) {
                factoryList.put(typeName, factory);
            }
            return factory;
        }
        catch (Exception e) {
            throw new UIException("Can not create ui factory!", e);
        }
    }

    public static IUIFactory createUIFactory(String typeName, Map uiContext) throws UIException {
        return UIFactory.createUIFactory(typeName);
    }
}

