/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.face;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class UIRuleUtil {
    public static void throwException(String message) throws Exception {
        throw new Exception(message);
    }

    public static Object getObject(int value) {
        return UIRuleUtil.getInt(value);
    }

    public static Object getObject(double value) {
        return UIRuleUtil.getDouble(value);
    }

    public static Object getObject(boolean value) {
        return UIRuleUtil.getBoolean(value);
    }

    public static Object getObject(Object value) {
        return value;
    }

    public static int getIntValue(Object obj) {
        if (obj instanceof String) {
            return UIRuleUtil.getIntValue((String)obj);
        }
        if (obj instanceof Integer) {
            return UIRuleUtil.getIntValue((Integer)obj);
        }
        if (obj instanceof BigDecimal) {
            return UIRuleUtil.getIntValue((BigDecimal)obj);
        }
        if (obj instanceof Double) {
            return UIRuleUtil.getIntValue((Double)obj);
        }
        if (obj instanceof Long) {
            return UIRuleUtil.getIntValue((Long)obj);
        }
        return 0;
    }

    public static int getIntValue(String obj) {
        return UIRuleUtil.getInt(obj);
    }

    public static int getIntValue(Integer obj) {
        return obj;
    }

    public static int getIntValue(BigDecimal obj) {
        return obj.intValue();
    }

    public static int getIntValue(Double obj) {
        return obj.intValue();
    }

    public static int getIntValue(Long obj) {
        return obj.intValue();
    }

    public static int getIntValue(int value) {
        return value;
    }

    public static int getIntValue(double value) {
        return (int)value;
    }

    public static boolean getBooleanValue(Object obj) {
        if (obj instanceof Boolean) {
            return UIRuleUtil.getBooleanValue((Boolean)obj);
        }
        return false;
    }

    public static boolean getBooleanValue(Boolean obj) {
        return obj;
    }

    public static Integer getInt(Object obj) {
        if (obj == null) {
            return new Integer(0);
        }
        if (obj instanceof String) {
            return UIRuleUtil.getInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof BigDecimal) {
            return UIRuleUtil.getInt((BigDecimal)obj);
        }
        if (obj instanceof Double) {
            return UIRuleUtil.getInt((Double)obj);
        }
        if (obj instanceof Long) {
            return UIRuleUtil.getInt((Long)obj);
        }
        return new Integer(0);
    }

    public static Integer getInt(String value) {
        if (value == null) {
            return new Integer(0);
        }
        return Integer.valueOf(value);
    }

    public static Integer getInt(Long value) {
        if (value == null) {
            return new Integer(0);
        }
        return new Integer(value.intValue());
    }

    public static Integer getInt(double value) {
        return new Integer(new Double(value).intValue());
    }

    public static Integer getInt(int value) {
        return new Integer(value);
    }

    public static Integer getInt(BigDecimal value) {
        if (value == null) {
            return new Integer(0);
        }
        return new Integer(value.intValue());
    }

    public static Integer getInt(Double value) {
        if (value == null) {
            return new Integer(0);
        }
        return new Integer(value.intValue());
    }

    public static Boolean getBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return null;
    }

    public static Boolean getBoolean(boolean obj) {
        return new Boolean(obj);
    }

    public static int abs(int value) {
        if (value >= 0) {
            return value;
        }
        return -1 * value;
    }

    public static double abs(double value) {
        if (value >= 0.0) {
            return value;
        }
        return -1.0 * value;
    }

    public static int abs(Integer value) {
        if (value == null) {
            return 0;
        }
        if (value >= 0) {
            return value;
        }
        return -1 * value;
    }

    public static double abs(Double value) {
        if (value == null) {
            return 0.0;
        }
        if (value >= 0.0) {
            return value;
        }
        return -1.0 * value;
    }

    public static double abs(BigDecimal value) {
        if (value == null) {
            return 0.0;
        }
        if (value.doubleValue() >= 0.0) {
            return value.doubleValue();
        }
        return -1.0 * value.doubleValue();
    }

    public static long abs(Long value) {
        if (value == null) {
            return 0L;
        }
        if (value.doubleValue() >= 0.0) {
            return value;
        }
        return -1L * value;
    }

    public static double abs(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Integer) {
            return new Double(UIRuleUtil.abs((Integer)value));
        }
        if (value instanceof Double) {
            return UIRuleUtil.abs((Double)value);
        }
        if (value instanceof BigDecimal) {
            return UIRuleUtil.abs((BigDecimal)value);
        }
        if (value instanceof Long) {
            return new Double(UIRuleUtil.abs((Long)value));
        }
        return 0.0;
    }

    public static int len(Object value) {
        return UIRuleUtil.len((String)value);
    }

    public static int len(String value) {
        return value.length();
    }

    public static String left(Object value, int length) {
        return UIRuleUtil.left((String)value, length);
    }

    public static String left(String value, int length) {
        if (length > 0 && length <= value.length()) {
            return value.substring(0, length);
        }
        if (length > 0) {
            return value;
        }
        return "";
    }

    public static String right(Object value, int length) {
        return UIRuleUtil.right((String)value, length);
    }

    public static String right(String value, int length) {
        if (length > 0 && length <= value.length()) {
            return value.substring(value.length() - length);
        }
        if (length > 0) {
            return value;
        }
        return "";
    }

    public static String upper(Object value) {
        return UIRuleUtil.upper((String)value);
    }

    public static String upper(String value) {
        return value.toUpperCase();
    }

    public static String lower(Object value) {
        return UIRuleUtil.lower((String)value);
    }

    public static String lower(String value) {
        return value.toLowerCase();
    }

    public static String trim(Object value) {
        return UIRuleUtil.trim((String)value);
    }

    public static String trim(String value) {
        return value.trim();
    }

    public static double getBigDecimalValue(Object obj) {
        if (obj instanceof String) {
            return UIRuleUtil.getBigDecimalValue((String)obj);
        }
        if (obj instanceof BigDecimal) {
            return UIRuleUtil.getBigDecimalValue((BigDecimal)obj);
        }
        if (obj instanceof Double) {
            return UIRuleUtil.getBigDecimalValue((Double)obj);
        }
        if (obj instanceof Integer) {
            return UIRuleUtil.getBigDecimalValue((Integer)obj);
        }
        return 0.0;
    }

    public static double getBigDecimalValue(String obj) {
        return UIRuleUtil.getBigDecimal(obj).doubleValue();
    }

    public static double getBigDecimalValue(Double obj) {
        return obj;
    }

    public static double getBigDecimalValue(BigDecimal obj) {
        return obj.doubleValue();
    }

    public static double getBigDecimalValue(Integer obj) {
        return UIRuleUtil.getBigDecimal(obj).doubleValue();
    }

    public static double getBigDecimalValue(int value) {
        return value;
    }

    public static double getBigDecimalValue(double value) {
        return value;
    }

    public static BigDecimal getBigDecimal(Object obj) {
        if (obj == null) {
            return new BigDecimal(0.0);
        }
        if (obj instanceof String) {
            return UIRuleUtil.getBigDecimal((String)obj);
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Double) {
            return UIRuleUtil.getBigDecimal((Double)obj);
        }
        if (obj instanceof Integer) {
            return UIRuleUtil.getBigDecimal((Integer)obj);
        }
        return new BigDecimal(0.0);
    }

    public static BigDecimal getBigDecimal(Double value) {
        if (value == null) {
            return new BigDecimal(0.0);
        }
        return new BigDecimal(value);
    }

    public static BigDecimal getBigDecimal(Integer value) {
        if (value == null) {
            return new BigDecimal(0.0);
        }
        return new BigDecimal(value.doubleValue());
    }

    public static BigDecimal getBigDecimal(String value) {
        if (value == null) {
            return new BigDecimal(0.0);
        }
        return new BigDecimal(value);
    }

    public static BigDecimal getBigDecimal(double value) {
        return new BigDecimal(value);
    }

    public static BigDecimal getBigDecimal(int value) {
        return BigDecimal.valueOf(value);
    }

    public static double getDouble(Object obj) {
        return 0.0;
    }

    public static double getDouble(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return 0.0;
        }
        try {
            double value = Double.parseDouble(text);
            return value;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static double getDoubleValue(Double obj) {
        return obj;
    }

    public static Double getDouble(double value) {
        return new Double(value);
    }

    public static String getString(int value) {
        return String.valueOf(value);
    }

    public static String getString(double value) {
        return String.valueOf(value);
    }

    public static String getString(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    private static void fillLinkProperty(IObjectValue objValue, String propertyName) throws DataAccessException, BOSException {
        IObjectValue ov;
        Object subObj = objValue.get(propertyName);
        if (subObj != null && subObj instanceof IObjectValue && !(ov = (IObjectValue)subObj).getBoolean("_loaded_")) {
            ObjectUuidPK pk = new ObjectUuidPK(ov.getBOSUuid(ov.getPKField()));
            ov = DynamicObjectFactory.getRemoteInstance().getValue(ov.getBOSType(), (IObjectPK)pk);
            ov.setBoolean("_loaded_", true);
            objValue.put(propertyName, (Object)ov);
        }
    }

    public static Object getProperty(IObjectValue objValue, String propertyName) throws DataAccessException, BOSException {
        if (objValue == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        IObjectValue tempObj = objValue;
        Object retObj = null;
        if (propertys.length == 1) {
            UIRuleUtil.fillLinkProperty(tempObj, propertyName);
        } else {
            int n = propertys.length;
            for (int i = 0; i < n - 1; ++i) {
                UIRuleUtil.fillLinkProperty(tempObj, propertys[i]);
                tempObj = (IObjectValue)tempObj.get(propertys[i]);
                if (tempObj == null) break;
            }
        }
        if (tempObj != null) {
            Class<?> type = tempObj.getClass();
            try {
                Method method = type.getMethod("get" + StringUtils.headCharUpperCase((String)propertys[propertys.length - 1]), null);
                retObj = method.invoke((Object)tempObj, null);
            }
            catch (Exception e) {
                retObj = tempObj.get(propertys[propertys.length - 1]);
            }
        }
        return retObj;
    }

    public static double min(KDTable table, String columnName) {
        double retValue = 0.0;
        IColumn column = table.getColumn(columnName);
        if (column != null) {
            int colIndex = column.getColumnIndex();
            int n = table.getRowCount();
            for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                double temp = UIRuleUtil.getBigDecimalValue(table.getCell(rowIndex, colIndex).getValue());
                if (rowIndex == 0) {
                    retValue = temp;
                    continue;
                }
                if (!(temp < retValue)) continue;
                retValue = temp;
            }
        }
        return retValue;
    }

    public static double max(KDTable table, String columnName) {
        double retValue = 0.0;
        IColumn column = table.getColumn(columnName);
        if (column != null) {
            int colIndex = column.getColumnIndex();
            int n = table.getRowCount();
            for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                double temp = UIRuleUtil.getBigDecimalValue(table.getCell(rowIndex, colIndex).getValue());
                if (rowIndex == 0) {
                    retValue = temp;
                    continue;
                }
                if (!(temp > retValue)) continue;
                retValue = temp;
            }
        }
        return retValue;
    }

    public static double avg(KDTable table, String columnName) {
        double retValue = UIRuleUtil.sum(table, columnName);
        int count = UIRuleUtil.count(table);
        if (count == 0) {
            return 0.0;
        }
        return retValue / (double)count;
    }

    public static int count(KDTable table) {
        return table.getRowCount();
    }

    public static double sum(KDTable table, String columnName) {
        double retValue = 0.0;
        IColumn column = table.getColumn(columnName);
        if (column != null) {
            int colIndex = column.getColumnIndex();
            int n = table.getRowCount();
            for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                retValue += UIRuleUtil.getBigDecimalValue(table.getCell(rowIndex, colIndex).getValue());
            }
        }
        return retValue;
    }

    public static Date date(String date) {
        Date result = null;
        try {
            result = DateTimeUtils.parseDate((String)date);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static Date now() {
        return new Date();
    }

    public static int year(Object date) {
        if (date == null) {
            return 0;
        }
        if (date instanceof String) {
            return UIRuleUtil.year((String)date);
        }
        if (date instanceof Date) {
            return UIRuleUtil.year((Date)date);
        }
        return 0;
    }

    public static int year(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int year(String date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(date));
        return calendar.get(1);
    }

    public static int month(Object date) {
        if (date == null) {
            return 0;
        }
        if (date instanceof String) {
            return UIRuleUtil.month((String)date);
        }
        if (date instanceof Date) {
            return UIRuleUtil.month((Date)date);
        }
        return 0;
    }

    public static int month(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int month(String date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(date));
        return calendar.get(2) + 1;
    }

    public static int day(Object date) {
        if (date == null) {
            return 0;
        }
        if (date instanceof String) {
            return UIRuleUtil.day((String)date);
        }
        if (date instanceof Date) {
            return UIRuleUtil.day((Date)date);
        }
        return 0;
    }

    public static int day(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int day(String date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(date));
        return calendar.get(5);
    }

    public static int hour(Object date) {
        if (date == null) {
            return 0;
        }
        if (date instanceof String) {
            return UIRuleUtil.hour((String)date);
        }
        if (date instanceof Date) {
            return UIRuleUtil.hour((Date)date);
        }
        return 0;
    }

    public static int hour(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(10);
    }

    public static int hour(String date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(date));
        return calendar.get(10);
    }

    public static int minute(Object date) {
        if (date == null) {
            return 0;
        }
        if (date instanceof String) {
            return UIRuleUtil.minute((String)date);
        }
        if (date instanceof Date) {
            return UIRuleUtil.minute((Date)date);
        }
        return 0;
    }

    public static int minute(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int minute(String date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(date));
        return calendar.get(12);
    }

    public static int second(Object date) {
        if (date == null) {
            return 0;
        }
        if (date instanceof String) {
            return UIRuleUtil.second((String)date);
        }
        if (date instanceof Date) {
            return UIRuleUtil.second((Date)date);
        }
        return 0;
    }

    public static int second(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static int second(String date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(date));
        return calendar.get(13);
    }

    public static Date dateAdd(Object date, Object offSet) {
        if (date == null) {
            return null;
        }
        if (offSet == null) {
            if (date instanceof String) {
                return new Date((String)date);
            }
            if (date instanceof Date) {
                return (Date)date;
            }
            return null;
        }
        if (date instanceof String) {
            if (offSet instanceof String) {
                return UIRuleUtil.dateAdd(new Date((String)date), new Date((String)offSet));
            }
            if (offSet instanceof Date) {
                return UIRuleUtil.dateAdd(new Date((String)date), (Date)offSet);
            }
            if (offSet instanceof Integer) {
                return UIRuleUtil.dateAdd(new Date((String)date), (int)((Integer)offSet));
            }
            if (offSet instanceof Double) {
                return UIRuleUtil.dateAdd(new Date((String)date), ((Double)offSet).intValue());
            }
            if (offSet instanceof Long) {
                return UIRuleUtil.dateAdd(new Date((String)date), ((Long)offSet).intValue());
            }
            if (offSet instanceof BigDecimal) {
                return UIRuleUtil.dateAdd(new Date((String)date), ((BigDecimal)offSet).intValue());
            }
            return new Date((String)date);
        }
        if (date instanceof Date) {
            if (offSet instanceof String) {
                return UIRuleUtil.dateAdd((Date)date, new Date((String)offSet));
            }
            if (offSet instanceof Date) {
                return UIRuleUtil.dateAdd((Date)date, (Date)offSet);
            }
            if (offSet instanceof Integer) {
                return UIRuleUtil.dateAdd((Date)date, (int)((Integer)offSet));
            }
            if (offSet instanceof Double) {
                return UIRuleUtil.dateAdd((Date)date, ((Double)offSet).intValue());
            }
            if (offSet instanceof Long) {
                return UIRuleUtil.dateAdd((Date)date, ((Long)offSet).intValue());
            }
            if (offSet instanceof BigDecimal) {
                return UIRuleUtil.dateAdd((Date)date, ((BigDecimal)offSet).intValue());
            }
            return (Date)date;
        }
        return null;
    }

    public static Date dateAdd(Date date, Date offSet) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(1, UIRuleUtil.year(offSet));
        ((Calendar)calendar).add(2, UIRuleUtil.month(offSet));
        ((Calendar)calendar).add(5, UIRuleUtil.day(offSet));
        ((Calendar)calendar).add(10, UIRuleUtil.hour(offSet));
        ((Calendar)calendar).add(12, UIRuleUtil.minute(offSet));
        ((Calendar)calendar).add(13, UIRuleUtil.second(offSet));
        return calendar.getTime();
    }

    public static Date dateAdd(Object date, int offSet) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return UIRuleUtil.dateAdd(new Date((String)date), offSet);
        }
        if (date instanceof Date) {
            return UIRuleUtil.dateAdd((Date)date, offSet);
        }
        return null;
    }

    public static Date dateDiff(Object date, int offSet) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return UIRuleUtil.dateDiff(new Date((String)date), offSet);
        }
        if (date instanceof Date) {
            return UIRuleUtil.dateDiff((Date)date, offSet);
        }
        return null;
    }

    public static Date dateAdd(Date date, int offSet) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, offSet);
        return calendar.getTime();
    }

    public static Date dateDiff(Date date, int offSet) {
        return UIRuleUtil.dateAdd(date, -1 * offSet);
    }

    public static String getNumberFormat(Object precision) {
        return UIRuleUtil.getNumberFormat(UIRuleUtil.getIntValue(precision));
    }

    public static String getNumberFormat(int precision) {
        String format = "%r{0.";
        for (int i = 0; i < precision; ++i) {
            format = format + "#";
        }
        format = format + "}f";
        return format;
    }

    public static int getLength(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return 0;
        }
        return text.length();
    }

    public static Object getValue(IObjectValue objValue, String key) {
        Object value = null;
        Class<?> type = objValue.getClass();
        try {
            Method method = type.getMethod("get" + StringUtils.headCharUpperCase((String)key), null);
            value = method.invoke((Object)objValue, null);
        }
        catch (Exception e1) {
            try {
                Method method = type.getMethod("is" + StringUtils.headCharUpperCase((String)key), null);
                value = method.invoke((Object)objValue, null);
            }
            catch (Exception e2) {
                value = objValue.get(key);
            }
        }
        return value;
    }

    public static boolean isNull(Object value) {
        if (value instanceof String) {
            return UIRuleUtil.isNull((String)value);
        }
        if (value instanceof Integer) {
            return UIRuleUtil.isNull((Integer)value);
        }
        if (value instanceof Float) {
            return UIRuleUtil.isNull((Float)value);
        }
        if (value instanceof Double) {
            return UIRuleUtil.isNull((Double)value);
        }
        if (value instanceof BigDecimal) {
            return UIRuleUtil.isNull((BigDecimal)value);
        }
        if (value instanceof Date) {
            return UIRuleUtil.isNull((Date)value);
        }
        return value == null;
    }

    public static boolean isNull(String value) {
        return StringUtils.isEmpty((String)value);
    }

    public static boolean isNull(int value) {
        return value == 0 || value == -1;
    }

    public static boolean isNull(float value) {
        return value == 0.0f;
    }

    public static boolean isNull(double value) {
        return value == 0.0;
    }

    public static boolean isNull(Integer value) {
        return value == null || value == 0;
    }

    public static boolean isNull(Float value) {
        return value == null || UIRuleUtil.isNull(value.floatValue());
    }

    public static boolean isNull(Double value) {
        return value == null || UIRuleUtil.isNull((double)value);
    }

    public static boolean isNull(BigDecimal value) {
        return value == null || UIRuleUtil.isNull(value.doubleValue());
    }

    public static boolean isNull(Date value) {
        return value == null;
    }

    public static Date getDateValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return UIRuleUtil.date((String)value);
        }
        return (Date)value;
    }

    public static boolean isNotNull(Object value) {
        if (value instanceof Integer) {
            return UIRuleUtil.isNotNull((Integer)value);
        }
        if (value instanceof Float) {
            return UIRuleUtil.isNotNull((Float)value);
        }
        if (value instanceof Double) {
            return UIRuleUtil.isNotNull((Double)value);
        }
        if (value instanceof BigDecimal) {
            return UIRuleUtil.isNotNull((BigDecimal)value);
        }
        if (value instanceof Date) {
            return UIRuleUtil.isNotNull((Date)value);
        }
        return value != null;
    }

    public static boolean isNotNull(String value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(int value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(float value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(double value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(Integer value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(Float value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(Double value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(BigDecimal value) {
        return !UIRuleUtil.isNull(value);
    }

    public static boolean isNotNull(Date value) {
        return !UIRuleUtil.isNull(value);
    }

    public static String format(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return UIRuleUtil.format((Date)value, format);
        }
        return value.toString();
    }

    public static String format(Date value, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(value);
    }

    public static Enum getEnumValue(String className, String itemName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            return null;
        }
        return EnumUtils.getEnum(clazz, (String)itemName);
    }

    public static IObjectValue getObjectValue(BOSObjectType bosType, String number) {
        try {
            return DynamicObjectFactory.getRemoteInstance().getValue(bosType, "where number = '" + number + "'");
        }
        catch (BOSException e) {
            return null;
        }
    }
}

