/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.util;

import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ResTypeConvert {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.util.ResTypeConvert");

    public static Font convertFont(String s) {
        if (s != null) {
            s = s.toLowerCase();
            String[] array = ResTypeConvert.splitString(s, ",");
            int len = array.length;
            String name = "dialog";
            int style = 1;
            int size = 12;
            for (int i = 0; i < len; ++i) {
                if (array[i].indexOf("name") != -1) {
                    name = array[i].substring(5);
                    continue;
                }
                if (array[i].indexOf("style") != -1) {
                    style = Integer.parseInt(array[i].substring(6));
                    continue;
                }
                if (array[i].indexOf("size") == -1) continue;
                size = Integer.parseInt(array[i].substring(5));
            }
            return new Font(name, style, size);
        }
        return new Font("dialog", 1, 12);
    }

    public static Icon convertIcon(String s) {
        if (s != null) {
            if ((s = s.trim()).indexOf("\\") != -1) {
                s = s.replace('\\', '/');
            }
            if (s.charAt(0) == '/') {
                s = s.substring(1);
            }
            try {
                ClassLoader cl = ResTypeConvert.class.getClass().getClassLoader();
                return new ImageIcon(cl.getResource(s));
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
                throw new IllegalArgumentException("data error : Icon -->" + s);
            }
        }
        return null;
    }

    public static Point convertPoint(String s) {
        if (s != null) {
            String[] array = ResTypeConvert.splitString(s, ",");
            String[] target = new String[4];
            int len = array.length;
            if (len >= 4) {
                System.arraycopy(array, 0, target, 0, 4);
            } else if (len >= 2) {
                System.arraycopy(array, 0, target, 0, 2);
                target[2] = "0";
                target[3] = "0";
            } else {
                return new Point(0, 0);
            }
            Rectangle rect = ResTypeConvert.convertRectangle(target, s);
            return new Point(rect.x, rect.y);
        }
        return null;
    }

    public static Integer convertInteger(String s) {
        if (s != null) {
            s = s.trim();
            try {
                return new Integer(s);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("data error : Integer --> " + s);
            }
        }
        return new Integer(0);
    }

    public static Dimension convertDimension(String s) {
        if (s != null) {
            String[] array = ResTypeConvert.splitString(s, ",");
            String[] target = new String[4];
            int len = array.length;
            if (len >= 4) {
                System.arraycopy(array, 0, target, 0, 4);
            } else if (len >= 2) {
                System.arraycopy(array, 0, target, 2, 2);
                target[0] = "0";
                target[1] = "0";
            } else {
                return new Dimension(0, 0);
            }
            Rectangle rect = ResTypeConvert.convertRectangle(target, s);
            return new Dimension(rect.width, rect.height);
        }
        return new Dimension(0, 0);
    }

    public static Rectangle convertRectangle(String s) {
        if (s != null) {
            String[] rectArray = ResTypeConvert.splitString(s, ",");
            return ResTypeConvert.convertRectangle(rectArray, "Rectangle --> " + s);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static Insets convertInsets(String s) {
        String[] array = ResTypeConvert.splitString(s, ",");
        Rectangle rect = ResTypeConvert.convertRectangle(array, "Insets --> " + s);
        return new Insets(rect.x, rect.y, rect.width, rect.height);
    }

    private static Rectangle convertRectangle(String[] rectArray, String orien) {
        if (rectArray == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int len = rectArray.length;
        int x = 0;
        int y = 0;
        int width = 1;
        int height = 2;
        if (len >= 4) {
            try {
                x = Integer.parseInt(rectArray[0]);
                y = Integer.parseInt(rectArray[1]);
                width = Integer.parseInt(rectArray[2]);
                height = Integer.parseInt(rectArray[3]);
                return new Rectangle(x, y, width, height);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("data error :  " + orien);
            }
        }
        throw new IllegalArgumentException("data error : " + orien);
    }

    public static String[] splitString(String s, String delim) {
        return StringUtils.split((String)s, (String)delim);
    }

    public static Boolean convertBoolean(String s) {
        if (s != null) {
            if ((s = s.trim()).equalsIgnoreCase("false") || s.equals("0") || s.equals("-1")) {
                return false;
            }
            if (s.equalsIgnoreCase("true") || s.equals("1")) {
                return true;
            }
            return true;
        }
        return true;
    }

    public static Float convertFloat(String s) {
        if (s != null) {
            try {
                return new Float(s);
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
                throw new IllegalArgumentException("data error : Float --> " + s);
            }
        }
        return new Float(0.0f);
    }

    public static Double convertDouble(String s) {
        if (s != null) {
            try {
                return new Double(s);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("data error : Dobule -- > " + s);
            }
        }
        return new Double(0.0);
    }

    public static Color convertColor(String s) {
        if (s != null) {
            if (s.indexOf(",") == -1 && s.indexOf("#") == -1) {
                if ((s = s.trim()).equalsIgnoreCase("red")) {
                    return Color.red;
                }
                if (s.equalsIgnoreCase("black")) {
                    return Color.black;
                }
                if (s.equalsIgnoreCase("blue")) {
                    return Color.blue;
                }
                if (s.equalsIgnoreCase("cyan")) {
                    return Color.cyan;
                }
                if (s.equalsIgnoreCase("darkGray")) {
                    return Color.darkGray;
                }
                if (s.equalsIgnoreCase("gray")) {
                    return Color.gray;
                }
                if (s.equalsIgnoreCase("green")) {
                    return Color.green;
                }
                if (s.equalsIgnoreCase("lightGray")) {
                    return Color.lightGray;
                }
                if (s.equalsIgnoreCase("magenta")) {
                    return Color.magenta;
                }
                if (s.equalsIgnoreCase("orange")) {
                    return Color.orange;
                }
                if (s.equalsIgnoreCase("pink")) {
                    return Color.pink;
                }
                if (s.equalsIgnoreCase("red")) {
                    return Color.red;
                }
                if (s.equalsIgnoreCase("white")) {
                    return Color.white;
                }
                if (s.equalsIgnoreCase("yellow")) {
                    return Color.yellow;
                }
            }
            if (s.indexOf("#") == 0 && s.length() == 7) {
                return Color.decode(s);
            }
            String[] array = ResTypeConvert.splitString(s, ",");
            int r = 0;
            int g = 0;
            int b = 0;
            int len = array.length;
            if (len >= 3) {
                try {
                    r = Integer.parseInt(array[0]);
                    g = Integer.parseInt(array[1]);
                    b = Integer.parseInt(array[2]);
                    return new Color(r, g, b);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("data error : Color --> " + s);
                }
            }
        }
        return null;
    }
}

