/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.util;

import com.kingdee.bos.BOSRuntimeEnv;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.util.ResTypeConvert;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.BOSResourceBundle;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.ResourceBundleUtil;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ResourceBundleHelper {
    private static Logger logger = Logger.getLogger(ResourceBundleHelper.class);
    private ResourceBundle resourceBundle = null;
    private String baseName;
    private Locale locale;
    private ClassLoader cl;
    private BOSObjectType bosType;
    private static Map typeMap = new HashMap();
    public static final String RESOURCE_KEYWORD_PREFIX = "$Resource{";
    public static final String RESOURCE_KEYWORD_SUFFIX = "}";

    public ResourceBundleHelper(String baseName) {
        this(baseName, null);
    }

    public ResourceBundleHelper(String baseName, Locale l) {
        this(baseName, l, null);
    }

    public ResourceBundleHelper(String baseName, Locale l, ClassLoader cl) {
        if (l == null) {
            l = LocaleUtils.getDefaultOriginLocale();
        }
        this.baseName = baseName;
        this.locale = l;
        this.cl = cl;
    }

    public ResourceBundleHelper(String baseName, Locale l, ClassLoader cl, BOSObjectType bosType) {
        this(baseName, l, cl);
        this.bosType = bosType;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            boolean reloadable = BOSRuntimeEnv.PERMISSION_AUTO_DEPLOY & BOSRuntimeEnv.IS_DEV_MODE;
            this.resourceBundle = this.cl == null ? BOSResourceBundle.getBundle((String)this.baseName, (Locale)this.locale, (boolean)reloadable) : BOSResourceBundle.getBundle((String)this.baseName, (Locale)this.locale, (ClassLoader)this.cl, (boolean)reloadable);
        }
        return this.resourceBundle;
    }

    public Font getFont(String key) {
        String fontStr = this.getString(key);
        return ResTypeConvert.convertFont(fontStr);
    }

    public String getString(String key) {
        boolean process;
        String s;
        block22: {
            s = "";
            BOSObjectType type = null;
            if (this.bosType != null) {
                type = this.bosType;
            } else {
                type = MetaDataTypeList.UIOBJECT;
                if (this.baseName != null && !this.baseName.endsWith("UI")) {
                    if (this.baseName.endsWith("Resource")) {
                        type = MetaDataTypeList.MULTILANGUAGE;
                    } else if (ResourceBundleHelper.isType(this.baseName, MetaDataTypeList.MULTILANGUAGE)) {
                        type = MetaDataTypeList.MULTILANGUAGE;
                    } else if (ResourceBundleHelper.isType(this.baseName, MetaDataTypeList.RESOURCE_TYPE)) {
                        type = MetaDataTypeList.RESOURCE_TYPE;
                    }
                }
            }
            if (ResourceListenerManager.isMultiLanguages()) {
                s = ResourceListenerManager.getString((IMetaDataPK)MetaDataPK.create((String)this.baseName), (BOSObjectType)type, (Locale)this.locale, (String)key);
                if (!StringUtils.isEmpty((String)s)) {
                    return s;
                }
                if (key.indexOf("_Row") > 0 && !StringUtils.isEmpty((String)(s = ResourceListenerManager.getString((IMetaDataPK)MetaDataPK.create((String)this.baseName), (BOSObjectType)type, (Locale)this.locale, (String)key.substring(0, key.indexOf("_Row")))))) {
                    return s;
                }
            }
            process = false;
            try {
                s = ResourceBundleUtil.getString((ResourceBundle)this.getResourceBundle(), (String)key);
                if (StringUtils.isEmpty((String)s)) break block22;
                if (s.indexOf("Not Matched") >= 0 && key.indexOf("_Row") > 0) {
                    process = true;
                    break block22;
                }
                return s;
            }
            catch (MissingResourceException e) {
                if (key.indexOf("_Row") > 0) {
                    process = true;
                }
                throw e;
            }
        }
        if (process) {
            s = "";
            String sRowNumber = key.substring(key.indexOf("_Row") + 4);
            if (sRowNumber == null) {
                return "";
            }
            int iAddRowNumber = Integer.parseInt(sRowNumber);
            int j = key.indexOf(46);
            if (iAddRowNumber > 0 && j > 0) {
                String tableName = key.substring(0, j);
                String formatXml = ResourceBundleUtil.getString((ResourceBundle)this.getResourceBundle(), (String)(tableName + ".formatXml"));
                int g = 0;
                String[] columnNames = KDTableDesignerHelper.getTableInfoFrom((String)formatXml).getColumnNameList();
                int eIndex = 0;
                String startToken = "<t:Cell>";
                String endToken = "</t:Cell>";
                for (g = 0; g < iAddRowNumber; ++g) {
                    for (int t = 0; t < columnNames.length; ++t) {
                        int sIndex;
                        String name = columnNames[t];
                        if (g != 0) {
                            name = name + "_Row" + (g + 1);
                        }
                        if ((sIndex = formatXml.indexOf("<t:Cell>", eIndex)) == -1 || (eIndex = formatXml.indexOf("</t:Cell>", sIndex)) == -1) break;
                        String lValue = formatXml.substring(sIndex + "<t:Cell>".length(), eIndex);
                        if ((tableName + "." + name).equals(key)) {
                            s = lValue;
                            break;
                        }
                        eIndex += "</t:Cell>".length();
                    }
                    if (StringUtils.isEmpty((String)s)) continue;
                    return s;
                }
            }
        }
        return "";
    }

    private static boolean isType(String baseName, BOSObjectType type) {
        String mdPath;
        String key = baseName + "_" + type;
        Boolean b = (Boolean)typeMap.get(key);
        if (b != null) {
            return b;
        }
        if (!ConfigMDUtil.isClient() && StringUtils.isEmpty((String)(mdPath = Utils.getMetadataSrc((Context)ConfigMDUtil.getContext())))) {
            logger.debug((Object)"Can NOT find metadata path!");
            typeMap.put(key, Boolean.FALSE);
            return false;
        }
        try {
            IMetaDataPK[] pks = MDContextFactory.getRemoteInstance().pkIndexs.getMetaDataPKs(type);
            if (pks != null && pks.length > 0 && baseName != null) {
                for (int i = 0; i < pks.length; ++i) {
                    if (!baseName.equals(pks[i].getFullName())) continue;
                    typeMap.put(key, Boolean.TRUE);
                    return true;
                }
            }
        }
        catch (Throwable t) {
            logger.warn((Object)t, t);
        }
        typeMap.put(key, Boolean.FALSE);
        return false;
    }

    public String translateString(String prefixKey, String orgString) {
        if (StringUtils.isEmpty((String)orgString)) {
            return orgString;
        }
        if (StringUtils.isEmpty((String)prefixKey)) {
            prefixKey = "";
        } else if (!prefixKey.endsWith("\\.")) {
            prefixKey = prefixKey + ".";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(orgString);
        int index = sb.indexOf(RESOURCE_KEYWORD_PREFIX);
        while (index != -1) {
            int eIndex = sb.indexOf(RESOURCE_KEYWORD_SUFFIX, index);
            if (eIndex == -1) {
                return sb.toString();
            }
            String key = sb.substring(index + RESOURCE_KEYWORD_PREFIX.length(), eIndex);
            String value = null;
            try {
                value = this.getString(prefixKey + key);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (value == null) {
                value = key;
            }
            sb.replace(index, eIndex + 1, value);
            index = sb.indexOf(RESOURCE_KEYWORD_PREFIX, index + value.length());
        }
        return sb.toString();
    }

    public Point getPoint(String key) {
        String pStr = this.getString(key);
        return ResTypeConvert.convertPoint(pStr);
    }

    public Dimension getSize(String key) {
        String dimStr = this.getString(key);
        return ResTypeConvert.convertDimension(dimStr);
    }

    public Icon getIcon(String key) {
        String iconStr = this.getString(key);
        return ResTypeConvert.convertIcon(iconStr);
    }

    public Rectangle getRectangle(String key) {
        String rectStr = this.getString(key);
        return ResTypeConvert.convertRectangle(rectStr);
    }

    public Insets getInsets(String key) {
        String insetsStr = this.getString(key);
        return ResTypeConvert.convertInsets(insetsStr);
    }

    public boolean getBoolean(String key) {
        String bStr = this.getString(key);
        Boolean bn = ResTypeConvert.convertBoolean(bStr);
        return bn != null ? bn : true;
    }

    public int getInt(String key) {
        Integer ig = ResTypeConvert.convertInteger(this.getString(key));
        return ig != null ? ig : 0;
    }

    public float getFloat(String key) {
        Float fl = ResTypeConvert.convertFloat(this.getString(key));
        return fl != null ? fl.floatValue() : 0.0f;
    }

    public double getDouble(String key) {
        Double db = ResTypeConvert.convertDouble(this.getString(key));
        return db != null ? db : 0.0;
    }

    public Color getColor(String key) {
        Color cl = ResTypeConvert.convertColor(this.getString(key));
        return cl != null ? cl : null;
    }

    public float getSwingConstants(String key) {
        String scStr = this.getString(key);
        if (scStr != null) {
            if (scStr.equalsIgnoreCase("left")) {
                return 0.0f;
            }
            if (scStr.equalsIgnoreCase("right")) {
                return 1.0f;
            }
            if (scStr.equalsIgnoreCase("center")) {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public Object[] getArray(String key) {
        String arStr = this.getString(key);
        return ResTypeConvert.splitString(arStr, ";");
    }

    public Dimension getDimension(String key) {
        String diStr = this.getString(key);
        return ResTypeConvert.convertDimension(diStr);
    }
}

