/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.util;

import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UICommonUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.util.UICommonUtils");
    public static final int intUserLogInOutOperation = 1;
    public static final int intUserWindowsOperation = 2;
    public static final int intUserActionOperation = 3;
    public static final String strKingdeePrefixName = "com.kingdee.";
    public static final String strStaticsUtilName = "com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil";
    public static List<String> depUIList = new ArrayList<String>();

    public static Window getWindow(Component c) {
        if (c == null) {
            return null;
        }
        return SwingUtilities.getWindowAncestor(c);
    }

    public static JInternalFrame getInternalFrame(Component c) {
        if (c == null || c.getParent() == null) {
            return null;
        }
        for (Container cn = c.getParent(); cn != null; cn = cn.getParent()) {
            if (!(cn instanceof JInternalFrame)) continue;
            return (JInternalFrame)cn;
        }
        return null;
    }

    public static Object getExceptionInfo(Throwable throwable) {
        return throwable.getMessage();
    }

    public static void handleException(Throwable throwable, Component c) {
        KDOptionPane.showMessageDialog((Component)c, (Object)UICommonUtils.getExceptionInfo(throwable), null, (int)0);
    }

    public static void centerWindow(Window window) {
        if (window == null) {
            return;
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowDim = window.getSize();
        window.setLocation((screenDim.width - windowDim.width) / 2, (screenDim.height - windowDim.height) / 2);
    }

    public static void configWindowSize(Window win) {
        if (win == null) {
            return;
        }
        win.setSize(new Dimension(800, 600));
    }

    public static void configWindowSize(Window win, Dimension di) {
        if (win == null) {
            return;
        }
        if (di != null && (di.width < 10 || di.height < 10)) {
            di = new Dimension(800, 600);
        }
        if (di == null) {
            di = new Dimension(800, 600);
        }
        win.setSize(di);
    }

    public static void configWindowIcon(Window win) {
        if (win == null) {
            return;
        }
    }

    public static void configWindowIcon(Window win, String iconPath) {
        if (win == null) {
            return;
        }
    }

    public static void configWindow(Window win) {
        if (win == null) {
            return;
        }
        UICommonUtils.configWindowSize(win);
        UICommonUtils.configWindowIcon(win);
        UICommonUtils.centerWindow(win);
    }

    public static void centerInternalFrame(JInternalFrame interFrame) {
    }

    public static String validateFilePath(String path) {
        if (path == null) {
            return null;
        }
        return path;
    }

    public static String getGetMethodName(String compParam) {
        if (compParam == null || compParam.length() == 0) {
            return null;
        }
        compParam = compParam.trim();
        StringBuffer sb = new StringBuffer();
        sb.append("get").append(compParam.substring(0, 1).toUpperCase()).append(compParam.substring(1));
        return sb.toString();
    }

    public static String getSetMethodName(String compParam) {
        if (compParam == null || compParam.length() == 0) {
            return null;
        }
        compParam = compParam.trim();
        StringBuffer sb = new StringBuffer();
        sb.append("set").append(compParam.substring(0, 1).toUpperCase()).append(compParam.substring(1));
        return sb.toString();
    }

    public static String getCompAttrName(JComponent c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JTextField) {
            return "text";
        }
        if (c instanceof JComboBox) {
            return "selectedItem";
        }
        if (c instanceof JTextArea) {
            return "text";
        }
        return null;
    }

    public static String[] splitStringToArray(String ori, String delim) {
        if (ori != null) {
            ori = ori.trim();
            StringTokenizer strToken = null;
            strToken = delim != null ? new StringTokenizer(ori, delim) : new StringTokenizer(ori);
            int count = strToken.countTokens();
            String[] strArray = new String[count];
            int i = 0;
            while (strToken.hasMoreTokens()) {
                strArray[i] = strToken.nextToken().trim();
                ++i;
            }
            return strArray;
        }
        return new String[0];
    }

    public static Method getObjValSetMethod(Object obj, String objParam) {
        String[] paramArray;
        if (obj != null && objParam != null && objParam.length() > 0 && (paramArray = UICommonUtils.splitStringToArray(objParam, ".")) != null && paramArray.length > 0) {
            try {
                int len = paramArray.length;
                Object o = obj;
                Class<?> c = o.getClass();
                for (int i = 0; i < len; ++i) {
                    if (i < len - 1) {
                        Method mMethod = c.getMethod(UICommonUtils.getGetMethodName(paramArray[i]), null);
                        o = mMethod.invoke(o, null);
                        c = o.getClass();
                        continue;
                    }
                    if (i != len - 1) continue;
                    Method[] methodArray = c.getMethods();
                    return UICommonUtils.getMethod(methodArray, UICommonUtils.getSetMethodName(paramArray[i]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getMethod(Method[] methodArray, String methodName) {
        if (methodArray != null && methodArray.length > 0 && methodName != null) {
            int len = methodArray.length;
            for (int i = 0; i < len; ++i) {
                if (!methodArray[i].getName().equals(methodName)) continue;
                return methodArray[i];
            }
        }
        return null;
    }

    public static void sendWindowsCloseOperation(String uiClassFullName) {
        String name = null;
        name = UICommonUtils.removePrefixName(uiClassFullName);
        name = name + "/0";
        System.out.println(name);
        logger.info((Object)("@eas_framework, this is windowClosed name and time: " + name));
        UICommonUtils.sendMessageByReflect(2, name);
    }

    public static void sendWindowsCloseOperation(String uiClassFullName, long openMilliSecond, long closeMilliSecond) {
        String name = null;
        name = UICommonUtils.removePrefixName(uiClassFullName);
        name = name + "/" + String.valueOf(openMilliSecond);
        name = name + "/" + String.valueOf(closeMilliSecond);
        System.out.println(name);
        logger.info((Object)("@eas_framework, this is windowClosed name and time: " + name));
        UICommonUtils.sendMessageByReflect(2, name);
    }

    public static void sendActionFinishedOperation(String actionFullName, long millisecond) {
        String name = null;
        name = UICommonUtils.removePrefixName(actionFullName);
        name = name + "/" + String.valueOf(millisecond);
        System.out.println(name);
        logger.info((Object)("@eas_framework, this is actionFinished name and time: " + name));
        UICommonUtils.sendMessageByReflect(3, name);
    }

    public static final String removePrefixName(String fullName) {
        String name = null;
        if (fullName != null && fullName.length() > 12) {
            name = fullName.replaceFirst(strKingdeePrefixName, "");
            name = name.replaceFirst("\\$", "_");
        }
        return name;
    }

    public static final void sendMessageByReflect(int level, String message) {
        try {
            Class<?> userOperationClass = Class.forName(strStaticsUtilName);
            Method actionMethod = userOperationClass.getMethod("send", Integer.TYPE, String.class);
            actionMethod.invoke(userOperationClass, new Integer(level), message);
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)(e.getMessage() + "\n classname is :" + strStaticsUtilName + " by eas_framework"));
            e.printStackTrace();
        }
        catch (SecurityException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)(e.getMessage() + "\n method name is : send  by eas_framework"));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static String getClassName(CoreUIObject uiObj) {
        String name = uiObj.getClass().getName();
        if (name != null && depUIList.contains(name)) {
            if (uiObj.getMetaDataPK() == null) {
                return name;
            }
            return uiObj.getMetaDataPK().getFullName();
        }
        return name;
    }

    static {
        String sql = "SELECT \"CUSTOMTEMPLATE\".FListUI AS \"LISTUI\", \"CUSTOMTEMPLATE\".FEditUI AS \"EDITUI\" FROM T_EP_CustomTemplate AS \"CUSTOMTEMPLATE\"";
        SQLExecutor se = new SQLExecutor(sql);
        try {
            IRowSet rows = se.executeSQL();
            while (rows.next()) {
                String listui = rows.getString("LISTUI");
                String editui = rows.getString("EDITUI");
                if (listui != null && !listui.equals("")) {
                    depUIList.add(listui);
                }
                if (editui == null || editui.equals("")) continue;
                depUIList.add(editui);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"init depUIList fail");
        }
    }
}

