/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.util;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.util.LocaleUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class UIHelper {
    private UIHelper() {
    }

    public static DataObjectCollection getBindedObject(UIObjectInfo ui) {
        return ui.getDataObjects();
    }

    public static SelectorItemCollection getSelector(UIObjectInfo ui, String objectName) {
        ComponentCollection componentCollection = ui.getComponents();
        Vector propertyVector = UIHelper.findBindedProperty(objectName, componentCollection);
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < propertyVector.size(); ++i) {
            String name = (String)propertyVector.get(i);
            SelectorItemInfo ii = new SelectorItemInfo();
            ii.setPropertyName(name);
            sic.add(ii);
        }
        return sic;
    }

    private static Vector findBindedProperty(String objectName, ComponentCollection componentCollection) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < componentCollection.size(); ++i) {
            Vector subResult;
            ComponentInfo ci = componentCollection.get(i);
            PropertyBindingCollection pbc = ci.getPropertyBindings();
            for (int j = 0; j < pbc.size(); ++j) {
                PropertyBindingInfo propertyBindingInfo = pbc.get(j);
                if (!propertyBindingInfo.getBindingObject().equals(objectName)) continue;
                result.add(propertyBindingInfo.getBingdingField());
            }
            if (!ci.isContainer() || (subResult = UIHelper.findBindedProperty(objectName, ci.getComponents())) == null || subResult.size() <= 0) continue;
            for (int j = 0; j < subResult.size(); ++j) {
                result.add((String)subResult.get(j));
            }
        }
        return result;
    }

    public static void loadMultiLangFields(KDMultiLangBox mlb, IObjectValue data, String propertyName) {
        mlb.removeAllItems();
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo defaultLang = null;
        boolean isMetaData = data instanceof AbstractMDValue;
        while (iter.hasNext()) {
            LanguageInfo currentLang = (LanguageInfo)iter.next();
            Locale l = currentLang.getLocale();
            if (LocaleUtils.getDefaultLocale().equals(l)) {
                defaultLang = currentLang;
            }
            if (isMetaData) {
                l = LocaleUtils.getFirstOriginLocale((Locale)l);
            }
            mlb.addItem(currentLang, data.get(propertyName, l));
        }
        if (defaultLang != null) {
            mlb.setSelectedLanguage(defaultLang);
        }
    }

    public static void storeMultiLangFields(KDMultiLangBox mlb, IObjectValue data, String propertyName) {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo defaultLang = null;
        boolean isMetaData = data instanceof AbstractMDValue;
        while (iter.hasNext()) {
            LanguageInfo currentLang = (LanguageInfo)iter.next();
            Object itemValue = mlb.getItemBy(currentLang).getData();
            if (itemValue != null && itemValue.equals("")) {
                itemValue = null;
            }
            Locale l = currentLang.getLocale();
            if (defaultLang == null) {
                defaultLang = currentLang;
            }
            if (UIHelper.equals(LocaleUtils.getDefaultLocale(), l)) {
                defaultLang = currentLang;
            }
            if (isMetaData) {
                l = LocaleUtils.getFirstOriginLocale((Locale)l);
            }
            data.put(propertyName, itemValue, l);
        }
        Object itemValue = mlb.getItemBy(defaultLang).getData();
        if (itemValue != null && itemValue.equals("")) {
            itemValue = null;
        }
        data.put(propertyName, itemValue);
    }

    private static boolean equals(Locale a, Locale b) {
        if (a.equals(b)) {
            return true;
        }
        String asc = BOSLocaleUtil.getShortCode((Locale)a);
        String bsc = BOSLocaleUtil.getShortCode((Locale)b);
        return asc != null && asc.equalsIgnoreCase(bsc);
    }
}

