/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.service.webservice.core.AbstractBizEJBInvokeProxy;
import com.kingdee.bos.service.webservice.core.IdController;
import com.kingdee.bos.service.webservice.core.SOAPandJavaConversionException;
import com.kingdee.bos.service.webservice.core.SOAPandJavaTypeEngine;
import com.kingdee.bos.service.webservice.tools.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.messaging.OnewayListener;
import javax.xml.messaging.ReqRespListener;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;

public class BizServiceServlet
extends JAXMServlet
implements ReqRespListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.webservice.core.BizServiceServlet");
    private static String ns_wsdl_name = "nswsdl";
    private static String ns_types_name = "nstypes";
    private Hashtable bizProxyNameObjs = new Hashtable();
    private String cfg_initial_context_factory = null;
    private String cfg_ejb_jndi_name = null;
    private String cfg_ejbsrv_url = null;
    private String cfg_ejbsrv_user = null;
    private String cfg_ejbsrv_password = null;
    boolean isEjbLinkByBosFactory = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.cfg_initial_context_factory = this.getServletContext().getInitParameter("InitialContextFactory");
        this.cfg_ejbsrv_url = this.getServletContext().getInitParameter("EjbServerUrl");
        this.cfg_ejbsrv_user = this.getServletContext().getInitParameter("EjbServerUser");
        this.cfg_ejbsrv_password = this.getServletContext().getInitParameter("EjbServerPassword");
        if (this.cfg_ejbsrv_user != null && this.cfg_ejbsrv_user.trim().length() == 0) {
            this.cfg_ejbsrv_user = null;
        }
        this.cfg_ejb_jndi_name = this.getServletConfig().getInitParameter("BizEjbJndiName");
        if (this.cfg_ejb_jndi_name == null || this.cfg_ejb_jndi_name.equals("") || this.cfg_initial_context_factory == null || this.cfg_initial_context_factory.equals("") || this.cfg_ejbsrv_url == null || this.cfg_ejbsrv_url.equals("")) {
            this.isEjbLinkByBosFactory = true;
        }
    }

    public SOAPMessage onMessage(SOAPMessage requestMsg) {
        if (requestMsg == null) {
            return null;
        }
        boolean isDotNetClient = false;
        String[] userAgents = requestMsg.getMimeHeaders().getHeader("User-Agent");
        if (userAgents != null && userAgents.length > 0 && userAgents[0] != null) {
            isDotNetClient = userAgents[0].indexOf("MS Web Services Client") > -1;
        }
        SOAPMessage responseMsg = null;
        SOAPBody soapBody = null;
        try {
            MessageFactory mf = MessageFactory.newInstance();
            responseMsg = mf.createMessage();
            SOAPPart soapPart = responseMsg.getSOAPPart();
            SOAPEnvelope soapEnv = soapPart.getEnvelope();
            soapEnv.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            soapEnv.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            soapEnv.addNamespaceDeclaration(ns_wsdl_name, "urn:kingdee-bos-wsdl");
            soapEnv.addNamespaceDeclaration(ns_types_name, "urn:kingdee-bos-types");
            soapEnv.addNamespaceDeclaration("enc", "http://schemas.xmlsoap.org/soap/encoding/");
            soapEnv.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            soapBody = soapEnv.getBody();
        }
        catch (SOAPException e3) {
            BizServiceServlet.log2("init SOAP Message error", e3);
            return null;
        }
        catch (Throwable t) {
            BizServiceServlet.log2("init SOAP Message error", t);
            return null;
        }
        try {
            String proxyClsName = requestMsg.getContentDescription();
            if (proxyClsName == null) {
                throw new Exception("need proxy class name.");
            }
            AbstractBizEJBInvokeProxy bizProxy = (AbstractBizEJBInvokeProxy)this.bizProxyNameObjs.get(proxyClsName);
            if (bizProxy == null) {
                try {
                    Class<?> bizProxyCls = Class.forName(proxyClsName);
                    if (!ClassUtil.isObjectMatchType(bizProxyCls, AbstractBizEJBInvokeProxy.class)) {
                        throw new Exception("invalid proxy class name '" + proxyClsName + "'.");
                    }
                    bizProxy = (AbstractBizEJBInvokeProxy)bizProxyCls.newInstance();
                    bizProxy.setEjbLinkByBosFactory(this.isEjbLinkByBosFactory);
                    this.bizProxyNameObjs.put(proxyClsName, bizProxy);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new Exception("invalid proxy class name '" + proxyClsName + "'.");
                }
                catch (ExceptionInInitializerError eiie) {
                    throw new Exception("invalid proxy class name '" + proxyClsName + "'.");
                }
                catch (InstantiationException iie) {
                    throw new Exception("invalid proxy class name '" + proxyClsName + "'.");
                }
                catch (IllegalAccessException iae) {
                    throw new Exception("invalid proxy class name '" + proxyClsName + "'.");
                }
            }
            SOAPEnvelope requestEnv = requestMsg.getSOAPPart().getEnvelope();
            SOAPHeader sheader = requestEnv.getHeader();
            String sessionid = null;
            if (sheader != null) {
                Iterator headers = sheader.extractHeaderElements("http://schemas.xmlsoap.org/soap/actor/next");
                while (headers.hasNext()) {
                    SOAPHeaderElement header = (SOAPHeaderElement)headers.next();
                    if (!"urn:kingdee-bos-types".equals(header.getNamespaceURI(header.getElementName().getPrefix())) || !"sessionHeader".equals(header.getElementName().getLocalName())) continue;
                    Iterator sessionids = header.getChildElements(requestEnv.createName("sessionid"));
                    if (sessionids.hasNext()) {
                        SOAPElement sessionidEle = (SOAPElement)sessionids.next();
                        sessionid = sessionidEle.getValue();
                    }
                    if (!sessionids.hasNext()) continue;
                    throw new Exception("too many sessionids.");
                }
            }
            this.dealSOAPRequest(requestEnv, soapBody, sessionid, bizProxy, isDotNetClient);
        }
        catch (Throwable t) {
            Iterator childs = soapBody.getChildElements();
            if (childs != null) {
                while (childs.hasNext()) {
                    Object currChild = childs.next();
                    if (!(currChild instanceof SOAPElement)) continue;
                    ((SOAPElement)currChild).detachNode();
                }
            }
            try {
                SOAPFault faultEle = soapBody.getFault();
                if (faultEle == null) {
                    faultEle = soapBody.addFault();
                }
                faultEle.setFaultCode("none");
                faultEle.setFaultString(t.toString());
            }
            catch (SOAPException e) {
                BizServiceServlet.log2("generate invoke error info error", e);
                return null;
            }
        }
        try {
            responseMsg.saveChanges();
        }
        catch (SOAPException e) {
            BizServiceServlet.log2("saveChanges error", e);
            return null;
        }
        return responseMsg;
    }

    private String dealSOAPRequest(SOAPEnvelope requestEnv, SOAPBody responseSoapBody, String sessionid, AbstractBizEJBInvokeProxy bizProxy, boolean isDotNetClient) throws Throwable {
        SOAPElement soapOpEle = null;
        ArrayList alSoapComplexData = new ArrayList();
        ArrayList allBodyEleAl = SOAPandJavaTypeEngine.fetchChildElements((SOAPElement)requestEnv.getBody());
        for (int i = 0; i < allBodyEleAl.size(); ++i) {
            String prefix = ((SOAPElement)allBodyEleAl.get(i)).getElementName().getPrefix();
            if ("urn:kingdee-bos-wsdl".equals(((SOAPElement)allBodyEleAl.get(i)).getNamespaceURI(prefix))) {
                soapOpEle = (SOAPElement)allBodyEleAl.get(i);
                continue;
            }
            alSoapComplexData.add(allBodyEleAl.get(i));
        }
        if (soapOpEle == null) {
            throw new Exception("invalid soap document, need soap operation.");
        }
        String opName = soapOpEle.getElementName().getLocalName();
        String funcName = bizProxy.getMthdNameFromOperationName(opName);
        if (funcName == null) {
            throw new Exception("invalid soap operation name '" + opName + "'.");
        }
        try {
            ArrayList soapOpChildsAl = SOAPandJavaTypeEngine.fetchChildElements(soapOpEle);
            String[] funcParamTypes = bizProxy.getOperationParamTypes(opName);
            String[] funcParamNames = bizProxy.getOperationParamNames(opName);
            Object retObj = null;
            Context ctx = null;
            SOAPandJavaTypeEngine typeEngine = new SOAPandJavaTypeEngine(isDotNetClient);
            if (sessionid != null) {
                try {
                    ISessionManager manager = SessionManager.getInstance();
                    SessionInfo sessionInfo = manager.getSession(sessionid);
                    if (sessionInfo != null) {
                        ctx = sessionInfo.getContext();
                    }
                }
                catch (Throwable t) {
                    BizServiceServlet.log2("session error", t);
                }
            }
            if (!bizProxy.isEjbLinkByBosFactory && !bizProxy.isAlreadyInitialized()) {
                try {
                    bizProxy.setContextVar(this.cfg_initial_context_factory, this.cfg_ejb_jndi_name, this.cfg_ejbsrv_url, this.cfg_ejbsrv_user, this.cfg_ejbsrv_password);
                }
                catch (NamingException ne) {
                    throw ne;
                }
                catch (Throwable t) {
                    throw t;
                }
            }
            if (funcParamTypes.length == 0) {
                if (soapOpChildsAl.size() > 0) {
                    throw new Exception("soap operation '" + opName + "' has no parameter.");
                }
                retObj = bizProxy.invokeOperation(opName, null, ctx);
            } else {
                Object[] params = new Object[funcParamTypes.length];
                int idxSendActParam = 0;
                for (int i = 0; i < funcParamNames.length; ++i) {
                    if (idxSendActParam == soapOpChildsAl.size()) {
                        params[i] = null;
                        continue;
                    }
                    SOAPElement paramEle = (SOAPElement)soapOpChildsAl.get(idxSendActParam);
                    if (!funcParamNames[i].equals(paramEle.getElementName().getLocalName())) {
                        params[i] = null;
                        continue;
                    }
                    params[i] = typeEngine.soapToJavaObj(funcParamTypes[i], paramEle, bizProxy, alSoapComplexData);
                    ++idxSendActParam;
                }
                if (idxSendActParam != soapOpChildsAl.size()) {
                    throw new Exception("parameters's number is wrong.");
                }
                retObj = bizProxy.invokeOperation(opName, params, ctx);
            }
            SOAPElement respEle = responseSoapBody.addChildElement(bizProxy.getRespNameFromOperationName(opName), ns_wsdl_name);
            SOAPElement resultEle = respEle.addChildElement("result");
            resultEle = typeEngine.javaObjToSoap(retObj, bizProxy.getOperationRetType(opName), bizProxy, resultEle, responseSoapBody, ns_types_name, new IdController());
            return "";
        }
        catch (DOMException e1) {
            throw e1;
        }
        catch (SOAPException e1) {
            throw e1;
        }
        catch (SOAPandJavaConversionException e1) {
            throw e1;
        }
        catch (Throwable t) {
            throw t;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.getOutputStream().print("BizService has been deployed at this location");
    }

    public void doPost(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        try {
            MimeHeaders mimeheaders = BizServiceServlet.getHeaders((HttpServletRequest)httpservletrequest);
            ServletInputStream servletinputstream = httpservletrequest.getInputStream();
            SOAPMessage soapmessage = this.msgFactory.createMessage(mimeheaders, (InputStream)servletinputstream);
            soapmessage.setContentDescription(httpservletrequest.getQueryString());
            SOAPMessage soapmessage1 = null;
            if (this instanceof ReqRespListener) {
                soapmessage1 = this.onMessage(soapmessage);
            } else if (this instanceof OnewayListener) {
                ((OnewayListener)this).onMessage(soapmessage);
            } else {
                throw new ServletException("JAXM component: " + ((Object)((Object)this)).getClass().getName() + " also has to implement ReqRespListener or OnewayListener");
            }
            if (soapmessage1 != null) {
                if (soapmessage1.saveRequired()) {
                    soapmessage1.saveChanges();
                }
                httpservletresponse.setStatus(200);
                BizServiceServlet.putHeaders((MimeHeaders)soapmessage1.getMimeHeaders(), (HttpServletResponse)httpservletresponse);
                ServletOutputStream servletoutputstream = httpservletresponse.getOutputStream();
                soapmessage1.writeTo((OutputStream)servletoutputstream);
                servletoutputstream.flush();
            } else {
                httpservletresponse.setStatus(204);
            }
        }
        catch (Exception exception) {
            throw new ServletException("JAXM POST failed " + exception.getMessage());
        }
    }

    private static void log2(String s, Throwable t) {
        logger.error((Object)s, t);
    }
}

