/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

class DateTimeParser {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    DateTimeParser() {
    }

    public static Date parse(String dateStr) throws ParseException {
        try {
            if (dateStr == null) {
                return null;
            }
            int idxDot = dateStr.indexOf(46);
            if (idxDot < 0) {
                throw new Throwable();
            }
            int idxAddSub = dateStr.indexOf(43);
            if (idxAddSub < 0) {
                idxAddSub = dateStr.lastIndexOf(45);
            }
            if (idxAddSub < 0) {
                throw new Throwable();
            }
            String strTimeZone = dateStr.substring(idxAddSub);
            GregorianCalendar calendar = new GregorianCalendar();
            Date date = dateFormat.parse(dateStr.substring(0, idxDot));
            int timeAfterDot = (int)(Double.valueOf(dateStr.substring(idxDot, idxAddSub)) * 1000.0);
            calendar.setTimeInMillis(date.getTime() + (long)timeAfterDot);
            int idxColon = strTimeZone.indexOf(58);
            int timeZoneOffsetMinutes = Integer.valueOf(strTimeZone.substring(1, idxColon)) * 60 + Integer.valueOf(strTimeZone.substring(idxColon + 1));
            if (strTimeZone.charAt(0) == '-') {
                timeZoneOffsetMinutes = -timeZoneOffsetMinutes;
            }
            ((Calendar)calendar).add(12, -timeZoneOffsetMinutes);
            return calendar.getTime();
        }
        catch (NumberFormatException e) {
            throw new ParseException("'" + dateStr + "':" + e.toString(), 0);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ParseException("'" + dateStr + "':" + t.toString(), 0);
        }
    }

    public static String format(Date date) throws Throwable {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int tmpNum = 0;
        StringBuffer timeStr = new StringBuffer("");
        tmpNum = calendar.get(1);
        if (tmpNum < 1000) {
            timeStr.append('0');
        }
        if (tmpNum < 100) {
            timeStr.append('0');
        }
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append('-');
        tmpNum = calendar.get(2) + 1;
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append('-');
        tmpNum = calendar.get(5);
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append('T');
        tmpNum = calendar.get(11);
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append(':');
        tmpNum = calendar.get(12);
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append(':');
        tmpNum = calendar.get(13);
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append('.');
        tmpNum = (int)(date.getTime() % 1000L);
        if (tmpNum < 100) {
            timeStr.append('0');
        }
        if (tmpNum < 10) {
            timeStr.append('0');
        }
        timeStr.append(tmpNum);
        timeStr.append("+00:00");
        return timeStr.toString();
    }
}

