/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.core;

import com.kingdee.bos.service.webservice.core.SOAPandJavaTypeEngine;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.messaging.ReqRespListener;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;

public class LoginServiceServlet
extends JAXMServlet
implements ReqRespListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.webservice.core.LoginServiceServlet");
    private static String ns_wsdl_name = "nswsdl";
    private static String ns_types_name = "nstypes";
    static String wsdlStr1 = "";
    static String wsdlStr2 = "";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public SOAPMessage onMessage(SOAPMessage requestMsg) {
        SOAPMessage responseMsg = null;
        SOAPBody soapBody = null;
        try {
            MessageFactory mf = MessageFactory.newInstance();
            responseMsg = mf.createMessage();
            SOAPPart soapPart = responseMsg.getSOAPPart();
            SOAPEnvelope soapEnv = soapPart.getEnvelope();
            soapEnv.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            soapEnv.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            soapEnv.addNamespaceDeclaration(ns_wsdl_name, "urn:kingdee-bos-wsdl");
            soapEnv.addNamespaceDeclaration("enc", "http://schemas.xmlsoap.org/soap/encoding/");
            soapEnv.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            soapBody = soapEnv.getBody();
            requestMsg.writeTo((OutputStream)System.out);
            SOAPEnvelope requestEnv = requestMsg.getSOAPPart().getEnvelope();
            this.dealSOAPRequest(requestEnv, soapBody);
        }
        catch (Throwable t) {
            LoginServiceServlet.log2("login error", t);
            Iterator childs = soapBody.getChildElements();
            if (childs != null) {
                while (childs.hasNext()) {
                    Object currChild = childs.next();
                    if (!(currChild instanceof SOAPElement)) continue;
                    ((SOAPElement)currChild).detachNode();
                }
            }
            try {
                SOAPFault faultEle = soapBody.getFault();
                faultEle.setFaultCode("none");
                faultEle.setFaultString(t.toString());
            }
            catch (SOAPException e) {
                LoginServiceServlet.log2("create fault info error", e);
            }
        }
        try {
            responseMsg.saveChanges();
            responseMsg.writeTo((OutputStream)System.out);
        }
        catch (SOAPException e) {
            LoginServiceServlet.log2("saveChanges error", e);
        }
        catch (IOException e) {
            LoginServiceServlet.log2("saveChanges error", e);
        }
        return responseMsg;
    }

    private String dealSOAPRequest(SOAPEnvelope requestEnv, SOAPBody responseSoapBody) throws Throwable {
        SOAPElement soapOpEle = null;
        ArrayList alSoapComplexData = new ArrayList();
        ArrayList allBodyEleAl = SOAPandJavaTypeEngine.fetchChildElements((SOAPElement)requestEnv.getBody());
        for (int i = 0; i < allBodyEleAl.size(); ++i) {
            String prefix = ((SOAPElement)allBodyEleAl.get(i)).getElementName().getPrefix();
            if ("urn:kingdee-bos-wsdl".equals(((SOAPElement)allBodyEleAl.get(i)).getNamespaceURI(prefix))) {
                soapOpEle = (SOAPElement)allBodyEleAl.get(i);
                continue;
            }
            alSoapComplexData.add(allBodyEleAl.get(i));
        }
        if (soapOpEle == null) {
            return null;
        }
        String opName = soapOpEle.getElementName().getLocalName();
        try {
            String user = null;
            String password = null;
            ArrayList soapOpChildsAl = SOAPandJavaTypeEngine.fetchChildElements(soapOpEle);
            Object retObj = null;
            if (soapOpChildsAl.size() != 2) {
                return null;
            }
            SOAPElement userParamEle = (SOAPElement)soapOpChildsAl.get(0);
            SOAPElement passwordParamEle = (SOAPElement)soapOpChildsAl.get(1);
            if (!"user".equals(userParamEle.getElementName().getLocalName())) {
                return null;
            }
            if (!"password".equals(passwordParamEle.getElementName().getLocalName())) {
                return null;
            }
            user = userParamEle.getValue();
            password = passwordParamEle.getValue();
            SOAPElement respEle = responseSoapBody.addChildElement("loginResponse", ns_wsdl_name);
            SOAPElement resultEle = respEle.addChildElement("result");
            resultEle.addTextNode("sessionid:" + new SecureRandom().nextLong());
            return "";
        }
        catch (DOMException e1) {
            throw e1;
        }
        catch (SOAPException e1) {
            throw e1;
        }
        catch (Throwable t) {
            throw t;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String queryStr = req.getQueryString();
        if (queryStr != null && "wsdl".equals(queryStr.toLowerCase(Locale.ENGLISH))) {
            resp.getOutputStream().print(wsdlStr1 + req.getRequestURL() + wsdlStr2);
            return;
        }
        resp.getOutputStream().print("LoginWebService has been deployed at this location.");
    }

    private static void log2(String s, Throwable t) {
        logger.error((Object)s, t);
    }

    static {
        wsdlStr1 = wsdlStr1 + "<?xml version='1.0' encoding='UTF-8'?>";
        wsdlStr1 = wsdlStr1 + "<definitions name='wstestentService' targetNamespace='urn:kingdee-bos-wsdl' xmlns:tns='urn:kingdee-bos-wsdl' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:soap='http://schemas.xmlsoap.org/wsdl/soap/' xmlns='http://schemas.xmlsoap.org/wsdl/'>";
        wsdlStr1 = wsdlStr1 + "  <message name='loginMsg'>";
        wsdlStr1 = wsdlStr1 + "    <part name='user' type='xsd:string'/>";
        wsdlStr1 = wsdlStr1 + "    <part name='password' type='xsd:string'/>";
        wsdlStr1 = wsdlStr1 + "  </message>";
        wsdlStr1 = wsdlStr1 + "  <message name='loginResponse'>";
        wsdlStr1 = wsdlStr1 + "    <part name='result' type='xsd:string'/>";
        wsdlStr1 = wsdlStr1 + "  </message>";
        wsdlStr1 = wsdlStr1 + "  <portType name='ILoginPortType'>";
        wsdlStr1 = wsdlStr1 + "    <operation name='login'>";
        wsdlStr1 = wsdlStr1 + "      <input message='tns:loginMsg'/>";
        wsdlStr1 = wsdlStr1 + "      <output message='tns:loginResponse'/>";
        wsdlStr1 = wsdlStr1 + "    </operation>";
        wsdlStr1 = wsdlStr1 + "  </portType>";
        wsdlStr1 = wsdlStr1 + "  <binding name='ILoginBinding' type='tns:ILoginPortType'>";
        wsdlStr1 = wsdlStr1 + "    <soap:binding style='rpc' transport='http://schemas.xmlsoap.org/soap/http'/>";
        wsdlStr1 = wsdlStr1 + "    <operation name='login'>";
        wsdlStr1 = wsdlStr1 + "      <soap:operation soapAction=''/>";
        wsdlStr1 = wsdlStr1 + "      <input>";
        wsdlStr1 = wsdlStr1 + "        <soap:body use='encoded' encodingStyle='http://schemas.xmlsoap.org/soap/encoding/' namespace='urn:kingdee-bos-wsdl'/>";
        wsdlStr1 = wsdlStr1 + "      </input>";
        wsdlStr1 = wsdlStr1 + "      <output>";
        wsdlStr1 = wsdlStr1 + "        <soap:body use='encoded' encodingStyle='http://schemas.xmlsoap.org/soap/encoding/' namespace='urn:kingdee-bos-wsdl'/>";
        wsdlStr1 = wsdlStr1 + "      </output>";
        wsdlStr1 = wsdlStr1 + "    </operation>";
        wsdlStr1 = wsdlStr1 + "  </binding>";
        wsdlStr1 = wsdlStr1 + "  <service name='Login'>";
        wsdlStr1 = wsdlStr1 + "    <port name='ILoginPort' binding='tns:ILoginBinding'>";
        wsdlStr1 = wsdlStr1 + "      <soap:address location='";
        wsdlStr2 = wsdlStr2 + "'/>";
        wsdlStr2 = wsdlStr2 + "    </port>";
        wsdlStr2 = wsdlStr2 + "  </service>";
        wsdlStr2 = wsdlStr2 + "</definitions>";
    }
}

