/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.core;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.webservice.core.DateTimeParser;
import com.kingdee.bos.service.webservice.core.IBOSEJBInfo;
import com.kingdee.bos.service.webservice.core.IdController;
import com.kingdee.bos.service.webservice.core.SOAPandJavaConversionException;
import com.kingdee.bos.service.webservice.core.SOAPandJavaTypeEngine_DealStatus;
import com.kingdee.bos.service.webservice.tools.ClassUtil;
import com.kingdee.bos.service.webservice.tools.XMLandJavaType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public class SOAPandJavaTypeEngine {
    private boolean isDotNet = false;
    private static Hashtable clsObjCache = new Hashtable();
    static String xsi_type_str = "xsi:type";
    static String xsi_nil_str = "xsi:nil";
    static String xsd_str = "xsd:";
    static String enc_array_str = "enc:Array";
    static String enc_arraytype_str = "enc:arrayType";

    public static void main(String[] args) {
    }

    public SOAPandJavaTypeEngine(boolean isDotNetClient) {
        this.isDotNet = isDotNetClient;
    }

    private Object specialSoapToJavaObj(String objType, SOAPElement complexDataEle, SOAPandJavaTypeEngine_DealStatus dealStatus, IBOSEJBInfo ejbInfo) throws Throwable {
        if ("com.kingdee.bos.dao.IObjectPK".equals(objType)) {
            dealStatus.dealed = true;
            ArrayList complexDataMembersAl = SOAPandJavaTypeEngine.fetchChildElements(complexDataEle);
            if (complexDataMembersAl.size() != 1) {
                throw new SOAPandJavaConversionException("ObjectPK needs one child element.");
            }
            SOAPElement memberEle = (SOAPElement)complexDataMembersAl.get(0);
            if (!"entityID".equals(memberEle.getElementName().getLocalName())) {
                throw new SOAPandJavaConversionException("ObjectPK's child element should be <entityID>.");
            }
            return new ObjectUuidPK(memberEle.getValue());
        }
        if ("com.kingdee.bos.util.BOSUuid".equals(objType)) {
            dealStatus.dealed = true;
            ArrayList complexDataMembersAl = SOAPandJavaTypeEngine.fetchChildElements(complexDataEle);
            if (complexDataMembersAl.size() != 1) {
                throw new SOAPandJavaConversionException("BOSUuid needs one child element.");
            }
            SOAPElement memberEle = (SOAPElement)complexDataMembersAl.get(0);
            if (!"id".equals(memberEle.getElementName().getLocalName())) {
                throw new SOAPandJavaConversionException("BOSUuid's child element should be <id>.");
            }
            return BOSUuid.read((String)memberEle.getValue());
        }
        Class enumClsObj = ejbInfo.getEnumClassObj(objType);
        if (enumClsObj == null) {
            return null;
        }
        dealStatus.dealed = true;
        return EnumUtils.getEnum((Class)enumClsObj, (String)complexDataEle.getValue());
    }

    private Object soapArrToJavaObj(String objType, SOAPElement soapData, IBOSEJBInfo ejbInfo, ArrayList alSoapComplexData, SOAPFactory soapFactory) throws Throwable {
        String sendArrInfo;
        int fromIdx = 0;
        int dimensionCnt = 0;
        while (objType.indexOf("[]", fromIdx) >= 0) {
            fromIdx = objType.indexOf("[]", fromIdx) + 1;
            ++dimensionCnt;
        }
        String arrBaseType = objType.substring(0, objType.indexOf("[]"));
        Class<?> typeClassObj = (Class<?>)clsObjCache.get(arrBaseType);
        if (typeClassObj == null) {
            typeClassObj = (Class)XMLandJavaType.JAVA_PRIMITIVE_CLASSOBJ_MAPPING.get(arrBaseType);
            if (typeClassObj == null) {
                typeClassObj = Class.forName(arrBaseType);
            }
            clsObjCache.put(arrBaseType, typeClassObj);
        }
        SOAPElement arrDataEle = null;
        String refId = soapData.getAttributeValue(soapFactory.createName("href"));
        if (refId != null && !"".equals(refId)) {
            for (int i = 0; i < alSoapComplexData.size(); ++i) {
                SOAPElement tmpEle = (SOAPElement)alSoapComplexData.get(i);
                if (!refId.equals("#" + tmpEle.getAttributeValue(soapFactory.createName("id")))) continue;
                arrDataEle = tmpEle;
            }
            if (arrDataEle == null) {
                throw new SOAPandJavaConversionException("the href '" + refId + "' refer to nothing.");
            }
        } else {
            arrDataEle = soapData;
        }
        if ((sendArrInfo = arrDataEle.getAttributeValue(soapFactory.createName("arrayType", "anyStr", "http://schemas.xmlsoap.org/soap/encoding/"))) == null || sendArrInfo.equals("") || sendArrInfo.indexOf("[") < 0) {
            throw new SOAPandJavaConversionException("arrayType description is wrong.");
        }
        String sendArrInfo1 = sendArrInfo.substring(0, sendArrInfo.indexOf("["));
        String sendArrInfo2 = sendArrInfo.substring(sendArrInfo.indexOf("["));
        sendArrInfo2 = sendArrInfo2.trim();
        if (this.isDotNet) {
            Vector<ArrDataStruc> arrLayer = new Vector<ArrDataStruc>();
            class ArrDataStruc {
                String key;
                Object obj;

                public ArrDataStruc(String key, Object obj) {
                    this.key = key;
                    this.obj = obj;
                }
            }
            arrLayer.add(new ArrDataStruc("0", arrDataEle));
            int currIdx = 0;
            ArrDataStruc currArrDataStruc = null;
            do {
                currArrDataStruc = (ArrDataStruc)arrLayer.get(currIdx);
                String layerKey = currArrDataStruc.key;
                SOAPElement currArrDataEle = (SOAPElement)currArrDataStruc.obj;
                if (currIdx > 0) {
                    sendArrInfo = currArrDataEle.getAttributeValue(soapFactory.createName("arrayType", "anyStr", "http://schemas.xmlsoap.org/soap/encoding/"));
                }
                if (sendArrInfo != null && sendArrInfo.indexOf("[") > -1) {
                    int idx1 = sendArrInfo.lastIndexOf("[");
                    int idx2 = sendArrInfo.lastIndexOf("]");
                    if (idx2 < idx1) {
                        throw new SOAPandJavaConversionException("arrayType description is wrong.");
                    }
                    int arrLen = -1;
                    try {
                        arrLen = Integer.valueOf(sendArrInfo.substring(idx1 + 1, idx2));
                        if (arrLen < 0) {
                            throw new SOAPandJavaConversionException("array dimension '" + sendArrInfo.substring(idx1 + 1, idx2) + "' should be greater than -1.");
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SOAPandJavaConversionException("array dimension '" + sendArrInfo.substring(idx1 + 1, idx2) + "' should be integer.");
                    }
                    ArrayList arrDataEleAl = SOAPandJavaTypeEngine.fetchChildElements(currArrDataEle);
                    if (arrDataEleAl.size() != arrLen) {
                        throw new SOAPandJavaConversionException("array dimension should be equal to child elements count.");
                    }
                    for (int i = 0; i < arrLen; ++i) {
                        SOAPElement currDataEle = (SOAPElement)arrDataEleAl.get(i);
                        SOAPElement trueDataEle = null;
                        String refId2 = currDataEle.getAttributeValue(soapFactory.createName("href"));
                        if (refId2 != null && !"".equals(refId2)) {
                            for (int k = 0; k < alSoapComplexData.size(); ++k) {
                                SOAPElement tmpEle = (SOAPElement)alSoapComplexData.get(k);
                                if (!refId2.equals("#" + tmpEle.getAttributeValue(soapFactory.createName("id")))) continue;
                                trueDataEle = tmpEle;
                                break;
                            }
                            if (trueDataEle == null) {
                                throw new SOAPandJavaConversionException("the href '" + refId2 + "' refer to nothing.");
                            }
                        } else {
                            trueDataEle = currDataEle;
                        }
                        arrLayer.add(new ArrDataStruc(layerKey + "-" + i, trueDataEle));
                    }
                    continue;
                }
                Object baseObj = this.soapToJavaObj(arrBaseType, currArrDataEle, ejbInfo, alSoapComplexData);
                arrLayer.set(currIdx, new ArrDataStruc(((ArrDataStruc)arrLayer.get((int)currIdx)).key, baseObj));
            } while (++currIdx < arrLayer.size());
            for (int i = 0; i < arrLayer.size(); ++i) {
                ArrDataStruc idx2 = (ArrDataStruc)arrLayer.get(i);
            }
            Vector<Object> arrMembers = new Vector<Object>();
            for (int i = arrLayer.size() - 1; i >= 0; --i) {
                ArrDataStruc currArrDataStruc2 = (ArrDataStruc)arrLayer.get(i);
                String currLayerKey2 = currArrDataStruc2.key;
                int layerKeyLen2 = currLayerKey2.length();
                Object currObj2 = currArrDataStruc2.obj;
                if (!(currObj2 instanceof SOAPElement)) continue;
                arrMembers.clear();
                for (int k = i + 1; k < arrLayer.size(); ++k) {
                    ArrDataStruc currArrDataStruc3 = (ArrDataStruc)arrLayer.get(k);
                    String currLayerKey3 = currArrDataStruc3.key;
                    Object currObj3 = currArrDataStruc3.obj;
                    if (layerKeyLen2 != currLayerKey3.length() - 2 || !currLayerKey3.startsWith(currLayerKey2)) continue;
                    arrMembers.add(currObj3);
                }
                if (arrMembers.size() <= 0) continue;
                Object newArrObj = null;
                newArrObj = arrMembers.get(0).getClass().getName().indexOf("[") >= 0 ? Array.newInstance(arrMembers.get(0).getClass(), arrMembers.size()) : Array.newInstance(typeClassObj, arrMembers.size());
                for (int m = 0; m < arrMembers.size(); ++m) {
                    Array.set(newArrObj, m, arrMembers.get(m));
                }
                currArrDataStruc2.obj = newArrObj;
            }
            return ((ArrDataStruc)arrLayer.get((int)0)).obj;
        }
        if (!sendArrInfo2.startsWith("[") || !sendArrInfo2.endsWith("]")) {
            throw new SOAPandJavaConversionException("arrayType description is wrong.");
        }
        sendArrInfo2 = sendArrInfo2.substring(1, sendArrInfo2.length() - 1);
        StringTokenizer st = new StringTokenizer(sendArrInfo2, ",");
        int[] dimensions = new int[st.countTokens()];
        int totalArrEleCnt = 1;
        if (dimensions.length == 0) {
            throw new SOAPandJavaConversionException("arrayType description is wrong.");
        }
        for (int i = 0; i < dimensions.length; ++i) {
            String currToken = st.nextToken();
            try {
                dimensions[i] = Integer.valueOf(currToken);
                if (dimensions[i] < 0) {
                    throw new SOAPandJavaConversionException("array dimension '" + currToken + "' should be greater than -1.");
                }
                totalArrEleCnt *= dimensions[i];
                continue;
            }
            catch (NumberFormatException e) {
                throw new SOAPandJavaConversionException("array dimension '" + currToken + "' should be integer.");
            }
        }
        Object arrRetObj = Array.newInstance(typeClassObj, dimensions);
        ArrayList arrDataEleAl = SOAPandJavaTypeEngine.fetchChildElements(arrDataEle);
        if (arrDataEleAl.size() != totalArrEleCnt) {
            throw new SOAPandJavaConversionException("array dimension should be equal to child elements count.");
        }
        Object upperArrObj = null;
        ArrayList<Object> upperArrObjAl = new ArrayList<Object>();
        upperArrObjAl.add(arrRetObj);
        for (int i = 0; i < dimensions.length; ++i) {
            ArrayList<Object> tmpCurrArrObjAl = new ArrayList<Object>();
            int newDimensionsLen = dimensions.length - i - 1;
            int[] newDimensions = new int[newDimensionsLen];
            for (int idx = 0; idx < newDimensionsLen; ++idx) {
                newDimensions[idx] = dimensions[idx + i + 1];
            }
            for (int k = 0; k < upperArrObjAl.size(); ++k) {
                Object currUpperArr = upperArrObjAl.get(k);
                for (int m = 0; m < dimensions[i]; ++m) {
                    Object tmpObj = null;
                    if (i != dimensions.length - 1) {
                        tmpObj = Array.newInstance(typeClassObj, newDimensions);
                        tmpCurrArrObjAl.add(tmpObj);
                    } else {
                        int orderOfAl = k * dimensions[dimensions.length - 1] + m;
                        tmpObj = this.soapToJavaObj(arrBaseType, (SOAPElement)arrDataEleAl.get(orderOfAl), ejbInfo, alSoapComplexData);
                    }
                    Array.set(currUpperArr, m, tmpObj);
                }
            }
            upperArrObjAl = tmpCurrArrObjAl;
        }
        return arrRetObj;
    }

    public Object soapToJavaObj(String objType, SOAPElement soapData, IBOSEJBInfo ejbInfo, ArrayList alSoapComplexData) throws SOAPandJavaConversionException {
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            if (XMLandJavaType.JAVA_INTEGER_TYPE.equals(objType) || XMLandJavaType.JAVA_P_INTEGER_TYPE.equals(objType)) {
                return Integer.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_SHORT_TYPE.equals(objType) || XMLandJavaType.JAVA_P_SHORT_TYPE.equals(objType)) {
                return Short.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_LONG_TYPE.equals(objType) || XMLandJavaType.JAVA_P_LONG_TYPE.equals(objType)) {
                return Long.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_BYTE_TYPE.equals(objType) || XMLandJavaType.JAVA_P_BYTE_TYPE.equals(objType)) {
                return Byte.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_FLOAT_TYPE.equals(objType) || XMLandJavaType.JAVA_P_FLOAT_TYPE.equals(objType)) {
                return Float.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_DOUBLE_TYPE.equals(objType) || XMLandJavaType.JAVA_P_DOUBLE_TYPE.equals(objType)) {
                return Double.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_BOOLEAN_TYPE.equals(objType) || XMLandJavaType.JAVA_P_BOOLEAN_TYPE.equals(objType)) {
                return Boolean.valueOf(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_STRING_TYPE.equals(objType)) {
                return soapData.getValue();
            }
            if (XMLandJavaType.JAVA_BIGDECIMAL_TYPE.equals(objType)) {
                return new BigDecimal(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_BIGINTEGER_TYPE.equals(objType)) {
                return new BigInteger(soapData.getValue());
            }
            if (XMLandJavaType.JAVA_CALENDAR_TYPE.equals(objType)) {
                Calendar calendar = Calendar.getInstance();
                java.util.Date date = DateTimeParser.parse(soapData.getValue());
                calendar.setTime(date);
                return calendar;
            }
            if (XMLandJavaType.JAVA_DATE_TYPE.equals(objType)) {
                java.util.Date date = null;
                date = DateTimeParser.parse(soapData.getValue());
                return date;
            }
            if (XMLandJavaType.JAVA_TIME_TYPE.equals(objType)) {
                java.util.Date date = null;
                date = DateTimeParser.parse(soapData.getValue());
                if (date != null) {
                    return new Time(date.getTime());
                }
                return null;
            }
            if (XMLandJavaType.JAVA_TIMESTAMP_TYPE.equals(objType)) {
                java.util.Date date = null;
                date = DateTimeParser.parse(soapData.getValue());
                if (date != null) {
                    return new Timestamp(date.getTime());
                }
                return null;
            }
            if (XMLandJavaType.JAVA_SQLDATE_TYPE.equals(objType)) {
                java.util.Date date = null;
                date = DateTimeParser.parse(soapData.getValue());
                if (date != null) {
                    return new Date(date.getTime());
                }
                return null;
            }
            if (XMLandJavaType.JAVA_OBJECT_TYPE.equals(objType)) {
                return new Object();
            }
            if (objType.endsWith("[]")) {
                return this.soapArrToJavaObj(objType, soapData, ejbInfo, alSoapComplexData, soapFactory);
            }
            SOAPElement complexDataEle = null;
            String refId = soapData.getAttributeValue(soapFactory.createName("href"));
            if (refId != null && !"".equals(refId)) {
                for (int i = 0; i < alSoapComplexData.size(); ++i) {
                    SOAPElement tmpEle = (SOAPElement)alSoapComplexData.get(i);
                    if (!refId.equals("#" + tmpEle.getAttributeValue(soapFactory.createName("id")))) continue;
                    complexDataEle = tmpEle;
                }
                if (complexDataEle == null) {
                    throw new SOAPandJavaConversionException("the href '" + refId + "' refer to nothing.");
                }
            }
            if (complexDataEle == null) {
                complexDataEle = soapData;
            }
            Object retObj = null;
            SOAPandJavaTypeEngine_DealStatus dealStatus = new SOAPandJavaTypeEngine_DealStatus();
            retObj = this.specialSoapToJavaObj(objType, complexDataEle, dealStatus, ejbInfo);
            if (dealStatus.dealed) {
                return retObj;
            }
            Class<?> typeClassObj = (Class<?>)clsObjCache.get(objType);
            if (typeClassObj == null) {
                typeClassObj = Class.forName(objType);
                retObj = typeClassObj.newInstance();
                clsObjCache.put(objType, typeClassObj);
            }
            try {
                retObj = typeClassObj.newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            String objCollectionArrType = ejbInfo.getObjCollectionArrType(objType);
            if (objCollectionArrType != null) {
                Object[] arr = (Object[])this.soapToJavaObj(objCollectionArrType, soapData, ejbInfo, alSoapComplexData);
                if (arr != null) {
                    for (int i = 0; i < arr.length; ++i) {
                        ((IObjectCollection)retObj).addObject((IObjectValue)arr[i]);
                    }
                }
                return retObj;
            }
            String[] objMemberNames = ejbInfo.getClsMemberNames(objType);
            String[] objMemberTypes = ejbInfo.getClsMemberTypes(objType);
            boolean[] objMemberHasSetMthds = ejbInfo.getClsMemberHasSetMthds(objType);
            if (objMemberNames == null) {
                return retObj;
            }
            ArrayList complexDataMembersAl = SOAPandJavaTypeEngine.fetchChildElements(complexDataEle);
            int idxSendActMember = 0;
            for (int i = 0; i < objMemberNames.length; ++i) {
                Object memberVal = null;
                if (idxSendActMember < complexDataMembersAl.size()) {
                    SOAPElement memberEle = (SOAPElement)complexDataMembersAl.get(idxSendActMember);
                    if (!objMemberNames[i].equals(memberEle.getElementName().getLocalName())) {
                        memberVal = null;
                    } else {
                        memberVal = this.soapToJavaObj(objMemberTypes[i], memberEle, ejbInfo, alSoapComplexData);
                        ++idxSendActMember;
                    }
                }
                if (objMemberHasSetMthds[i] || ClassUtil.isObjectMatchType(objMemberTypes[i], IObjectCollection.class.getName())) {
                    try {
                        if (objMemberHasSetMthds[i]) {
                            String setMthdName = "set" + objMemberNames[i].substring(0, 1).toUpperCase() + objMemberNames[i].substring(1);
                            String requireType = (String)XMLandJavaType.JAVA_PRIMITIVE_CLASS_MAPPING.get(objMemberTypes[i]);
                            if (requireType == null) {
                                requireType = objMemberTypes[i];
                            }
                            Method setMthd = retObj.getClass().getMethod(setMthdName, Class.forName(requireType));
                            setMthd.invoke(retObj, memberVal);
                            continue;
                        }
                        Method setMthd = retObj.getClass().getMethod("put", String.class, Object.class);
                        setMthd.invoke(retObj, objMemberNames[i], memberVal);
                        continue;
                    }
                    catch (SecurityException e1) {
                        throw e1;
                    }
                    catch (IllegalArgumentException e1) {
                        throw e1;
                    }
                    catch (NoSuchMethodException e1) {
                        throw e1;
                    }
                    catch (ClassNotFoundException e1) {
                        throw e1;
                    }
                    catch (IllegalAccessException e1) {
                        throw e1;
                    }
                    catch (InvocationTargetException e1) {
                        throw e1;
                    }
                }
                try {
                    Field memberField = retObj.getClass().getField(objMemberNames[i]);
                    memberField.set(retObj, memberVal);
                    continue;
                }
                catch (SecurityException e1) {
                    throw e1;
                }
                catch (IllegalArgumentException e1) {
                    throw e1;
                }
                catch (NoSuchFieldException e1) {
                    throw e1;
                }
                catch (IllegalAccessException e1) {
                    throw e1;
                }
            }
            if (idxSendActMember != complexDataMembersAl.size()) {
                throw new SOAPandJavaConversionException(ClassUtil.getStrAfterDot(objType) + "'properties are wrong.");
            }
            return retObj;
        }
        catch (SOAPException e) {
            throw new SOAPandJavaConversionException(e);
        }
        catch (NumberFormatException e) {
            throw new SOAPandJavaConversionException(e);
        }
        catch (ParseException e) {
            throw new SOAPandJavaConversionException(e);
        }
        catch (SOAPandJavaConversionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SOAPandJavaConversionException(t);
        }
    }

    private boolean specialJavaObjToSoap(Object obj, String objType, SOAPElement complexDataEle, String ns_types_name, IBOSEJBInfo ejbInfo) throws Throwable {
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        if ("com.kingdee.bos.dao.IObjectPK".equals(objType)) {
            SOAPElement memberEle = null;
            complexDataEle.addAttribute(soapFactory.createName(xsi_type_str), ns_types_name + ":BOSSPECIALTYPE_IObjectPK");
            memberEle = complexDataEle.addChildElement("entityID");
            memberEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(XMLandJavaType.JAVA_STRING_TYPE));
            memberEle.addTextNode(((ObjectUuidPK)obj).toString());
            return true;
        }
        if ("com.kingdee.bos.util.BOSUuid".equals(objType)) {
            SOAPElement memberEle = null;
            complexDataEle.addAttribute(soapFactory.createName(xsi_type_str), ns_types_name + ":BOSSPECIALTYPE_BOSUuid");
            memberEle = complexDataEle.addChildElement("id");
            memberEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(XMLandJavaType.JAVA_STRING_TYPE));
            memberEle.addTextNode(((BOSUuid)obj).toString());
            return true;
        }
        Class enumClsObj = ejbInfo.getEnumClassObj(objType);
        if (enumClsObj == null) {
            return false;
        }
        complexDataEle.addAttribute(soapFactory.createName(xsi_type_str), ns_types_name + ":" + ejbInfo.getClsWsdlTypeName(objType));
        complexDataEle.addTextNode(((Enum)obj).getName());
        return true;
    }

    private void javaObjToSoapArr(Object obj, String objType, IBOSEJBInfo ejbInfo, SOAPElement resultEle, SOAPBody bodyEle, String ns_types_name, IdController idCtl, SOAPFactory soapFactory) throws Throwable {
        if (obj == null) {
            resultEle.addAttribute(soapFactory.createName(xsi_nil_str), "1");
            return;
        }
        int fromIdx = 0;
        int dimensionCnt = 0;
        while (objType.indexOf("[]", fromIdx) >= 0) {
            fromIdx = objType.indexOf("[]", fromIdx) + 1;
            ++dimensionCnt;
        }
        String arrBaseType = objType.substring(0, objType.indexOf("[]"));
        if (this.isDotNet) {
            boolean isSelfDefType = false;
            String selfTypeName = ejbInfo.getClsWsdlTypeName(arrBaseType);
            if (selfTypeName != null) {
                isSelfDefType = true;
            }
            Hashtable<Integer, String> layer_arrayStr = new Hashtable<Integer, String>();
            StringBuffer sb = null;
            if (selfTypeName != null) {
                sb = new StringBuffer(selfTypeName);
            } else {
                String xmlType = (String)XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(arrBaseType);
                if (xmlType != null) {
                    sb = new StringBuffer(xmlType);
                } else {
                    throw new SOAPandJavaConversionException("invalid type '" + arrBaseType + "'.");
                }
            }
            layer_arrayStr.put(new Integer(0), sb.toString());
            for (int i = 1; i <= dimensionCnt; ++i) {
                sb.append("[]");
                layer_arrayStr.put(new Integer(i), sb.toString());
            }
            String complexDataId = "ID" + idCtl.id++;
            SOAPElement complexDataEle = null;
            complexDataEle = bodyEle.addChildElement(enc_array_str);
            complexDataEle.addAttribute(soapFactory.createName("id"), complexDataId);
            resultEle.addAttribute(soapFactory.createName("href"), "#" + complexDataId);
            Vector<ArrLayerStruc> arrLayer = new Vector<ArrLayerStruc>();
            class ArrLayerStruc {
                SOAPElement soapEle;
                Object obj;
                int layerCnt;

                public ArrLayerStruc(Object obj, SOAPElement soapEle, int layerCnt) {
                    this.soapEle = soapEle;
                    this.obj = obj;
                    this.layerCnt = layerCnt;
                }
            }
            arrLayer.add(new ArrLayerStruc(obj, complexDataEle, dimensionCnt));
            String ns_types_prefix = xsd_str;
            if (isSelfDefType) {
                ns_types_prefix = ns_types_name + ":";
            }
            int currIdx = 0;
            do {
                ArrLayerStruc currLayerStruc = (ArrLayerStruc)arrLayer.get(currIdx);
                Object currObj = currLayerStruc.obj;
                SOAPElement currSoapEle = currLayerStruc.soapEle;
                int currLayerCnt = currLayerStruc.layerCnt;
                int currArrLen = Array.getLength(currObj);
                currSoapEle.addAttribute(soapFactory.createName(enc_arraytype_str), ns_types_prefix + layer_arrayStr.get(new Integer(currLayerCnt - 1)) + "[" + currArrLen + "]");
                for (int i = 0; i < currArrLen; ++i) {
                    SOAPElement hrefEle;
                    Object theObj = Array.get(currObj, i);
                    String newEleId = "ID" + idCtl.id++;
                    SOAPElement newEle = null;
                    if (theObj.getClass().getName().indexOf("[") >= 0) {
                        hrefEle = currSoapEle.addChildElement("Item");
                        hrefEle.addAttribute(soapFactory.createName("href"), "#" + newEleId);
                        newEle = bodyEle.addChildElement(enc_array_str);
                        newEle.addAttribute(soapFactory.createName("id"), newEleId);
                        arrLayer.add(new ArrLayerStruc(theObj, newEle, currLayerCnt - 1));
                        continue;
                    }
                    hrefEle = currSoapEle.addChildElement("Item");
                    this.javaObjToSoap(theObj, arrBaseType, ejbInfo, hrefEle, bodyEle, ns_types_name, idCtl);
                    continue;
                }
            } while (++currIdx < arrLayer.size());
        } else {
            ArrayList<Object> upperArrObjAl = new ArrayList<Object>();
            upperArrObjAl.add(obj);
            String dimensionStr = "";
            String subArrStr = arrBaseType;
            for (int i = 0; i < dimensionCnt; ++i) {
                ArrayList<Object> tmpCurrArrObjAl = new ArrayList<Object>();
                dimensionStr = i == 0 ? dimensionStr + Array.getLength(upperArrObjAl.get(0)) : dimensionStr + "," + Array.getLength(upperArrObjAl.get(0));
                for (int k = 0; k < upperArrObjAl.size(); ++k) {
                    Object currUpperArr = upperArrObjAl.get(k);
                    for (int m = 0; m < Array.getLength(upperArrObjAl.get(0)); ++m) {
                        tmpCurrArrObjAl.add(Array.get(currUpperArr, m));
                    }
                }
                upperArrObjAl = tmpCurrArrObjAl;
                if (i == dimensionCnt - 1) continue;
                subArrStr = subArrStr + "[]";
            }
            String complexDataId = "ID" + idCtl.id++;
            SOAPElement complexDataEle = null;
            complexDataEle = bodyEle.addChildElement(ns_types_name + ":" + ejbInfo.getClsWsdlTypeName(objType));
            complexDataEle.addAttribute(soapFactory.createName("id"), complexDataId);
            complexDataEle.addAttribute(soapFactory.createName(xsi_type_str), enc_array_str);
            String selfTypeName = ejbInfo.getClsWsdlTypeName(arrBaseType);
            String fullTypeName = null;
            String arrMemberTagName = null;
            if (selfTypeName != null) {
                fullTypeName = ns_types_name + ":" + selfTypeName;
                arrMemberTagName = selfTypeName;
            } else {
                fullTypeName = xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(arrBaseType);
                arrMemberTagName = (String)XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(arrBaseType);
            }
            complexDataEle.addAttribute(soapFactory.createName(enc_arraytype_str), fullTypeName + "[" + dimensionStr + "]");
            resultEle.addAttribute(soapFactory.createName("href"), "#" + complexDataId);
            if (dimensionCnt >= 2) {
                arrMemberTagName = ejbInfo.getClsWsdlTypeName(subArrStr);
            }
            for (int i = 0; i < upperArrObjAl.size(); ++i) {
                SOAPElement arrMemberEle = null;
                arrMemberEle = complexDataEle.addChildElement(arrMemberTagName);
                this.javaObjToSoap(upperArrObjAl.get(i), arrBaseType, ejbInfo, arrMemberEle, bodyEle, ns_types_name, idCtl);
            }
        }
    }

    public SOAPElement javaObjToSoap(Object obj, String objType, IBOSEJBInfo ejbInfo, SOAPElement resultEle, SOAPBody bodyEle, String ns_types_name, IdController idCtl) throws SOAPandJavaConversionException {
        block39: {
            try {
                SOAPFactory soapFactory = SOAPFactory.newInstance();
                if (obj == null) {
                    resultEle.addAttribute(soapFactory.createName(xsi_nil_str), "1");
                    return resultEle;
                }
                if (XMLandJavaType.JAVA_P_INTEGER_TYPE.equals(objType) || XMLandJavaType.JAVA_INTEGER_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (Integer)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_P_SHORT_TYPE.equals(objType) || XMLandJavaType.JAVA_SHORT_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (Short)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_P_LONG_TYPE.equals(objType) || XMLandJavaType.JAVA_LONG_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (Long)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_P_BYTE_TYPE.equals(objType) || XMLandJavaType.JAVA_BYTE_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (Byte)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_P_FLOAT_TYPE.equals(objType) || XMLandJavaType.JAVA_FLOAT_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + ((Float)obj).floatValue());
                    break block39;
                }
                if (XMLandJavaType.JAVA_P_DOUBLE_TYPE.equals(objType) || XMLandJavaType.JAVA_DOUBLE_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (Double)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_P_BOOLEAN_TYPE.equals(objType) || XMLandJavaType.JAVA_BOOLEAN_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (Boolean)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_STRING_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + (String)obj);
                    break block39;
                }
                if (XMLandJavaType.JAVA_BIGDECIMAL_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + ((BigDecimal)obj).toString());
                    break block39;
                }
                if (XMLandJavaType.JAVA_BIGINTEGER_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode("" + ((BigInteger)obj).toString());
                    break block39;
                }
                if (XMLandJavaType.JAVA_CALENDAR_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode(DateTimeParser.format(((Calendar)obj).getTime()));
                    break block39;
                }
                if (XMLandJavaType.JAVA_DATE_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode(DateTimeParser.format((java.util.Date)obj));
                    break block39;
                }
                if (XMLandJavaType.JAVA_TIME_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode(DateTimeParser.format((Time)obj));
                    break block39;
                }
                if (XMLandJavaType.JAVA_TIMESTAMP_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode(DateTimeParser.format((Timestamp)obj));
                    break block39;
                }
                if (XMLandJavaType.JAVA_SQLDATE_TYPE.equals(objType)) {
                    resultEle.addAttribute(soapFactory.createName(xsi_type_str), xsd_str + XMLandJavaType.JAVA_XML_TYPEMAPPING2.get(objType));
                    resultEle.addTextNode(DateTimeParser.format((Date)obj));
                    break block39;
                }
                if (objType.endsWith("[]")) {
                    try {
                        this.javaObjToSoapArr(obj, objType, ejbInfo, resultEle, bodyEle, ns_types_name, idCtl, soapFactory);
                        break block39;
                    }
                    catch (Throwable e) {
                        throw new SOAPandJavaConversionException(e);
                    }
                }
                String objCollectionArrType = ejbInfo.getObjCollectionArrType(objType);
                if (objCollectionArrType != null) {
                    IObjectCollection objCollection = (IObjectCollection)obj;
                    if (objCollection != null) {
                        IObjectValue[] ovArr = new IObjectValue[objCollection.size()];
                        for (int i = 0; i < objCollection.size(); ++i) {
                            ovArr[i] = objCollection.getObject(i);
                        }
                        return this.javaObjToSoap(ovArr, objCollectionArrType, ejbInfo, resultEle, bodyEle, ns_types_name, idCtl);
                    }
                    return null;
                }
                String[] clsMemberNames = ejbInfo.getClsMemberNames(objType);
                String[] clsMemberTypes = ejbInfo.getClsMemberTypes(objType);
                boolean[] objMemberHasSetMthds = ejbInfo.getClsMemberHasSetMthds(objType);
                String complexDataId = "ID" + idCtl.id++;
                SOAPElement complexDataEle = null;
                complexDataEle = bodyEle.addChildElement(ns_types_name + ":" + ejbInfo.getClsWsdlTypeName(objType));
                complexDataEle.addAttribute(soapFactory.createName("id"), complexDataId);
                complexDataEle.addAttribute(soapFactory.createName(xsi_type_str), ns_types_name + ":" + ejbInfo.getClsWsdlTypeName(objType));
                resultEle.addAttribute(soapFactory.createName("href"), "#" + complexDataId);
                if (this.specialJavaObjToSoap(obj, objType, complexDataEle, ns_types_name, ejbInfo)) {
                    return resultEle;
                }
                for (int i = 0; i < clsMemberNames.length; ++i) {
                    SOAPElement memberEle = complexDataEle.addChildElement(clsMemberNames[i]);
                    Object memberVal = null;
                    if (objMemberHasSetMthds[i] || ClassUtil.isObjectMatchType(clsMemberTypes[i], IObjectCollection.class.getName())) {
                        String getMthdName = "get" + clsMemberNames[i].substring(0, 1).toUpperCase() + clsMemberNames[i].substring(1);
                        try {
                            Method getMthd = obj.getClass().getMethod(getMthdName, new Class[0]);
                            memberVal = getMthd.invoke(obj, new Object[0]);
                        }
                        catch (SecurityException e1) {
                            throw e1;
                        }
                        catch (IllegalArgumentException e1) {
                            throw e1;
                        }
                        catch (NoSuchMethodException e1) {
                            throw e1;
                        }
                        catch (IllegalAccessException e1) {
                            throw e1;
                        }
                        catch (InvocationTargetException e1) {
                            throw e1;
                        }
                    }
                    try {
                        Field memberField = obj.getClass().getField(clsMemberNames[i]);
                        memberVal = memberField.get(obj);
                    }
                    catch (SecurityException e1) {
                        throw e1;
                    }
                    catch (IllegalArgumentException e1) {
                        throw e1;
                    }
                    catch (NoSuchFieldException e1) {
                        throw e1;
                    }
                    catch (IllegalAccessException e1) {
                        throw e1;
                    }
                    this.javaObjToSoap(memberVal, clsMemberTypes[i], ejbInfo, memberEle, bodyEle, ns_types_name, idCtl);
                }
            }
            catch (SOAPException e) {
                throw new SOAPandJavaConversionException(e);
            }
            catch (Throwable t) {
                throw new SOAPandJavaConversionException(t);
            }
        }
        return resultEle;
    }

    public static ArrayList fetchChildElements(SOAPElement soapEle) {
        ArrayList retAl = new ArrayList();
        Iterator it = soapEle.getChildElements();
        while (it.hasNext()) {
            Object tmpObj = it.next();
            if (!(tmpObj instanceof SOAPElement)) continue;
            retAl.add(tmpObj);
        }
        return retAl;
    }
}

