/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.facade.IFacadeCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.service.webservice.tools.BOSWebService_WSDL_Generator;
import com.kingdee.bos.service.webservice.tools.BOSWebService_WebXML_Generator;
import com.kingdee.bos.util.BOSObjectType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.wsdl.WSDLException;
import org.apache.log4j.Logger;

public class BOSWebServiceFileGenerator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.webservice.tools.BOSWebServiceFileGenerator");

    public static void main(String[] args) {
        File path = new File("D:\\eclipse\\runtime-workspace\\ws-test\\tmpTest");
        EntityObjectInfo bizObjInfo = BOSWebServiceFileGenerator.getEntity();
        try {
            BOSWebServiceFileGenerator.genFiles(path, (BusinessObjectInfo)bizObjInfo, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void genFilesBatch(File path, BusinessObjectInfo[] bizObjInfos, String packageName) {
        if (bizObjInfos == null) {
            return;
        }
        for (int i = 0; i < bizObjInfos.length; ++i) {
            BOSWebServiceFileGenerator.genFiles(path, bizObjInfos[i], packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genFiles(File path, BusinessObjectInfo bizObjInfo, String packageName) {
        if (path == null || !path.isDirectory() || !path.exists()) {
            return;
        }
        String dirPathStr = path.getAbsolutePath();
        if (!dirPathStr.endsWith(File.separator)) {
            dirPathStr = dirPathStr + File.separator;
        }
        BOSWebService_WSDL_Generator wsdlGenerator = new BOSWebService_WSDL_Generator();
        if (packageName != null && packageName.trim().length() > 0) {
            wsdlGenerator.getJavaFileGenerator().setPackageName(packageName);
        } else {
            wsdlGenerator.getJavaFileGenerator().setPackageName(bizObjInfo.getPackage());
        }
        String wsdlFileName = "";
        String pkName = bizObjInfo.getPackage();
        for (int i = 0; i < pkName.length(); ++i) {
            wsdlFileName = pkName.charAt(i) == '.' ? wsdlFileName + "_" : wsdlFileName + pkName.charAt(i);
        }
        wsdlFileName = wsdlFileName + "_" + bizObjInfo.getName() + ".wsdl";
        String wsdlFileFullName = dirPathStr + wsdlFileName;
        File wsdlFile = new File(wsdlFileFullName);
        wsdlGenerator.parseAndGen(bizObjInfo);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(wsdlFile);
            wsdlGenerator.printResult(fos);
        }
        catch (FileNotFoundException e) {
            BOSWebServiceFileGenerator.log("can't write file " + wsdlFileFullName, e);
        }
        catch (WSDLException e) {
            BOSWebServiceFileGenerator.log("can't write file " + wsdlFileFullName, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String javaFileFullName = dirPathStr + wsdlGenerator.getJavaFileGenerator().getClassName() + ".java";
        File javaFile = new File(javaFileFullName);
        FileOutputStream fos1 = null;
        try {
            fos1 = new FileOutputStream(javaFile);
            wsdlGenerator.getJavaFileGenerator().printResult(fos1);
        }
        catch (FileNotFoundException e) {
            BOSWebServiceFileGenerator.log("can't write file " + javaFileFullName, e);
        }
        catch (IOException e) {
            BOSWebServiceFileGenerator.log("can't write file " + javaFileFullName, e);
        }
        finally {
            if (fos1 != null) {
                try {
                    fos1.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String xmlFileFullName = dirPathStr + "web.xml";
        File xmlFile = new File(xmlFileFullName);
        FileOutputStream fos2 = null;
        try {
            fos2 = new FileOutputStream(xmlFile);
            fos2.write(BOSWebService_WebXML_Generator.genXMLStr().getBytes());
        }
        catch (FileNotFoundException e) {
            BOSWebServiceFileGenerator.log("can't write file " + xmlFileFullName, e);
        }
        catch (IOException ioe) {
            BOSWebServiceFileGenerator.log("can't write file " + xmlFileFullName, ioe);
        }
        finally {
            if (fos2 != null) {
                try {
                    fos2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static EntityObjectInfo getEntity() {
        EntityObjectInfo entity = null;
        IEntityObjectCtrl ctrl = null;
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"D:\\eclipse\\runtime-workspace\\BosTestSolution\\metadata");
        ContextManager.setContext((Context)ctx);
        try {
            ctrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.ENTITY);
            entity = ctrl.getValue((IMetaDataPK)new MetaDataPK("testpk", "wsdemo"));
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return entity;
    }

    private static FacadeInfo getFacade() {
        FacadeInfo facade = null;
        IFacadeCtrl ctrl = null;
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"D:\\eclipse\\runtime-workspace\\BosTestSolution\\metadata");
        ContextManager.setContext((Context)ctx);
        try {
            ctrl = (IFacadeCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.FACADE);
            facade = ctrl.getValue((IMetaDataPK)new MetaDataPK("testpk", "testFuncEnum"));
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return facade;
    }

    public static BusinessObjectInfo[] getBizObjInfosFromLocal(String path) throws BOSException {
        Vector<Object> bosObjs = new Vector<Object>();
        IEntityObjectCtrl entCtrl = null;
        IFacadeCtrl facCtrl = null;
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)path);
        ContextManager.setContext((Context)ctx);
        ContextManager.getContext().put((Object)"METADATAPATH", (Object)path);
        entCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.ENTITY);
        facCtrl = (IFacadeCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.FACADE);
        EntityObjectCollection entityCol = entCtrl.getCollection();
        for (int i = 0; i < entityCol.size(); ++i) {
            EntityObjectInfo entityInfo = entityCol.get(i);
            bosObjs.add(entityInfo);
        }
        IMetaDataPK[] pks = facCtrl.getPKList();
        for (int i = 0; i < pks.length; ++i) {
            FacadeInfo facadeInfo = facCtrl.getValue(pks[i]);
            bosObjs.add(facadeInfo);
        }
        BusinessObjectInfo[] retArr = new BusinessObjectInfo[bosObjs.size()];
        for (int i = 0; i < bosObjs.size(); ++i) {
            retArr[i] = (BusinessObjectInfo)bosObjs.get(i);
        }
        return retArr;
    }

    private static void log(String s, Throwable t) {
        logger.error((Object)s, t);
    }
}

