/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.tools;

import com.kingdee.bos.dao.IObjectCollection;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClassUtil {
    public static Hashtable getBeanProps(String clsName) {
        Hashtable<String, String> beanPropsInfo = new Hashtable<String, String>();
        try {
            BeanInfo info = Introspector.getBeanInfo(Class.forName(clsName));
            PropertyDescriptor[] propDescs = info.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                if (propDescs[i].getWriteMethod() == null || propDescs[i].getReadMethod() == null) continue;
                beanPropsInfo.put(propDescs[i].getName(), propDescs[i].getPropertyType().getName());
            }
        }
        catch (IntrospectionException iex) {
            return beanPropsInfo;
        }
        catch (ClassNotFoundException cnfe) {
            return beanPropsInfo;
        }
        return beanPropsInfo;
    }

    public static Hashtable getBOSCollectionLinkProps(String clsName) {
        Hashtable<String, String> beanPropsInfo = new Hashtable<String, String>();
        try {
            BeanInfo info = Introspector.getBeanInfo(Class.forName(clsName));
            PropertyDescriptor[] propDescs = info.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                if (propDescs[i].getReadMethod() == null || !ClassUtil.isObjectMatchType(propDescs[i].getPropertyType(), IObjectCollection.class.getName())) continue;
                beanPropsInfo.put(propDescs[i].getName(), propDescs[i].getPropertyType().getName());
            }
        }
        catch (IntrospectionException iex) {
            return beanPropsInfo;
        }
        catch (ClassNotFoundException cnfe) {
            return beanPropsInfo;
        }
        return beanPropsInfo;
    }

    public static Hashtable getObjPropsExcludeBean(String clsName) {
        Hashtable beanPropsInfo = ClassUtil.getBeanProps(clsName);
        Hashtable<String, String> objPropsExcludeBean = new Hashtable<String, String>();
        Class<?> clsObj = null;
        try {
            clsObj = Class.forName(clsName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Field[] flds = clsObj.getDeclaredFields();
        for (int i = 0; i < flds.length; ++i) {
            if (!Modifier.isPublic(flds[i].getModifiers()) || Modifier.isTransient(flds[i].getModifiers()) || Modifier.isStatic(flds[i].getModifiers()) || Modifier.isFinal(flds[i].getModifiers()) || beanPropsInfo.get(flds[i].getName()) != null) continue;
            objPropsExcludeBean.put(flds[i].getName(), flds[i].getType().getName());
        }
        return objPropsExcludeBean;
    }

    public static boolean isObjectMatchType(Class clsObj, String type) {
        Class supClsObj;
        if (clsObj == null || type == null) {
            return false;
        }
        if (clsObj.getName().equals(type)) {
            return true;
        }
        if (!clsObj.isInterface() && (supClsObj = clsObj.getSuperclass()) != null && ClassUtil.isObjectMatchType(supClsObj, type)) {
            return true;
        }
        Class<?>[] intfs = clsObj.getInterfaces();
        if (intfs != null) {
            for (int i = 0; i < intfs.length; ++i) {
                if (!ClassUtil.isObjectMatchType(intfs[i], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isObjectMatchType(String objTypeStr, String type) {
        if (objTypeStr == null || type == null) {
            return false;
        }
        Class<?> clsObj = null;
        try {
            clsObj = Class.forName(objTypeStr);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return ClassUtil.isObjectMatchType(clsObj, type);
    }

    public static boolean isObjectMatchType(Class clsObj, Class typeObj) {
        Class supClsObj;
        if (clsObj == null || typeObj == null) {
            return false;
        }
        if (clsObj.getName().equals(typeObj.getName())) {
            return true;
        }
        if (!clsObj.isInterface() && (supClsObj = clsObj.getSuperclass()) != null && ClassUtil.isObjectMatchType(supClsObj, typeObj)) {
            return true;
        }
        Class<?>[] intfs = clsObj.getInterfaces();
        if (intfs != null) {
            for (int i = 0; i < intfs.length; ++i) {
                if (!ClassUtil.isObjectMatchType(intfs[i], typeObj)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getStrAfterDot(String inStr) {
        if (inStr == null) {
            return null;
        }
        int dotIdx = inStr.lastIndexOf(".");
        if (dotIdx < 0) {
            return inStr;
        }
        return inStr.substring(dotIdx + 1);
    }

    public static void main(String[] args) throws Exception {
        String string;
        Hashtable props = ClassUtil.getObjPropsExcludeBean("atest.DataStruc");
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            string = (String)keys.nextElement();
        }
        props = ClassUtil.getBeanProps("atest.DataStruc");
        keys = props.keys();
        while (keys.hasMoreElements()) {
            string = (String)keys.nextElement();
        }
    }
}

