/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.webservice.tools;

import com.kingdee.bos.service.webservice.tools.ElementList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static void printDOMTree(Node node) {
        System.out.print(XMLUtil.getDOMTreeStr(node));
    }

    public static String getDOMTreeStr(Node node) {
        return XMLUtil.getDOMTreeStr(node, "  ", 0);
    }

    public static String getDOMTreeStr(Node node, String indent, int level) {
        if (level < 0) {
            level = 0;
        }
        String retStr = "";
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                retStr = retStr + "<?xml version=\"1.0\" ?>\n";
                retStr = retStr + XMLUtil.getDOMTreeStr(((Document)node).getDocumentElement(), indent, level + 1);
                break;
            }
            case 1: {
                retStr = retStr + "\n" + XMLUtil.repeatStr(indent, level) + "<" + node.getNodeName();
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    retStr = retStr + " " + attr.getNodeName() + "=\"" + XMLUtil.convertXMLstr(attr.getNodeValue()) + "\"";
                }
                retStr = retStr + ">";
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    retStr = retStr + XMLUtil.getDOMTreeStr(children.item(i), indent, level + 1);
                }
                break;
            }
            case 5: {
                retStr = retStr + "&" + node.getNodeName() + ";";
                break;
            }
            case 4: {
                retStr = retStr + "<![CDATA[" + XMLUtil.convertCDATAstr(node.getNodeValue()) + "]]>";
                break;
            }
            case 3: {
                retStr = retStr + XMLUtil.convertXMLstr(node.getNodeValue());
                break;
            }
            case 7: {
                String data = XMLUtil.convertXMLstr(node.getNodeValue());
                retStr = retStr + "<?" + node.getNodeName() + " " + data + "?>";
            }
        }
        if (type == 1) {
            retStr = retStr + "\n" + XMLUtil.repeatStr(indent, level) + "</" + node.getNodeName() + ">";
        }
        return retStr;
    }

    private static String repeatStr(String str, int time) {
        String retStr = "";
        for (int i = 0; i < time; ++i) {
            retStr = retStr + str;
        }
        return retStr;
    }

    public static String getElementTreeStruc(Element ele, String indent) {
        if (ele == null) {
            return null;
        }
        int totalLevel = 0;
        Node parentNode = ele;
        while ((parentNode = parentNode.getParentNode()) != null && parentNode instanceof Element) {
            ++totalLevel;
        }
        String childsStr = "";
        NodeList childs = ele.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!(node instanceof Element)) continue;
            if (childsStr.length() > 0) {
                childsStr = childsStr + "\n";
            }
            childsStr = childsStr + XMLUtil.repeatStr(indent, totalLevel + 1) + "<" + ((Element)node).getTagName() + " ...>\n";
            childsStr = childsStr + XMLUtil.repeatStr(indent, totalLevel + 2) + "...\n";
            childsStr = childsStr + XMLUtil.repeatStr(indent, totalLevel + 1) + "</" + ((Element)node).getTagName() + ">";
        }
        String retStr = childsStr;
        Element currEle = ele;
        for (int i = 0; i <= totalLevel; ++i) {
            String tagName = currEle.getTagName();
            NamedNodeMap nnm = currEle.getAttributes();
            String beginStr = "<" + tagName;
            for (int k = 0; k < nnm.getLength(); ++k) {
                Attr attr = (Attr)nnm.item(k);
                beginStr = beginStr + " " + attr.getName() + "=\"" + XMLUtil.convertXMLstr(attr.getNodeValue()) + "\"";
            }
            beginStr = beginStr + ">";
            String endStr = "</" + tagName + ">";
            retStr = XMLUtil.repeatStr(indent, totalLevel - i) + beginStr + "\n" + (i == 0 ? XMLUtil.repeatStr(indent, totalLevel - i) + XMLUtil.repeatStr("^", beginStr.length()) + "\n" : "") + (i > 0 ? XMLUtil.repeatStr(indent, totalLevel - i + 1) + "...\n" : "") + (retStr.length() > 0 ? retStr + "\n" : "") + (i > 0 ? XMLUtil.repeatStr(indent, totalLevel - i + 1) + "...\n" : "") + XMLUtil.repeatStr(indent, totalLevel - i) + endStr;
            if (!(currEle.getParentNode() instanceof Element)) continue;
            currEle = (Element)currEle.getParentNode();
        }
        return retStr;
    }

    public static ElementList getChildElements(Element ele) {
        if (ele == null) {
            return null;
        }
        ElementList retEL = new ElementList();
        NodeList childs = ele.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (childs.item(i).getNodeType() != 1) continue;
            retEL.add((Element)childs.item(i));
        }
        return retEL;
    }

    public static ElementList getChildElementsByTagName(Element ele, String tagName) {
        if (ele == null || tagName == null) {
            return null;
        }
        ElementList retEL = new ElementList();
        ElementList el = XMLUtil.getChildElements(ele);
        for (int i = 0; i < el.size(); ++i) {
            if (!el.elementAt(i).getTagName().equals(tagName)) continue;
            retEL.add(el.elementAt(i));
        }
        return retEL;
    }

    public static void copyElements(Element sourceEle, Element targetEle, boolean includeAttr) {
        if (sourceEle == null || targetEle == null) {
            return;
        }
        if (includeAttr) {
            XMLUtil.copyAttribute(sourceEle, targetEle);
        }
        XMLUtil.copyChildElements(sourceEle, targetEle);
    }

    private static void copyChildElements(Element sourceEle, Element targetEle) {
        ElementList childs = XMLUtil.getChildElements(sourceEle);
        for (int i = 0; i < childs.size(); ++i) {
            Element tmpEle = childs.elementAt(i);
            Element newEle = targetEle.getOwnerDocument().createElement(tmpEle.getTagName());
            XMLUtil.copyAttribute(tmpEle, newEle);
            targetEle.appendChild(newEle);
            XMLUtil.copyChildElements(tmpEle, newEle);
        }
    }

    private static void copyAttribute(Element sourceEle, Element targetEle) {
        if (sourceEle == null || targetEle == null) {
            return;
        }
        NamedNodeMap nnm = sourceEle.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr item = (Attr)nnm.item(i);
            targetEle.setAttribute(item.getName(), item.getValue());
        }
    }

    public static void removeAllChilds(Element ele, String tagName) {
        ElementList childs = null;
        childs = tagName == null ? XMLUtil.getChildElements(ele) : XMLUtil.getChildElementsByTagName(ele, tagName);
        for (int i = 0; i < childs.size(); ++i) {
            ele.removeChild(childs.elementAt(i));
        }
    }

    public static Element createFamilyElement(String tagName, Element srcEle) {
        if (tagName == null || srcEle == null) {
            return null;
        }
        Element tmpEle = srcEle.getOwnerDocument().createElement(tagName);
        return tmpEle;
    }

    public static String convertXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer("");
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                output.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String convertCDATAstr(String input) {
        if (input == null) {
            return null;
        }
        int index = -1;
        while ((index = input.indexOf("]]>")) >= 0) {
            input = input.substring(0, index + 2) + "&gt;" + input.substring(index + 3);
        }
        return input;
    }
}

