/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup;

import com.kingdee.eas.client.startup.JnlpFileDeleteUtil;
import com.kingdee.eas.client.startup.classloader.SmartClassLoader;
import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.precess.UpdateListener;
import com.kingdee.eas.client.startup.util.CostTimeUtil;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ClientLauncher {
    private static final Logger logger = ClientStartLogger.getLogger();

    public static void launch() {
        logger.info((Object)"\u6b63\u5728\u542f\u52a8EAS\u5ba2\u6237\u7aef....");
        UpdateListener.startStep("\u542f\u52a8EAS\u5ba2\u6237\u7aef");
        UpdateListener.setProgressTip("\u6b63\u5728\u542f\u52a8EAS\u5ba2\u6237\u7aef....");
        try {
            CostTimeUtil costTimeUtil = CostTimeUtil.createInstance();
            SmartClassLoader applicationClassLoader = (SmartClassLoader)ClassLoader.getSystemClassLoader();
            Thread.currentThread().setContextClassLoader(applicationClassLoader);
            Class appClass = applicationClassLoader.loadClass(ClientConfigUtil.getApplicationClassname());
            long loadConfigStart = System.currentTimeMillis();
            Class loginHelpClass = applicationClassLoader.loadClass("com.kingdee.eas.base.uiframe.client.UIConfig");
            Method initTempUrl = loginHelpClass.getMethod("setTempUrl", String.class);
            initTempUrl.invoke(null, System.getProperty("appserver"));
            long loadConfigCost = System.currentTimeMillis() - loadConfigStart;
            logger.info((Object)("load config.xml spent :" + loadConfigCost + " ms."));
            Method initMethod = appClass.getMethod("initData", null);
            initMethod.invoke(null, null);
            long loginFrameStart = System.currentTimeMillis();
            JFrame loginFrame = (JFrame)appClass.newInstance();
            SwingUtilities.updateComponentTreeUI(loginFrame);
            Method showMethod = appClass.getMethod("show", null);
            showMethod.invoke((Object)loginFrame, null);
            UpdateListener.stopStep();
            long loginFrameCost = System.currentTimeMillis() - loginFrameStart;
            logger.info((Object)(" new loginFrame and show spent :" + loginFrameCost + " ms.start time:" + loginFrameStart));
            Method startMetaLoadThread = appClass.getMethod("startMetaLoadThread", null);
            startMetaLoadThread.invoke((Object)loginFrame, null);
            logger.info((Object)("\u542f\u52a8\u5ba2\u6237\u7aef\u5b8c\u6210\uff08\u6253\u5f00\u767b\u5f55\u754c\u9762\uff09\u7528\u65f6\uff1a " + costTimeUtil.costBySecond() + "\u79d2" + "(" + costTimeUtil.costByMicrosecond() + "ms)"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            EASClientException ex = new EASClientException("EAS\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25", t);
            logger.error((Object)ex.getSolution(), (Throwable)ex);
            JnlpFileDeleteUtil.delete();
            throw ex;
        }
    }
}

