/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup;

import com.kingdee.eas.client.startup.ClientLauncher;
import com.kingdee.eas.client.startup.ClientUpdater;
import com.kingdee.eas.client.startup.JnlpFileDeleteUtil;
import com.kingdee.eas.client.startup.MessageListener;
import com.kingdee.eas.client.startup.RollFileOuputStream;
import com.kingdee.eas.client.startup.StepListener;
import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.precess.UpdateListener;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import java.io.BufferedOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EASClientStarter {
    private static EASClientStarter instance;
    private boolean updateSuccess;
    private Map<EASClientFile, List<String>> updateFailedFiles = new HashMap<EASClientFile, List<String>>();

    public static EASClientStarter getInstance(String easHome, String updateServerAddr, String easServer, String ondemandupdate, StepListener stepListenerImpl, MessageListener progressListener) {
        if (null == instance) {
            instance = new EASClientStarter(easHome, updateServerAddr, easServer, ondemandupdate, stepListenerImpl, progressListener);
        }
        return instance;
    }

    private EASClientStarter(String easHome, String updateServerAddr, String easServer, String ondemandupdate, StepListener stepListenerImpl, MessageListener progressListener) {
        ClientConfigUtil.init(easHome, updateServerAddr, easServer, ondemandupdate);
        UpdateListener.init(stepListenerImpl, progressListener);
    }

    public Map<EASClientFile, List<String>> update() {
        this.updateFailedFiles = ClientUpdater.update();
        if (!this.updateFailedFiles.isEmpty()) {
            JnlpFileDeleteUtil.delete();
        } else {
            this.updateSuccess = true;
        }
        return this.updateFailedFiles;
    }

    public void launchClient() {
        if (!this.updateSuccess) {
            if (this.updateFailedFiles.isEmpty()) {
                throw new EASClientException("\u5ba2\u6237\u7aef\u66f4\u65b0\u5f02\u5e38\uff0c\u4e0d\u80fd\u542f\u52a8\u5ba2\u6237\u7aef\u3002");
            }
            throw new EASClientException("\u5ba2\u6237\u7aef\u66f4\u65b0\u5931\u8d25\uff0c\u4e0d\u80fd\u542f\u52a8\u5ba2\u6237\u7aef\u3002\u66f4\u65b0\u5931\u8d25\u7684\u6587\u4ef6:" + this.updateFailedFiles.keySet());
        }
        ClientLauncher.launch();
    }

    private static void redirectIO2ClientLogFile() {
        if (System.getProperty("redirectjvmio", "true").equalsIgnoreCase("true")) {
            try {
                String jvmStdFile = System.getProperty("jvmStd", "../logs/client.log");
                RollFileOuputStream fileOut = new RollFileOuputStream(jvmStdFile);
                System.setErr(new PrintStream(new BufferedOutputStream(fileOut, 128), true));
                System.setOut(new PrintStream(new BufferedOutputStream(fileOut, 128), true));
            }
            catch (Throwable e) {
                throw new EASClientException("\u521b\u5efa\u5ba2\u6237\u7aef\u65e5\u5fd7client.log\u51fa\u9519", e);
            }
        }
    }

    static {
        EASClientStarter.redirectIO2ClientLogFile();
    }
}

