/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.classloader;

import com.kingdee.eas.client.startup.classloader.ISO8601DateFormat;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import java.util.Date;
import org.apache.log4j.Logger;

class ConsoleLogger {
    private static final Logger logger = ClientStartLogger.getLogger();
    private static boolean debug = false;

    ConsoleLogger() {
    }

    private static String getTimeStamp() {
        return "[" + new ISO8601DateFormat().format(new Date()) + "] ";
    }

    private static void info(String msg) {
        String prefix = "[CL_INFO] ";
        System.out.println(prefix + ConsoleLogger.getTimeStamp() + msg);
        if (null != logger) {
            logger.info((Object)(prefix + msg));
        }
    }

    public static void error(String msg) {
        String prefix = "[CL_ERROR] ";
        System.out.println(prefix + ConsoleLogger.getTimeStamp() + msg);
        if (null != logger) {
            logger.error((Object)(prefix + msg));
        }
    }

    public static void error(String msg, Throwable t) {
        String prefix = "[CL_ERROR] ";
        System.out.println(prefix + ConsoleLogger.getTimeStamp() + msg);
        t.printStackTrace();
        if (null != logger) {
            logger.error((Object)(prefix + msg), t);
        }
    }

    public static void debug(String msg) {
        String prefix = "[CL_DEBUG] ";
        if (!debug) {
            return;
        }
        System.out.println(prefix + ConsoleLogger.getTimeStamp() + msg);
        if (null != logger) {
            logger.info((Object)(prefix + msg));
        }
    }

    public static void warn(String msg) {
        String prefix = "[CL_WARN] ";
        System.out.println(prefix + ConsoleLogger.getTimeStamp() + msg);
        if (null != logger) {
            logger.warn((Object)(prefix + msg));
        }
    }

    static {
        debug = Boolean.getBoolean("SmartClassLoader.debug");
    }
}

