/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class ClientStartLogger {
    public static final String FILE_SEPARATOR = File.separator;
    protected static Logger logger;

    private static Logger creatLogger() {
        Logger logger = Logger.getLogger((String)"client_start");
        logger.setLevel(Logger.getRootLogger().getLevel());
        logger.setAdditivity(false);
        return logger;
    }

    private static PatternLayout formatLayout() {
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("[%d %6p at (%30F:%3L)] %m%n");
        return layout;
    }

    private static ConsoleAppender initConsoleOut(PatternLayout layout) {
        ConsoleAppender stdout = new ConsoleAppender();
        stdout.setLayout((Layout)layout);
        stdout.activateOptions();
        return stdout;
    }

    private static RollingFileAppender initFileOut(PatternLayout layout) {
        String LOG_ROOT = ".\\..\\logs\\client_start\\";
        SimpleDateFormat dirSdf = new SimpleDateFormat("yyyy-MM-dd");
        String dirTimePart = dirSdf.format(new Date());
        String dirPath = ".\\..\\logs\\client_start\\" + dirTimePart;
        SimpleDateFormat fileSdf = new SimpleDateFormat("_yyyy-MM-dd_HH_mm_ss");
        String fileTimePart = fileSdf.format(new Date());
        String fileName = "client_start" + fileTimePart + ".log";
        String filePath = dirPath + "\\" + fileName;
        ClientStartLogger.makedir(filePath);
        RollingFileAppender daily = new RollingFileAppender();
        daily.setLayout((Layout)layout);
        daily.setFile(filePath);
        daily.setEncoding("GBK");
        daily.setAppend(true);
        daily.activateOptions();
        return daily;
    }

    private static void makedir(String fileName) {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    private static void init() {
        logger = ClientStartLogger.creatLogger();
        PatternLayout layout = ClientStartLogger.formatLayout();
        RollingFileAppender fileOut = ClientStartLogger.initFileOut(layout);
        logger.addAppender((Appender)fileOut);
        ConsoleAppender stdout = ClientStartLogger.initConsoleOut(layout);
        logger.addAppender((Appender)stdout);
    }

    public static Logger getLogger() {
        if (null == logger) {
            ClientStartLogger.init();
        }
        return logger;
    }

    public static void main(String[] args) {
        Logger logger = ClientStartLogger.getLogger();
        logger.info((Object)"hello,world2!");
        logger.info((Object)"hello,world!");
        System.out.println(FILE_SEPARATOR);
    }
}

