/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.precess.PrecessCalcHelper;
import com.kingdee.eas.client.startup.precess.UpdateListener;
import com.kingdee.eas.client.startup.update.check.CreateJNLPResourceHelper;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.util.CostTimeUtil;
import com.kingdee.eas.client.startup.util.FileUtil;
import com.twmacinta.util.MD5;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJNLPResource {
    private static final Logger logger = ClientStartLogger.getLogger();

    private static void scanFileLists(File preFile, File file, String extName, List<File> fileList) {
        String path = file.getPath();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                CreateJNLPResource.scanFileLists(preFile, files[i], extName, fileList);
            }
        } else {
            if (CreateJNLPResource.isPathFilted(path, extName) || path.endsWith(".dl") || path.endsWith(".info")) {
                return;
            }
            fileList.add(file);
        }
    }

    private static void createLocalJNLPResource(File baseDir, String traceFlagFile, String jnlpUrlStr, String pathFiltedStr, Collection<File> relativeResxPaths) {
        String logTitle = "[\u68c0\u6d4b\u66f4\u65b0]";
        ArrayList<File> fileList = new ArrayList<File>();
        logger.info((Object)(logTitle + "\u672c\u5730\u9700\u8981\u68c0\u6d4b\u66f4\u65b0\u7684\u76ee\u5f55\u5171\u6709" + relativeResxPaths.size() + "\u4e2a\uff1a" + relativeResxPaths));
        for (File file : relativeResxPaths) {
            CreateJNLPResource.scanFileLists(baseDir, file, pathFiltedStr + ",/" + traceFlagFile + ",/" + jnlpUrlStr, fileList);
        }
        logger.info((Object)(logTitle + "\u672c\u5730\u9700\u8981\u68c0\u6d4b\u66f4\u65b0\u7684\u6587\u4ef6\u5171\u6709" + fileList.size() + "\u4e2a"));
        UpdateListener.setProgressDetail("\u5171\u6709" + fileList.size() + "\u4e2a\u6587\u4ef6\u9700\u8981\u68c0\u6d4b");
        CostTimeUtil calculator = CostTimeUtil.createInstance();
        int maximum = fileList.size();
        StringBuffer sbfile = new StringBuffer();
        int progressValue = 0;
        for (File file : fileList) {
            String filePath = FileUtil.computeRelativePath(baseDir, file);
            UpdateListener.setProgressTip("\u8fdb\u5ea6" + PrecessCalcHelper.calcProcess(progressValue, maximum) + "%(" + progressValue + "/" + maximum + ")\r\n\u68c0\u6d4b" + filePath);
            String md5 = null;
            try {
                md5 = MD5.asHex(MD5.getHash(file));
            }
            catch (IOException e) {
                throw new EASClientException("\u8ba1\u7b97\u6587\u4ef6" + file.getPath() + "\u7684MD5\u503c\u51fa\u9519", e);
            }
            String md5New = "";
            sbfile.append("<file ");
            sbfile.append(" md5Version=\"").append(md5).append("\"");
            sbfile.append(" md5VersionNew=\"").append(md5New).append("\"");
            sbfile.append(" HREF=\"").append(filePath).append("\"/>\r\n");
            ++progressValue;
        }
        StringBuffer logText = new StringBuffer();
        logText.append(logTitle);
        logText.append("\u8ba1\u7b97" + fileList.size() + "\u4e2a\u6587\u4ef6\u7684MD5\u503c");
        logText.append("\uff0c\u5171\u8017\u65f6" + calculator.costBySecond() + "\u79d2");
        if (fileList.size() != 0) {
            logText.append("\uff0c\u5e73\u5747\u6bcf\u4e2a\u6587\u4ef6\u8017\u65f6" + calculator.costByMicrosecond() / (long)fileList.size() + "ms");
        }
        logger.info((Object)logText.toString());
        UpdateListener.setProgressTip("\u8fdb\u5ea6" + PrecessCalcHelper.calcProcess(progressValue, maximum) + "%(" + progressValue + "/" + maximum + "),\u5b8c\u6210");
        StringBuffer sb = new StringBuffer("");
        long createTime = System.currentTimeMillis();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("<jnlp LASTMODIFIED=\"").append(createTime).append("\"");
        sb.append(" SPEC=\"1.0+\">");
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append("<resources>");
        sb.append("\r\n");
        sb.append(sbfile);
        sb.append("\r\n");
        sb.append("</resources>");
        sb.append("\r\n");
        sb.append("</jnlp>");
        sb.append("\r\n");
        CreateJNLPResource.createEasJnlpWithUTF8(sb, jnlpUrlStr);
    }

    private static boolean isPathFilted(String file, String pathFiltedStr) {
        file = file.replace("\\", "/");
        if (pathFiltedStr != null && file != null && !"".equals(pathFiltedStr)) {
            if (pathFiltedStr.indexOf(44) > -1) {
                String[] paths = pathFiltedStr.split(",");
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i] == null || "".equals(paths[i]) || file.toLowerCase().indexOf(paths[i].toLowerCase()) <= -1) continue;
                    return true;
                }
            } else if (file.toLowerCase().indexOf(pathFiltedStr.toLowerCase()) > -1) {
                return true;
            }
        }
        return false;
    }

    public static String store(String jnlpFilename, List<EASClientFile> cacheEntries) {
        StringBuffer sb = new StringBuffer();
        String jnlpHeader = CreateJNLPResource.appendHeader();
        sb.append(jnlpHeader);
        String jnlpResxs = CreateJNLPResource.appendResxsNodeList(cacheEntries);
        sb.append(jnlpResxs);
        String jnlpTail = CreateJNLPResource.appendTail();
        sb.append(jnlpTail);
        String jnlpFileName = CreateJNLPResource.createEasJnlpWithUTF8(sb, jnlpFilename);
        return jnlpFileName;
    }

    private static String createEasJnlpWithUTF8(StringBuffer sb, String jnlpFilename) {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        try {
            File fl = new File(baseDir, jnlpFilename);
            if (!fl.exists()) {
                fl.createNewFile();
            }
            FileOutputStream fileos = new FileOutputStream(fl);
            String charset = "UTF-8";
            byte[] outBytes = sb.toString().getBytes(charset);
            int bufSize = 4096;
            int start = 0;
            int len = bufSize;
            int i = 1;
            while (start < outBytes.length) {
                if (start + len > outBytes.length) {
                    len = outBytes.length - start;
                }
                fileos.write(outBytes, start, len);
                start = bufSize * (++i - 1);
            }
            fileos.flush();
            fileos.close();
        }
        catch (IOException e) {
            throw new EASClientException("\u4fdd\u5b58" + jnlpFilename + "\u6587\u4ef6\u51fa\u9519", e);
        }
        return jnlpFilename;
    }

    private static String appendResxsNodeList(List<EASClientFile> cacheEntries) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<resources>\r\n");
        for (EASClientFile entry : cacheEntries) {
            sb.append(CreateJNLPResource.appendNode(entry));
        }
        sb.append("</resources>\r\n");
        return sb.toString();
    }

    private static String appendNode(EASClientFile entry) {
        StringBuffer sb = new StringBuffer();
        sb.append("<file ");
        sb.append("md5Version=\"");
        sb.append(entry.getMd5Version());
        sb.append("\" ");
        sb.append("md5VersionNew=\"");
        sb.append(entry.getMd5VersionNew());
        sb.append("\" ");
        sb.append("href=\"");
        sb.append(entry.getPath());
        sb.append("\" ");
        sb.append("/>\r\n");
        return sb.toString();
    }

    private static String appendTail() {
        return "</jnlp>";
    }

    private static String appendHeader() {
        StringBuffer sb = new StringBuffer("");
        long createTime = System.currentTimeMillis();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("<jnlp LASTMODIFIED=\"").append(createTime).append("\" SPEC=\"1.0+\">\r\n");
        return sb.toString();
    }

    public static void createLocalJNLPResource(File baseDir, String traceFileName, String jnlpFullURL, String resItemsExcluded, String resPaths) {
        logger.info((Object)("[\u68c0\u6d4b\u66f4\u65b0]\u670d\u52a1\u7aef\u914d\u7f6e\u6307\u5b9a\u7684\u76ee\u5f55:" + resPaths));
        String[] resPathArray = resPaths.split(",");
        Collection<File> files = CreateJNLPResourceHelper.getExistLocalFiles(baseDir, resPathArray);
        logger.info((Object)("[\u68c0\u6d4b\u66f4\u65b0]\u672c\u5730\u5b58\u5728\u7684\u76ee\u5f55\u548c\u6587\u4ef6\u6709" + files.size() + "\u4e2a:" + files));
        Collection<File> relativeResxPaths = CreateJNLPResourceHelper.filtSubFiles(files);
        logger.info((Object)("[\u68c0\u6d4b\u66f4\u65b0]\u672c\u5730\u5b58\u5728\u5e76\u4e14\u53bb\u6389\u5b50\u6587\u4ef6\u5939\u7684\u76ee\u5f55\u6709" + relativeResxPaths.size() + "\u4e2a:" + relativeResxPaths));
        CreateJNLPResource.createLocalJNLPResource(baseDir, traceFileName, jnlpFullURL, resItemsExcluded, relativeResxPaths);
    }
}

