/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ResourceVerInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ResourceVerUtil {
    private static final Logger logger = ClientStartLogger.getLogger();
    public static final String Jar_NAME = "jarName";
    public static final String Last_Modify = "lastModify";
    public static final String MD5_Value = "md5";

    public static void save(EASClientFile jarInfo) {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File localDir = new File(baseDir.toString() + "/cache/");
        Properties prop = ResourceVerUtil.toProp(jarInfo);
        int index = jarInfo.getPath().lastIndexOf("/");
        String cacheFileName = jarInfo.getPath().substring(index);
        ResourceVerUtil.storeJarCacheFiles(localDir, prop, cacheFileName);
    }

    public static Properties toProp(EASClientFile jarInfo) {
        Properties properties = new Properties();
        properties.setProperty(Jar_NAME, jarInfo.getPath().toString());
        properties.setProperty(MD5_Value, jarInfo.getMd5Version() + "," + jarInfo.getMd5VersionNew());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeJarCacheFiles(File baseDir, Properties properties, String cacheFileName) {
        if (properties == null) {
            throw new NullPointerException();
        }
        String traceFile = cacheFileName + ".trace";
        File updateFile = new File(baseDir, traceFile);
        try {
            if (updateFile.exists()) {
                updateFile.delete();
            }
            updateFile.createNewFile();
            File file = updateFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (Throwable t) {
            throw new EASClientException("\u521b\u5efa\u6587\u4ef6" + updateFile.getAbsolutePath() + "\u51fa\u9519", t);
        }
    }

    public static ResourceVerInfo read(File updateTraceFile) {
        String md5AndMd5New;
        Properties properties = ResourceVerUtil.readcacheFile(updateTraceFile);
        String herf = properties.getProperty(Jar_NAME);
        String md5 = md5AndMd5New = properties.getProperty(MD5_Value);
        String md5New = md5AndMd5New;
        if (md5AndMd5New != null && md5AndMd5New.indexOf(",") > 0) {
            md5 = md5AndMd5New.substring(0, md5AndMd5New.indexOf(","));
            md5New = md5AndMd5New.substring(md5AndMd5New.indexOf(",") + 1);
        }
        ResourceVerInfo info = new ResourceVerInfo();
        info.setHerf(herf);
        info.setMd5(md5);
        info.setMd5New(md5New);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readcacheFile(File updateTraceFile) {
        Properties properties = new Properties();
        if (updateTraceFile.exists()) {
            try {
                FileInputStream inputStream = null;
                File file = updateTraceFile;
                synchronized (file) {
                    inputStream = new FileInputStream(updateTraceFile);
                }
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                throw new EASClientException("\u8bfb\u53d6\u6587\u4ef6" + updateTraceFile.getAbsolutePath() + "\u51fa\u9519", e);
            }
        }
        return properties;
    }

    public static List readAll() {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File cacheStateBaseDir = new File(baseDir, "cache");
        ArrayList<ResourceVerInfo> list = new ArrayList<ResourceVerInfo>();
        File[] cacheFile = cacheStateBaseDir.listFiles();
        for (int i = 0; i < cacheFile.length; ++i) {
            ResourceVerInfo resVerINfo;
            File cacheTrace = cacheFile[i];
            if (!cacheTrace.getName().endsWith(".trace") || (resVerINfo = ResourceVerUtil.read(cacheTrace)).getHerf() == null || resVerINfo.getMd5() == null) continue;
            list.add(resVerINfo);
            cacheTrace.delete();
        }
        return list;
    }
}

