/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download;

import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.download.DownloadResult;
import com.kingdee.eas.client.startup.update.download.IEasClientDownloader;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadTask;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpSiteInfo;
import com.kingdee.eas.client.startup.util.StringUtil;
import com.kingdee.eas.client.startup.util.URLUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasClientDownloaderHttpImpl
implements IEasClientDownloader {
    private static final Logger logger = ClientStartLogger.getLogger();
    private static EasClientDownloaderHttpImpl downloader = null;
    private static int urlConnCount = 0;
    private static Map md5Version = new HashMap();
    private static String isSaveDlFile = null;

    private EasClientDownloaderHttpImpl() {
        System.setProperty("http.keepAlive", "true");
    }

    public static EasClientDownloaderHttpImpl getInstance() {
        if (downloader == null) {
            downloader = new EasClientDownloaderHttpImpl();
        }
        return downloader;
    }

    @Override
    public DownloadResult downloadFiles(HttpSiteInfo siteInfo, File rootPath, List<HttpFileInfo> filesToDownload) {
        try {
            DownloadTask task = new DownloadTask(siteInfo, rootPath, filesToDownload);
            task.start();
            Map<HttpFileInfo, String> failedFiles = task.getDownloadFailedFiles();
            List<HttpFileInfo> sucessedFiles = task.getDownloadSucessedFiles();
            DownloadResult result = new DownloadResult(failedFiles, sucessedFiles);
            return result;
        }
        catch (Throwable t) {
            throw EASClientException.convert(t);
        }
    }

    @Override
    public int getUrlConnCount() {
        return urlConnCount;
    }

    public void clearUrlConnCount() {
        urlConnCount = 0;
    }

    public void setIsSaveDlFile(String isSaveDlFile) {
        EasClientDownloaderHttpImpl.isSaveDlFile = isSaveDlFile;
    }

    public static String getIsSaveDlFile() {
        return isSaveDlFile;
    }

    public void setMD5Version(Map md5Version) {
        EasClientDownloaderHttpImpl.md5Version = md5Version;
    }

    @Override
    public void downloadFile(URL codebase, URL fileURL, File rootPath) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, URL> fileHash = new HashMap<String, URL>();
        try {
            URI serverURI = new URI(codebase.toString());
            HttpSiteInfo siteInfo = new HttpSiteInfo(serverURI.getScheme(), serverURI.getHost(), serverURI.getPort(), serverURI.getPath());
            ArrayList<HttpFileInfo> filesToDownload = new ArrayList<HttpFileInfo>();
            String fileName = URLUtil.getRelativePath(codebase, fileURL);
            String version = (String)md5Version.get(fileName);
            String query = fileURL.getQuery();
            String downloadAddress = fileName;
            if (!StringUtil.isEmptyValue(query)) {
                downloadAddress = fileName + "?" + query;
            }
            HttpFileInfo info = new HttpFileInfo(downloadAddress, fileName, version, fileName);
            filesToDownload.add(info);
            fileHash.put(fileName, fileURL);
            DownloadTask task = new DownloadTask(siteInfo, rootPath, filesToDownload);
            task.start();
            Map<HttpFileInfo, String> failedList = task.getDownloadFailedFiles();
            for (int i = 0; i < failedList.size(); ++i) {
                URL resourceFail = (URL)fileHash.get(((HttpFileInfo)((Object)failedList.get(i))).getSavePath());
                hashMap.put(resourceFail.toString(), "");
            }
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }

    @Override
    public void downloadFile(String downloadAddress, File file) {
        HashMap hashMap = new HashMap();
        HashMap fileHash = new HashMap();
        try {
            URI serverURI = new URI(downloadAddress);
            HttpSiteInfo siteInfo = new HttpSiteInfo(serverURI.getScheme(), serverURI.getHost(), serverURI.getPort(), "");
            String query = serverURI.getQuery();
            query = StringUtil.isEmptyValue(query) ? "" : "?" + query;
            HttpFileInfo info = new HttpFileInfo(serverURI.getPath() + query, file.getName(), "", file.getName());
            ArrayList<HttpFileInfo> filesToDownload = new ArrayList<HttpFileInfo>();
            filesToDownload.add(info);
            DownloadTask task = new DownloadTask(siteInfo, file.getParentFile(), filesToDownload);
            task.start();
            Map<HttpFileInfo, String> failedList = task.getDownloadFailedFiles();
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }
}

