/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.download.httpdownload.DMConfig;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadTask;
import com.kingdee.eas.client.startup.update.download.httpdownload.DownloadWorker;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpClientDownloadWorker;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.ObjectFIFO;
import com.kingdee.eas.client.startup.update.download.httpdownload.util.ThreadPool;
import java.util.Map;
import org.apache.log4j.Logger;

final class DownloadManager
extends Thread {
    private static final Logger logger = ClientStartLogger.getLogger();
    private static final DownloadManager instance = new DownloadManager();
    private DMConfig downloadConfig;
    private ThreadPool threadPool;
    private ObjectFIFO downloadWorkers = new ObjectFIFO(10000);

    private DownloadManager() {
        this.downloadConfig = DMConfig.getConfig();
        this.threadPool = new ThreadPool(this.downloadConfig.getTotalDownloadThreads());
        this.setName("DownloadMangerThread");
        this.start();
    }

    public static DownloadManager getInstance() {
        return instance;
    }

    DMConfig getDownloadManagerConfig() {
        return this.downloadConfig;
    }

    void runTask(DownloadTask task) throws InterruptedException {
        Map map = task.getFilesToDownload();
        for (HttpFileInfo fileToDownload : map.keySet()) {
            this.downloadWorkers.add(new HttpClientDownloadWorker(task, fileToDownload));
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.threadPool.execute((DownloadWorker)this.downloadWorkers.remove());
                }
            }
            catch (InterruptedException ex) {
                logger.error((Object)"", (Throwable)ex);
                continue;
            }
            break;
        }
    }
}

