/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.download.httpdownload.util;

public final class ObjectFIFO {
    private Object[] queue;
    private int capacity;
    private int size;
    private int head;
    private int tail;

    public ObjectFIFO(int cap) {
        this.capacity = cap > 0 ? cap : 1;
        this.queue = new Object[this.capacity];
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean isFull() {
        return this.size == this.capacity;
    }

    public synchronized void add(Object obj) throws InterruptedException {
        this.waitWhileFull();
        this.queue[this.head] = obj;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        this.notifyAll();
    }

    public synchronized void addEach(Object[] list) throws InterruptedException {
        for (int i = 0; i < list.length; ++i) {
            this.add(list[i]);
        }
    }

    public synchronized Object remove() throws InterruptedException {
        this.waitWhileEmpty();
        Object obj = this.queue[this.tail];
        this.queue[this.tail] = null;
        this.tail = (this.tail + 1) % this.capacity;
        --this.size;
        this.notifyAll();
        return obj;
    }

    public synchronized Object[] removeAll() throws InterruptedException {
        Object[] list = new Object[this.size];
        for (int i = 0; i < list.length; ++i) {
            list[i] = this.remove();
        }
        return list;
    }

    public synchronized Object[] removeAtLeastOne() throws InterruptedException {
        this.waitWhileEmpty();
        return this.removeAll();
    }

    public synchronized boolean waitUntilEmpty(long msTimeout) throws InterruptedException {
        if (msTimeout == 0L) {
            this.waitUntilEmpty();
            return true;
        }
        long endTime = System.currentTimeMillis() + msTimeout;
        long msRemaining = msTimeout;
        while (!this.isEmpty() && msRemaining > 0L) {
            this.wait(msRemaining);
            msRemaining = endTime - System.currentTimeMillis();
        }
        return this.isEmpty();
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilFull() throws InterruptedException {
        while (!this.isFull()) {
            this.wait();
        }
    }

    public synchronized void waitWhileFull() throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
    }
}

