/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.handler.odds.config;

import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.download.httpdownload.HttpFileInfo;
import com.kingdee.eas.client.startup.update.handler.odds.config.ClientOddsProperties;
import com.kingdee.eas.client.startup.update.handler.odds.config.OddsJar;
import com.kingdee.eas.client.startup.update.handler.odds.config.ServerOddsProperties;
import com.kingdee.eas.client.startup.update.handler.odds.config.UpdateOddsList;
import com.kingdee.eas.client.startup.util.StringUtil;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OddsConfigs {
    private static final String logTitle = "[\u589e\u91cf\u66f4\u65b0] ";
    private static final Logger logger = ClientStartLogger.getLogger();
    private ClientOddsProperties clientOdds = new ClientOddsProperties();
    private ServerOddsProperties serverOdds = new ServerOddsProperties();
    private UpdateOddsList updateOdds = new UpdateOddsList();
    private static OddsConfigs instance;

    public static OddsConfigs getInstance() {
        if (null == instance) {
            instance = new OddsConfigs();
        }
        return instance;
    }

    private OddsConfigs() {
    }

    public void updateClientOddsProperties2(List<HttpFileInfo> successed) {
        for (HttpFileInfo file : successed) {
            String filePath = file.getSavePath();
            String newVersion = this.serverOdds.getNewestVersion(filePath);
            if (StringUtil.isEmptyValue(newVersion)) continue;
            this.clientOdds.update2NewVersion(filePath, newVersion);
        }
        this.clientOdds.store();
    }

    public void updateClientOddsProperties(List<EASClientFile> successed) {
        for (EASClientFile file : successed) {
            String filePath = file.getPath();
            String newVersion = this.serverOdds.getNewestVersion(filePath);
            if (StringUtil.isEmptyValue(newVersion)) continue;
            this.clientOdds.update2NewVersion(filePath, newVersion);
        }
        this.clientOdds.store();
    }

    public OddsJar findOddJar(String filePath) {
        if (!this.clientOdds.existLocalVersion(filePath)) {
            logger.info((Object)("[\u589e\u91cf\u66f4\u65b0] \u4e0d\u9002\u7528\u589e\u91cf\u66f4\u65b0\uff0c\u6ca1\u6709\u672c\u5730\u5dee\u5f02\u66f4\u65b0\u7248\u672c\u53f7\uff1a[" + filePath + "]"));
            return null;
        }
        if (!this.serverOdds.existNewestVersion(filePath)) {
            logger.info((Object)("[\u589e\u91cf\u66f4\u65b0] \u4e0d\u9002\u7528\u589e\u91cf\u66f4\u65b0\uff0c\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6\u7684\u670d\u52a1\u7aef\u5dee\u5f02\u6700\u65b0\u7248\u672c\u53f7\uff1a[" + filePath + "]"));
            return null;
        }
        if (!this.updateOdds.existOddsFile(filePath)) {
            logger.error((Object)("[\u589e\u91cf\u66f4\u65b0] \u4e0d\u9002\u7528\u589e\u91cf\u66f4\u65b0\uff0c\u670d\u52a1\u7aef\u5dee\u5f02\u6587\u4ef6updateodds.lst\u4e2d \u6ca1\u6709\u8be5\u6587\u4ef6\u7684\u5dee\u5f02\u5305\u4fe1\u606f\uff1a[" + filePath + "]"));
            return null;
        }
        String localVersion = this.clientOdds.getLocalVersion(filePath);
        logger.info((Object)("[\u589e\u91cf\u66f4\u65b0] \u672c\u5730\u65e7\u5305\u7248\u672c\u53f7\u4e3a[" + filePath + "]=[" + localVersion + "]"));
        String newestVersion = this.serverOdds.getNewestVersion(filePath);
        logger.info((Object)("[\u589e\u91cf\u66f4\u65b0] \u670d\u52a1\u7aef\u65b0\u5305\u6700\u65b0\u7248\u672c\u53f7\u4e3a[" + newestVersion + "]"));
        return this.updateOdds.findOddJar(filePath, localVersion, newestVersion);
    }
}

