/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.util;

import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.update.download.httpdownload.kill.DeleteFileUtil;
import java.io.File;
import java.io.IOException;

public final class FileUtil {
    public static void deleteFiles(File file, boolean isDeleteSelf) {
        if (file.isDirectory()) {
            File[] fe = file.listFiles();
            for (int i = 0; i < fe.length; ++i) {
                FileUtil.deleteFiles(fe[i], true);
                fe[i].delete();
            }
        }
        if (isDeleteSelf) {
            file.delete();
        }
    }

    public static String computeRelativePath(File root, File file) {
        try {
            String rootPath = root.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            int index = filePath.indexOf(rootPath);
            if (index != 0) {
                return filePath;
            }
            String relativePath = filePath.substring(rootPath.length() + 1);
            relativePath = relativePath.replaceAll("\\\\", "/");
            return relativePath;
        }
        catch (IOException e) {
            throw EASClientException.convert(e);
        }
    }

    public static void replace(File downloadTemp, File destFile) {
        boolean b;
        if (destFile.exists()) {
            try {
                DeleteFileUtil.deleteFile(destFile);
            }
            catch (IOException e) {
                throw EASClientException.convert(e);
            }
        }
        if (!(b = downloadTemp.renameTo(destFile))) {
            EASClientException ex = new EASClientException("\u66f4\u65b0\u5931\u8d25,\u6587\u4ef6" + destFile + "\u6b63\u5728\u88ab\u4f7f\u7528");
            ex.setSolution("\u8bf7\u5c1d\u8bd5\u901a\u8fc7\u4ee5\u4e0b\u65b9\u5f0f\u89e3\u51b3\u672c\u95ee\u9898\uff1a\r\n1.\u9000\u51fa\u5176\u4ed6\u6b63\u5728\u4f7f\u7528\u7684eas\u5ba2\u6237\u7aef\uff0c\u91cd\u65b0\u542f\u52a8eas\u5ba2\u6237\u7aef\r\n2.\u5982\u679c\u4e0a\u8ff0\u65b9\u6cd5\u65e0\u6cd5\u89e3\u51b3\uff0c\u8bf7\u8fd0\u884c\"EAS\u670d\u52a1\u5668\u8fde\u63a5\u8bbe\u7f6e\",\u53bb\u6389\u5bf9\"\u6309\u9700\u66f4\u65b0\"\u7684\u9009\u62e9,\u91cd\u65b0\u542f\u52a8eas\u5ba2\u6237\u7aef");
            throw ex;
        }
    }
}

